#!/usr/bin/perl -w

## This script takes the grammar.src file, as modified by the sed
## script in the Makefile, and converts it to a form that Java CUP
## version 0.10j likes.

## {RESULT.set(x,y,z)}  -->  {: RESULT = new fooNode(); RESULT.set(x,y,z); :}
## {RESULT = a.set(z)}  -->  {: RESULT = a; RESULT.set(z); :}
##                  {}  -->  {: RESULT = new fooNode(); :}

### possible future addition ###
## For ListNodes (and FactoredListNodes?):
## {RESULT.add(v,x)}  -->  {: RESULT = v.add(x); :}
### possible future addition ###

%nodetable = ();
$nodetype = "";

sub setNode($$) {
    my ($abstract, $concrete) = @_;
    $nodetable{$abstract} = $concrete;
}

sub getNode($) {
    my ($abstract) = @_;
    return $nodetable{$abstract};
}

while (<>) {
    if (m/^\/\//) {  ## do nothing with commented-out lines
        print;
        next;
    }
    if (m/non terminal/) {  ## e.g. non terminal sortNode compoundSort;
        @words = split /\W+/;
        setNode($words[3], $words[2]);
        print;
        next;
    }
    if (m/::=/) {  ## record what kind of Node is on the left-hand side.
        @parts = split /\s+::=\s+/;
        $nodetype = getNode($parts[0]);
    }
    if (m/RESULT =/) {
        ## add semicolon and colons to an already-good expression
        s/{(RESULT = [a-z]+)}/{: $1; :}/;
        ## if there is a . in the right-hand side, do as follows:
        ## {RESULT = a.set(z)} -->  {: RESULT = a; RESULT.set(z); :}
        s/{RESULT = ([a-z]+)(\.\w+\(.*)}/{: RESULT = $1; RESULT$2; :}/;
        ## (why doesn't the following line DTRT for both cases?)
        ## s/{(RESULT = [a-z]+\.*)}/{: $1; :}/;
    } elsif (m/RESULT\./) {
        ## {RESULT.set(x,y,z)}  -->
        ##         {: RESULT = new fooNode(); RESULT.set(x,y,z); :}
        s/{RESULT\.(.+)}/{: RESULT = new $nodetype\(\); RESULT.$1; :}/;
    } elsif (m/{}/) {
        ## {}  -->  {: RESULT = new fooNode(); :}
        s/{}/{: RESULT = new $nodetype(); :}/;
    }
    print;
}
