/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util.logger;

import com.veromodo.tioa.util.logger.IOAPriority;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class Logger {
    public static final Priority DEBUG = Priority.DEBUG;
    public static final Priority INFO = Priority.INFO;
    public static final Priority WARN = Priority.WARN;
    public static final Priority ERROR = Priority.ERROR;
    public static final Priority FATAL = Priority.FATAL;

    public static Priority getDebugPriority(int level) {
        return IOAPriority.getDebugPriority(level);
    }

    public static void setupLogs(Priority p, String pattern) {
        PatternLayout layout = new PatternLayout(pattern);
        ConsoleAppender app = new ConsoleAppender((Layout)layout, "System.err");
        Category.getRoot().removeAllAppenders();
        Category.getRoot().addAppender((Appender)app);
        Category.getRoot().setPriority(p);
        Category.getRoot().debug((Object)("Installed logger at priority " + p));
    }

    public static void setupLogs() {
        Logger.setupLogs(INFO);
    }

    public static void setupLogs(Priority p) {
        Logger.setupLogs(p, "@ %24.24c{2}: %m%n");
    }

    public static void setPriority(String s, Priority p) {
        Category.getInstance((String)s).setPriority(p);
    }
}

