/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util.logger;

import com.veromodo.tioa.util.logger.IOAPriority;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class IOACategory {
    protected Category cat;

    public static IOACategory getInstance(String name) {
        return new IOACategory(Category.getInstance((String)name));
    }

    public static IOACategory getRoot() {
        return new IOACategory(Category.getRoot());
    }

    protected IOACategory(Category cat) {
        this.cat = cat;
    }

    public Category getCategory() {
        return this.cat;
    }

    public void log(Priority p, Object msg, Throwable t) {
        this.cat.log(p, msg, t);
    }

    public void log(Priority p, Object msg) {
        this.log(p, msg, null);
    }

    public void debug(int level, Object msg, Throwable t) {
        this.log(IOAPriority.getDebugPriority(level), msg, t);
    }

    public void debug(int level, Object msg) {
        this.debug(level, msg, null);
    }

    public void debug(Object msg) {
        this.cat.debug(msg);
    }

    public void debug(Object msg, Throwable t) {
        this.cat.debug(msg, t);
    }

    public void info(Object msg) {
        this.cat.info(msg);
    }

    public void info(Object msg, Throwable t) {
        this.cat.info(msg, t);
    }

    public void warn(Object msg) {
        this.cat.warn(msg);
    }

    public void warn(Object msg, Throwable t) {
        this.cat.warn(msg, t);
    }

    public void error(Object msg) {
        this.cat.error(msg);
    }

    public void error(Object msg, Throwable t) {
        this.cat.error(msg, t);
    }

    public void fatal(Object msg) {
        this.cat.fatal(msg);
    }

    public void fatal(Object msg, Throwable t) {
        this.cat.fatal(msg, t);
    }

    public void setPriority(Priority p) {
        this.cat.setPriority(p);
    }

    public Priority getPriority() {
        return this.cat.getPriority();
    }

    public boolean isDebugEnabled() {
        return this.cat.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.cat.isInfoEnabled();
    }

    public boolean isEnabledFor(Priority p) {
        return this.cat.isEnabledFor(p);
    }

    public String toString() {
        return "IOACategory: " + this.cat.toString();
    }
}

