/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.util;

import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.il.util.SetException;
import com.veromodo.tioa.il.util.VarSet;
import java.util.Enumeration;

public class FreeVarSet {
    protected VarSet free = new VarSet();
    protected VarSet bound = new VarSet();

    public void add(Variable v) {
        if (!this.bound.contains(v)) {
            this.free.add(v);
        }
    }

    public void removeFree(Variable v) {
        this.free.remove(v);
    }

    public void addBound(Variable v) throws SetException {
        if (this.free.contains(v)) {
            throw new SetException(v + " was already a free variable");
        }
        this.bound.add(v);
    }

    public void removeBound(Variable v) {
        this.bound.remove(v);
    }

    public Enumeration enumFreeVars() {
        return this.free.enumMembers();
    }

    public Enumeration enumBoundVars() {
        return this.bound.enumMembers();
    }

    public boolean isFree(Variable v) {
        return this.free.contains(v);
    }

    public boolean isBound(Variable v) {
        return this.bound.contains(v);
    }

    public String toString() {
        return "FreeVarSet: [" + this.free + "][" + this.bound + "]";
    }
}

