/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.Automaton;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.BasicProofTrajEntry;
import com.veromodo.tioa.il.nodes.BasicProofTransEntry;
import com.veromodo.tioa.il.nodes.BasicSimulationRelation;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.SimulationRelation;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.il.nodes.TrajectoryTable;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SExpException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class NDRSimulationRelation
extends BasicSimulationRelation {
    private static final IOACategory cat = IOACategory.getInstance(NDRSimulationRelation.class.getName());
    public final String KEYW_PROOF = "proof";
    protected StateTable proofStates = null;
    protected Vector<Term> initLefts = new Vector();
    protected Vector<Term> initTerms = new Vector();
    protected HashMap<Transition, BasicProofTransEntry> transEntries = new HashMap();
    protected HashMap<Trajectory, BasicProofTrajEntry> trajEntries = new HashMap();
    static /* synthetic */ Class class$0;

    public NDRSimulationRelation(int kind, Automaton autImpl, Automaton autSpec, Term pred) {
        super(kind, autImpl, autSpec, pred);
    }

    public Map getTransEntries() {
        return Collections.unmodifiableMap(this.transEntries);
    }

    public Map getTrajEntries() {
        return Collections.unmodifiableMap(this.trajEntries);
    }

    public List getInitLefts() {
        return Collections.unmodifiableList(this.initLefts);
    }

    public List getInitTerms() {
        return Collections.unmodifiableList(this.initTerms);
    }

    public void parseExtension(SList sexp, ILParser parser) throws ILException, SExpException, IOException {
        if (cat.isDebugEnabled()) {
            cat.debug("parseExtension: " + sexp.toString() + ";");
        }
        parser.assertLengthMin(sexp, 1);
        String head = sexp.getString(0);
        if (head.equals("proof")) {
            parser.assertLengthMin(sexp, 4);
            this.proofStates = parser.parseStates(sexp.getSList(1), new Term[1]);
            SList sexpInits = sexp.getSList(2);
            Iterator i = sexpInits.iterator();
            while (i.hasNext()) {
                SList sexpInitPair = SExp.getSList(i.next());
                parser.assertLength(sexpInitPair, 2);
                this.initLefts.addElement(parser.parseTerm((SValue)sexpInitPair.get(0)));
                this.initTerms.addElement(parser.parseTerm((SValue)sexpInitPair.get(1)));
            }
            SList sexpProofEntryList = sexp.getSList(3);
            Iterator i2 = sexpProofEntryList.iterator();
            while (i2.hasNext()) {
                ActionTable actions;
                SList sexpProofEntry = SExp.getSList((Object)((SValue)i2.next()));
                parser.assertLengthMin(sexpProofEntry, 4);
                if (sexpProofEntry.get(0).toString().equals("sim_trans_entry")) {
                    Transition t = this.autImpl.getActionTable().getTransition(sexpProofEntry.getString(1));
                    Vector<Term> f = parser.parseFormals(sexpProofEntry.getSList(2));
                    SList sexpSpecFireList = sexpProofEntry.getSList(3);
                    actions = parser.actions;
                    parser.actions = this.autSpec.getActionTable();
                    Program p = parser.parseProgram(sexpSpecFireList);
                    BasicProofTransEntry entry = new BasicProofTransEntry(t, f, p);
                    parser.parseExtensions(entry, sexpProofEntry.rest(4));
                    this.addTransEntry(entry);
                    parser.actions = actions;
                    continue;
                }
                if (sexpProofEntry.get(0).toString().equals("sim_traj_entry")) {
                    Trajectory tj = this.autImpl.getTrajectoryTable().getTrajectory(sexpProofEntry.getString(1));
                    VarRefTerm var = (VarRefTerm)parser.parseTerm(sexpProofEntry.getSValue(2));
                    SList sexpSpecEntryList = sexpProofEntry.getSList(3);
                    actions = parser.actions;
                    parser.actions = this.autSpec.getActionTable();
                    TrajectoryTable trajectories = parser.trajTable;
                    parser.trajTable = this.autSpec.getTrajectoryTable();
                    Program p = parser.parseProgram(sexpSpecEntryList);
                    BasicProofTrajEntry entry = new BasicProofTrajEntry(tj, var, p);
                    parser.parseExtensions(entry, sexpProofEntry.rest(4));
                    this.addTrajEntry(entry);
                    parser.actions = actions;
                    parser.trajTable = trajectories;
                    continue;
                }
                throw new ILException("sim_trans_entry or sim_traj_entry expected but not found");
            }
        } else {
            super.parseExtension(sexp, parser);
        }
    }

    protected void addTransEntry(BasicProofTransEntry entry) {
        this.transEntries.put(entry.getTrans(), entry);
    }

    protected void addTrajEntry(BasicProofTrajEntry entry) {
        this.trajEntries.put(entry.getTraj(), entry);
    }

    protected NDRSimulationRelation(SimulationRelation obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
        if (obj instanceof NDRSimulationRelation) {
            NDRSimulationRelation srel = (NDRSimulationRelation)obj;
            this.initLefts = f.instanceVector(srel.initLefts);
            this.initTerms = f.instanceVector(srel.initTerms);
            this.transEntries = new HashMap();
            this.trajEntries = new HashMap();
            Iterator<BasicILElement> iEntries = srel.transEntries.values().iterator();
            while (iEntries.hasNext()) {
                this.addTransEntry((BasicProofTransEntry)f.makeInstance(iEntries.next()));
            }
            iEntries = srel.trajEntries.values().iterator();
            while (iEntries.hasNext()) {
                this.addTrajEntry((BasicProofTrajEntry)f.makeInstance(iEntries.next()));
            }
        }
    }

    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        super.internalSurgery(f);
        this.initLefts = f.instanceVector(this.initLefts);
        this.initTerms = f.instanceVector(this.initTerms);
        HashMap<Transition, BasicProofTransEntry> transEntries2 = this.transEntries;
        this.transEntries = new HashMap();
        Iterator<BasicProofTransEntry> iEntries = transEntries2.values().iterator();
        while (iEntries.hasNext()) {
            this.addTransEntry((BasicProofTransEntry)f.makeInstance(iEntries.next()));
        }
        HashMap<Trajectory, BasicProofTrajEntry> trajEntries2 = this.trajEntries;
        this.trajEntries = new HashMap();
        Iterator<BasicProofTrajEntry> iEntries2 = trajEntries2.values().iterator();
        while (iEntries2.hasNext()) {
            this.addTrajEntry((BasicProofTrajEntry)f.makeInstance(iEntries2.next()));
        }
        return this;
    }

    public SValue toSValue() {
        SList result = (SList)super.toSValue();
        if (this.proofStates == null) {
            return result;
        }
        SList proofList = new SList(new SValue[]{SExp.makeSValue((String)"proof")});
        proofList.add((Object)this.proofStates.toSValue());
        SList initVars = new SList();
        int i = 0;
        while (i < this.initLefts.size()) {
            Term left = this.initLefts.get(i);
            Term right = this.initTerms.get(i);
            SList initPair = new SList(new SValue[]{left.toSValue(), right.toSValue()});
            initVars.add((Object)initPair);
            ++i;
        }
        proofList.add((Object)initVars);
        SList proofTransEntries = new SList();
        for (Transition o : this.transEntries.keySet()) {
            BasicProofTransEntry entry = this.transEntries.get(o);
            proofTransEntries.add((Object)entry.toSValue());
        }
        proofList.add((Object)proofTransEntries);
        SList proofTrajEntries = new SList();
        for (Trajectory o : this.trajEntries.keySet()) {
            BasicProofTrajEntry entry = this.trajEntries.get(o);
            proofTrajEntries.add((Object)entry.toSValue());
        }
        proofList.add((Object)proofTrajEntries);
        result.add((Object)proofList);
        return result;
    }
}

