/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.BasicPrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Task;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.TrajectoryTable;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SExpException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDRPrimitiveAutomaton
extends BasicPrimitiveAutomaton {
    public static final String KEYW_SCHEDULE = "schedule";
    public static final String KEYW_DET = "det";
    private static final IOACategory cat = IOACategory.getInstance(NDRPrimitiveAutomaton.class.getName());
    protected Program initProgram = null;
    protected StateTable ndrStates = null;
    protected Program ndrProgram = null;
    static /* synthetic */ Class class$0;

    public NDRPrimitiveAutomaton(String name, Vector<Term> formals, Term where, ActionTable actions, StateTable states, Vector<FuncDecl> funcDecls, Term soThat, Vector<Task> tasks, TrajectoryTable trajectories) {
        super(name, formals, where, actions, states, funcDecls, soThat, tasks, trajectories);
    }

    public NDRPrimitiveAutomaton() {
    }

    protected NDRPrimitiveAutomaton(PrimitiveAutomaton obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
    }

    @Override
    public void parseExtension(SList sexp, ILParser parser) throws ILException, SExpException, IOException {
        cat.debug("Parsing extension: " + sexp.toString());
        parser.assertLengthMin(sexp, 1);
        String head = sexp.getString(0);
        if (head.equals(KEYW_SCHEDULE)) {
            parser.assertLength(sexp, 3);
            this.ndrStates = parser.parseStates(sexp.getSList(1), new Term[1]);
            this.ndrProgram = parser.parseProgram(sexp.getSList(2));
        }
        if (head.equals(KEYW_DET)) {
            parser.assertLengthMin(sexp, 2);
            this.initProgram = parser.parseProgram(sexp.rest(1));
        } else {
            super.parseExtension(sexp, parser);
        }
    }

    public Program getInitProgram() {
        return this.initProgram;
    }

    public StateTable getNDRStates() {
        return this.ndrStates;
    }

    public Program getNDRProgram() {
        return this.ndrProgram;
    }

    @Override
    public SValue toSValue() {
        SList automaton = (SList)super.toSValue();
        if (this.ndrStates != null) {
            SList first = (SList)automaton.getLast();
            SList schedule = SExp.makeSList((SValue)SExp.makeSValue((String)KEYW_SCHEDULE), (SValue)this.ndrStates.toSValue(), (SValue)this.ndrProgram.toSValue());
            first.add((Object)schedule);
        }
        return automaton;
    }
}

