/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.BasicStatement;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.PairedFire;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDRPairedFire
extends BasicStatement
implements PairedFire {
    protected Transition trans;
    protected Vector<Term> actuals;
    protected Vector<Variable> substVars;
    protected Vector<Term> substTerms;

    @Override
    public Transition getTrans() {
        return this.trans;
    }

    @Override
    public Vector<Term> getActuals() {
        return this.actuals;
    }

    @Override
    public Vector<Variable> getSubstVars() {
        return this.substVars;
    }

    @Override
    public Vector<Term> getSubstTerms() {
        return this.substTerms;
    }

    public NDRPairedFire(Transition trans, Vector<Term> actuals, Vector<Variable> substVars, Vector<Term> substTerms) {
        this.trans = trans;
        this.actuals = actuals;
        this.substVars = substVars;
        this.substTerms = substTerms;
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instancePairedFire(this);
    }

    public NDRPairedFire(PairedFire obj, ILInstanceFactory f) throws ILException {
        this.trans = f.instanceTransition(obj.getTrans());
        this.actuals = f.instanceVector(obj.getActuals());
        this.substVars = f.instanceVector(obj.getSubstVars());
        this.substVars = f.instanceVector(obj.getSubstVars());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.trans = f.instanceTransition(this.trans);
        this.actuals = f.instanceVector(this.actuals);
        this.substVars = f.instanceVector(this.substVars);
        this.substVars = f.instanceVector(this.substVars);
        return this;
    }

    public SValue toSValue() {
        SList result = new SList();
        result.add((Object)SExp.makeSValue((String)"sim_fire"));
        result.add((Object)SExp.makeSValue((String)this.trans.getTransitionId()));
        SList actualsList = new SList();
        actualsList.add((Object)SExp.makeSValue((String)"actuals"));
        for (Term t : this.actuals) {
            actualsList.add((Object)t.toSValue());
        }
        result.add((Object)actualsList);
        return result;
    }

    @Override
    public String toString() {
        return this.toSValue().toString();
    }
}

