/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.TempComponent;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.Automaton;
import com.veromodo.tioa.il.nodes.BasicILFactory;
import com.veromodo.tioa.il.nodes.Choice;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.SimulationRelation;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Statement;
import com.veromodo.tioa.il.nodes.Task;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.il.nodes.TrajectoryTable;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.il.nodes.ndr.NDRChoice;
import com.veromodo.tioa.il.nodes.ndr.NDRFire;
import com.veromodo.tioa.il.nodes.ndr.NDRFollowTrajectory;
import com.veromodo.tioa.il.nodes.ndr.NDRPairedFire;
import com.veromodo.tioa.il.nodes.ndr.NDRPairedFollow;
import com.veromodo.tioa.il.nodes.ndr.NDRPrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.ndr.NDRSimulationRelation;
import com.veromodo.tioa.il.nodes.ndr.NDRWhile;
import com.veromodo.tioa.il.nodes.ndr.NDRYield;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExpException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDRILFactory
extends BasicILFactory {
    public static final String KEYW_YIELD = "yield";
    public static final String KEYW_NDR_FIRE = "fire";
    public static final String KEYW_NDR_FOLLOW = "follow";
    public static final String KEYW_WHILE = "while";
    public static final String KEYW_NOP = "nop";
    public static final String KEYW_SIM_FIRE = "sim_fire";
    public static final String KEYW_SIM_FOLLOW = "sim_follow";
    public static final String KEYW_USING = "using";
    private static final IOACategory cat = IOACategory.getInstance(NDRILFactory.class.getName());
    static /* synthetic */ Class class$0;

    @Override
    public Choice newChoice(Variable var, Term where) throws ILException {
        return new NDRChoice(var, where);
    }

    @Override
    public PrimitiveAutomaton newPrimitiveAutomaton(String name, Vector<Term> formals, Term where, ActionTable actions, StateTable states, Vector<FuncDecl> funcDecls, Term soThat, Vector<Task> tasks, TrajectoryTable trajectories) throws ILException {
        return new NDRPrimitiveAutomaton(name, formals, where, actions, states, funcDecls, soThat, tasks, trajectories);
    }

    @Override
    public PrimitiveAutomaton newPrimitiveAutomaton() throws ILException {
        return new NDRPrimitiveAutomaton();
    }

    @Override
    public SimulationRelation newSimulationRelation(int kind, Automaton autImpl, Automaton autSpec, Term pred) throws ILException {
        return new NDRSimulationRelation(kind, autImpl, autSpec, pred);
    }

    public NDRFire newNDRFire(NDRPrimitiveAutomaton aut, Transition trans, Vector<Term> actuals) throws ILException {
        return new NDRFire(aut, trans, actuals);
    }

    public NDRFire newNDRFire(NDRPrimitiveAutomaton aut) throws ILException {
        return new NDRFire(aut);
    }

    public NDRFollowTrajectory newNDRFollowTrajectory(NDRPrimitiveAutomaton aut, Trajectory traj, Term duration) {
        return new NDRFollowTrajectory(aut, traj, duration);
    }

    public NDRYield newNDRYield(Term term) throws ILException {
        return new NDRYield(term);
    }

    public NDRWhile newNDRWhile(Term pred, Program prog) throws ILException {
        return new NDRWhile(pred, prog);
    }

    public NDRPairedFire newNDRPairedFire(Transition trans, Vector actuals, Vector substVars, Vector substTerms) {
        return new NDRPairedFire(trans, actuals, substVars, substTerms);
    }

    public NDRPairedFollow newNDRPairedFollow(Trajectory traj, Term duration) {
        return new NDRPairedFollow(traj, duration);
    }

    @Override
    public Statement parseExtendedStatement(String head, SList sexp, ILParser parser) throws ILException, SExpException, IOException {
        NDRILFactory fact = (NDRILFactory)ILFactory.getInstance();
        if (cat.isDebugEnabled()) {
            cat.debug("parseExtendedStatement: " + head + " " + sexp.toString());
        }
        parser.assertLengthMin(sexp, 1);
        Statement stmt = null;
        SList trailingSexp = null;
        if (head.equals(KEYW_NDR_FIRE)) {
            Transition trans = null;
            int sexpSize = sexp.size();
            switch (sexpSize) {
                case 1: {
                    cat.debug(" FIRE statement by itslef");
                    stmt = fact.newNDRFire((NDRPrimitiveAutomaton)parser.curPrimAut);
                    trailingSexp = sexp.rest(1);
                    break;
                }
                case 2: {
                    cat.debug("// No Automaton Name or Parameters ");
                    trans = parser.actions.getTransition(sexp.getString(1));
                    Vector<Term> actuals = new Vector<Term>();
                    trailingSexp = sexp.rest(2);
                    stmt = fact.newNDRFire((NDRPrimitiveAutomaton)parser.curPrimAut, trans, actuals);
                    break;
                }
                case 3: {
                    if (sexp.get(2) instanceof SList) {
                        cat.debug("// No Automaton Name, Yes Parameters ");
                        trans = parser.actions.getTransition(sexp.getString(1));
                        Vector<Term> actuals = parser.parseActionActuals(sexp.getSList(2));
                        trailingSexp = sexp.rest(3);
                        stmt = fact.newNDRFire((NDRPrimitiveAutomaton)parser.curPrimAut, trans, actuals);
                        break;
                    }
                    cat.debug("// Automaton Name, No Parameters ");
                    String startCompName = null;
                    TempComponent tempComp = null;
                    String handleName = null;
                    String autName = sexp.getString(1);
                    String compName = parser.getCompName(autName);
                    if (compName != null) {
                        handleName = autName;
                        autName = parser.getTempComp(compName).getBaseName();
                    } else {
                        tempComp = parser.getTempComp(autName);
                        if (tempComp != null) {
                            startCompName = autName;
                            autName = tempComp.getBaseName();
                        }
                    }
                    cat.debug("// Automaton Name :  " + autName);
                    cat.debug("// Transition Name :  " + sexp.getString(2));
                    NDRPrimitiveAutomaton ndrPrimAut = (NDRPrimitiveAutomaton)parser.getSpecInProgress().getAutomaton(autName);
                    trans = ndrPrimAut.getActionTable().getTransition(sexp.getString(2));
                    Vector<Term> actuals = new Vector<Term>();
                    trailingSexp = sexp.rest(3);
                    NDRFire fireSt = fact.newNDRFire(ndrPrimAut, trans, actuals);
                    fireSt.setComposite();
                    if (compName != null) {
                        fireSt.handleName = handleName;
                    }
                    if (tempComp != null) {
                        fireSt.handleName = startCompName;
                    }
                    stmt = fireSt;
                    break;
                }
                case 4: {
                    cat.debug("// Automaton Name and Parameters");
                    String startCompName = null;
                    TempComponent tempComp = null;
                    String handleName = null;
                    String autName = sexp.getString(1);
                    String compName = parser.getCompName(autName);
                    if (compName != null) {
                        handleName = autName;
                        autName = parser.getTempComp(compName).getBaseName();
                    } else {
                        tempComp = parser.getTempComp(autName);
                        if (tempComp != null) {
                            startCompName = autName;
                            autName = tempComp.getBaseName();
                        }
                    }
                    cat.debug("// Automaton Name :  " + autName);
                    cat.debug("// Transition Name :  " + sexp.getString(2));
                    NDRPrimitiveAutomaton ndrPrimAut = (NDRPrimitiveAutomaton)parser.getSpecInProgress().getAutomaton(autName);
                    trans = ndrPrimAut.getActionTable().getTransition(sexp.getString(2));
                    Vector<Term> actuals = parser.parseActionActuals(sexp.getSList(3));
                    trailingSexp = sexp.rest(4);
                    NDRFire fireSt = fact.newNDRFire(ndrPrimAut, trans, actuals);
                    fireSt.setComposite();
                    if (compName != null) {
                        fireSt.handleName = handleName;
                    }
                    if (tempComp != null) {
                        fireSt.handleName = startCompName;
                    }
                    stmt = fireSt;
                }
            }
            cat.debug("Done Parsing this Fire");
        } else if (head.equals(KEYW_YIELD)) {
            parser.assertLengthMin(sexp, 2);
            Term term = parser.parseTerm((SValue)sexp.get(1));
            stmt = fact.newNDRYield(term);
            trailingSexp = sexp.rest(2);
        } else if (head.equals(KEYW_WHILE)) {
            parser.assertLengthMin(sexp, 3);
            Term pred = parser.parseTerm((SValue)sexp.get(1));
            Program prog = parser.parseProgram(sexp.getSList(2));
            stmt = fact.newNDRWhile(pred, prog);
            trailingSexp = sexp.rest(3);
        } else if (head.equals(KEYW_SIM_FIRE)) {
            StatementAndTrailing st = this.parsePairedFire(parser, sexp);
            stmt = st.stmt;
            trailingSexp = st.trailingSexp;
        } else if (head.equals(KEYW_SIM_FOLLOW)) {
            StatementAndTrailing st = this.parsePairedFollow(parser, sexp);
            stmt = st.stmt;
            trailingSexp = st.trailingSexp;
        } else if (head.equals(KEYW_NDR_FOLLOW)) {
            parser.assertLengthMin(sexp, 3);
            if (sexp.size() > 3) {
                TempComponent tempComp = null;
                String autName = sexp.getString(1);
                String compName = parser.getCompName(autName);
                String handleName = null;
                String startCompName = null;
                if (compName != null) {
                    cat.debug("compName = " + compName);
                    handleName = autName;
                    autName = parser.getTempComp(compName).getBaseName();
                } else {
                    cat.debug("compName == null");
                    tempComp = parser.getTempComp(autName);
                    if (tempComp != null) {
                        startCompName = autName;
                        autName = tempComp.getBaseName();
                    }
                }
                NDRPrimitiveAutomaton ndrPrimAut = (NDRPrimitiveAutomaton)parser.getSpecInProgress().getAutomaton(autName);
                Trajectory tj = ndrPrimAut.getTrajectoryTable().getTrajectory(sexp.getString(2));
                Term duration = parser.parseTerm((SValue)sexp.get(3));
                NDRFollowTrajectory followSt = fact.newNDRFollowTrajectory(ndrPrimAut, tj, duration);
                followSt.setComposite();
                if (compName != null) {
                    followSt.handleName = handleName;
                }
                if (tempComp != null) {
                    followSt.handleName = startCompName;
                }
                stmt = followSt;
                trailingSexp = sexp.rest(4);
            } else {
                Trajectory tj = parser.trajTable.getTrajectory(sexp.getString(1));
                Term duration = parser.parseTerm((SValue)sexp.get(2));
                stmt = fact.newNDRFollowTrajectory((NDRPrimitiveAutomaton)parser.curPrimAut, tj, duration);
                trailingSexp = sexp.rest(3);
            }
        } else {
            return super.parseExtendedStatement(head, sexp, parser);
        }
        parser.parseExtensions(stmt, trailingSexp);
        return stmt;
    }

    private StatementAndTrailing parsePairedFire(ILParser parser, SList sexp) throws ILException, SExpException, IOException {
        parser.assertLengthMin(sexp, 2);
        boolean DOING_ACTUALS = true;
        int DOING_USING = 2;
        int DOING_EXTENSIONS = 3;
        Transition trans = parser.curSimRel.getSpecAutomaton().getActionTable().getTransition(sexp.getString(1));
        Vector<Object> actuals = new Vector();
        Vector<Variable> substVars = new Vector<Variable>();
        Vector<Term> substTerms = new Vector<Term>();
        int doing = 1;
        SList trailingSexp = null;
        trailingSexp = new SList();
        int i = 2;
        block4: while (i < sexp.size()) {
            SList itemSexp = sexp.getSList(i);
            parser.assertLengthMin(itemSexp, 1);
            String head2 = itemSexp.getString(0);
            switch (doing) {
                case 1: {
                    doing = 2;
                    if (head2.equals("actuals")) {
                        actuals = parser.parseActionActuals(itemSexp);
                        break;
                    }
                }
                case 2: {
                    doing = 3;
                    if (head2.equals(KEYW_USING)) {
                        substVars = new Vector();
                        substTerms = new Vector();
                        int j = 1;
                        while (j < itemSexp.size()) {
                            SList usingList = itemSexp.getSList(j);
                            parser.assertLength(usingList, 2);
                            substVars.add(parser.st.getVariable(usingList.getString(0)));
                            substTerms.add(parser.parseTerm((SValue)usingList.get(1)));
                            ++j;
                        }
                        trailingSexp = sexp.rest(i);
                        break block4;
                    }
                }
                default: {
                    trailingSexp = sexp.rest(i);
                    break block4;
                }
            }
            ++i;
        }
        NDRPairedFire stmt = this.newNDRPairedFire(trans, actuals, substVars, substTerms);
        return new StatementAndTrailing(stmt, trailingSexp);
    }

    private StatementAndTrailing parsePairedFollow(ILParser parser, SList sexp) throws ILException, SExpException, IOException {
        parser.assertLengthMin(sexp, 2);
        Trajectory traj = parser.curSimRel.getSpecAutomaton().getTrajectoryTable().getTrajectory(sexp.getString(1));
        Term duration = parser.parseTerm(sexp.getSValue(2));
        SList trailingSexp = sexp.rest(3);
        NDRPairedFollow stmt = this.newNDRPairedFollow(traj, duration);
        return new StatementAndTrailing(stmt, trailingSexp);
    }

    private static class StatementAndTrailing {
        public Statement stmt;
        public SList trailingSexp;

        public StatementAndTrailing(Statement stmt, SList trailingSexp) {
            this.stmt = stmt;
            this.trailingSexp = trailingSexp;
        }
    }
}

