/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes.ndr;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.TempComponent;
import com.veromodo.tioa.il.nodes.BasicCompositeAutomaton;
import com.veromodo.tioa.il.nodes.CompositeAutomaton;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SExpException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDRCompositeAutomaton
extends BasicCompositeAutomaton {
    public static final String KEYW_SCHEDULE = "schedule";
    private static final IOACategory cat = IOACategory.getInstance(NDRCompositeAutomaton.class.getName());
    protected StateTable ndrStates = null;
    protected Program ndrProgram = null;
    static /* synthetic */ Class class$0;

    public NDRCompositeAutomaton(String name, Vector<Term> formals, Term where) {
        super(name, formals, where);
    }

    protected NDRCompositeAutomaton(CompositeAutomaton obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
    }

    @Override
    public void parseExtension(SList sexp, ILParser parser) throws ILException, SExpException, IOException {
        cat.debug("Parsing extension: " + sexp.toString());
        parser.assertLengthMin(sexp, 1);
        String head = sexp.getString(0);
        if (head.equals(KEYW_SCHEDULE)) {
            cat.debug("Parsing schedule");
            parser.assertLengthMin(sexp, 3);
            SList firstList = sexp.getSList(1);
            if (firstList.getString(0).equals("with")) {
                int inits = firstList.size() - 1;
                cat.debug("With Block has " + inits + " lines.");
                int a = 0;
                while (a < inits) {
                    SList declaration = firstList.getSList(a + 1);
                    String handleName = declaration.getString(0);
                    String compName = declaration.getString(1);
                    parser.storeHandle(handleName, compName);
                    Vector withFormals = new Vector();
                    Vector<Term> withActuals = new Vector<Term>();
                    int numActuals = declaration.size() - 2;
                    int b = 0;
                    while (b < numActuals) {
                        withActuals.add(parser.parseTerm((SValue)declaration.get(b + 2)));
                        ++b;
                    }
                    TempComponent tComp = parser.getTempComp(compName);
                    String baseName = tComp.getBaseName();
                    cat.debug("Base Component is " + baseName);
                    PrimitiveAutomaton sAut = (PrimitiveAutomaton)parser.getSpecInProgress().getAutomaton(baseName);
                    PrimitiveAutomaton copiedAut = sAut.copy(handleName);
                    this.addComponent(copiedAut, tComp.getFormals(), tComp.getActuals(), tComp.getWhere(), handleName, withFormals, withActuals);
                    ++a;
                }
                this.ndrStates = parser.parseStates(sexp.getSList(2), new Term[1]);
                this.ndrProgram = parser.parseProgram(sexp.getSList(3));
            } else {
                this.ndrStates = parser.parseStates(sexp.getSList(1), new Term[1]);
                this.ndrProgram = parser.parseProgram(sexp.getSList(2));
            }
        } else {
            super.parseExtension(sexp, parser);
        }
    }

    public StateTable getNDRStates() {
        return this.ndrStates;
    }

    public Program getNDRProgram() {
        return this.ndrProgram;
    }

    @Override
    public SValue toSValue() {
        SList automaton = (SList)super.toSValue();
        if (this.ndrStates != null) {
            SList first = (SList)automaton.get(2);
            SList schedule = SExp.makeSList((SValue)SExp.makeSValue((String)KEYW_SCHEDULE), (SValue)this.ndrStates.toSValue(), (SValue)this.ndrProgram.toSValue());
            first.add((Object)schedule);
        }
        return automaton;
    }
}

