/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SExpException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicVariable
extends BasicILElement
implements Variable {
    protected String id;
    protected String name;
    protected Vector<Integer> scope;
    protected Sort sort;
    protected String autName = "";
    protected SList auxInfo;

    public BasicVariable(String id, String name, Sort sort, Vector<Integer> scope) {
        this.id = id;
        this.name = name;
        this.sort = sort;
        this.scope = scope;
        this.auxInfo = new SList();
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Vector<Integer> getScope() {
        return this.scope;
    }

    @Override
    public final Sort getSort() {
        return this.sort;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseVariable(this, ip);
        ip.flush();
    }

    @Override
    public void setAutName(String autName) {
        this.autName = autName;
    }

    @Override
    public String getAutName() {
        return this.autName;
    }

    @Override
    public void parseExtension(SList sexp, ILParser parser) throws ILException, SExpException, IOException {
        this.auxInfo.add((Object)sexp);
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceVariable(this);
    }

    protected BasicVariable(Variable obj, ILInstanceFactory f) throws ILException {
        f.put(obj, this);
        this.id = obj.getId();
        this.name = obj.getName();
        this.sort = (Sort)f.makeInstance(obj.getSort());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        f.put(this, this);
        this.sort = (Sort)f.makeInstance(this.sort);
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)this.getId()));
        retval.add((Object)SExp.makeSValue((String)("\"" + this.getName() + "\"")));
        retval.add((Object)SExp.makeSValue((String)this.getSort().getId()));
        if (this.auxInfo.size() > 0) {
            retval.addAll((Collection)this.auxInfo);
        }
        return retval;
    }
}

