/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.Statement;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTransition
extends BasicILElement
implements Transition {
    protected Action action;
    protected String id;
    protected String tid;
    protected String caseName;
    protected Vector<Term> actionActuals;
    protected Vector<FuncDecl> funcDecls;
    protected Term where;
    protected Vector<Variable> chooseFormals;
    protected Term precondition;
    protected Program effect;
    protected Term soThat;
    protected Vector<Variable> locals;

    public BasicTransition(String transitionId, String caseName, Action action, String actionId, Vector<Term> actionActuals, Vector<FuncDecl> funcDecls, Term where, Vector<Variable> chooseFormals, Term precondition, Program effect, Term soThat, Vector<Variable> locals) {
        this.tid = transitionId;
        this.caseName = caseName;
        this.action = action;
        this.id = actionId;
        this.actionActuals = actionActuals;
        this.funcDecls = funcDecls;
        this.where = where;
        this.chooseFormals = chooseFormals;
        this.precondition = precondition;
        this.effect = BasicTransition.ensureProgram(effect);
        this.soThat = soThat;
        this.locals = locals;
    }

    protected static Program ensureProgram(Program p) {
        if (p != null) {
            return p;
        }
        try {
            ILFactory fact = ILFactory.getInstance();
            return fact.newProgram(new Vector<Statement>());
        }
        catch (ILException ile) {
            throw new RuntimeException(ile.getMessage());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setActionId(String actionId) {
        this.id = actionId;
    }

    @Override
    public String getTransitionId() {
        return this.tid;
    }

    @Override
    public String getCaseName() {
        return this.caseName;
    }

    @Override
    public Vector<Term> getActionActuals() {
        return this.actionActuals;
    }

    @Override
    public Vector getFuncDecls() {
        return this.funcDecls;
    }

    @Override
    public Term getWherePred() {
        return this.where;
    }

    @Override
    public Vector<Variable> getChooseFormals() {
        return this.chooseFormals;
    }

    @Override
    public Term getPrecondition() {
        return this.precondition;
    }

    @Override
    public Program getEffect() {
        return this.effect;
    }

    @Override
    public Term getSoThatPred() {
        return this.soThat;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public Vector<Variable> getLocals() {
        return this.locals;
    }

    @Override
    public void setPrecondition(Term pre) {
        this.precondition = pre;
    }

    @Override
    public void setEffect(Program effect) {
        this.effect = effect;
    }

    @Override
    public void setChooseFormals(Vector<Variable> chooseFormals) {
        this.chooseFormals = chooseFormals;
    }

    @Override
    public void setLocals(Vector<Variable> locals) {
        this.locals = locals;
    }

    public void setActionActuals(Vector<Term> actionActuals) {
        this.actionActuals = actionActuals;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseTransition(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceTransition(this);
    }

    protected BasicTransition(Transition obj, ILInstanceFactory f) throws ILException {
        f.put(obj, this);
        this.id = obj.getId();
        this.tid = obj.getTransitionId();
        this.action = (Action)f.makeInstance(obj.getAction());
        this.actionActuals = f.instanceVector(obj.getActionActuals());
        this.funcDecls = f.instanceVector(obj.getFuncDecls());
        this.where = (Term)f.makeInstance(obj.getWherePred());
        this.chooseFormals = f.instanceVector(obj.getChooseFormals());
        this.precondition = (Term)f.makeInstance(obj.getPrecondition());
        this.effect = (Program)f.makeInstance(obj.getEffect());
        this.soThat = (Term)f.makeInstance(obj.getSoThatPred());
        this.locals = f.instanceVector(obj.getLocals());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        f.put(this, this);
        this.action = (Action)f.makeInstance(this.action);
        this.actionActuals = f.instanceVector(this.actionActuals);
        this.funcDecls = f.instanceVector(this.funcDecls);
        this.where = (Term)f.makeInstance(this.where);
        this.chooseFormals = f.instanceVector(this.chooseFormals);
        this.precondition = (Term)f.makeInstance(this.precondition);
        this.effect = (Program)f.makeInstance(this.effect);
        this.soThat = (Term)f.makeInstance(this.soThat);
        this.locals = f.instanceVector(this.getLocals());
        return this;
    }

    public SValue toSValue() {
        int i;
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)this.getTransitionId()));
        SList caseList = new SList();
        caseList.add((Object)SExp.makeSValue((String)"case"));
        if (this.getCaseName() != null && !this.getCaseName().equals("")) {
            caseList.add((Object)SExp.makeSValue((String)this.getCaseName()));
        }
        retval.add((Object)caseList);
        retval.add((Object)SExp.makeSValue((String)this.getId()));
        if (this.getActionActuals() != null && this.getActionActuals().size() > 0) {
            SList actuals = SExp.makeSList((SValue)SExp.makeSValue((String)"actuals"));
            i = 0;
            while (i < this.getActionActuals().size()) {
                actuals.add((Object)this.getActionActuals().elementAt(i).toSValue());
                ++i;
            }
            retval.add((Object)actuals);
        }
        if (this.getLocals() != null && this.getLocals().size() > 0) {
            SList formals = SExp.makeSList((SValue)SExp.makeSValue((String)"locals"));
            i = 0;
            while (i < this.getLocals().size()) {
                Variable v = this.getLocals().elementAt(i);
                formals.add((Object)SExp.makeSValue((String)v.getId()));
                ++i;
            }
            retval.add((Object)formals);
        }
        if (this.getWherePred() != null) {
            SList where = new SList();
            where.add((Object)SExp.makeSValue((String)"where"));
            where.add((Object)this.getWherePred().toSValue());
            retval.add((Object)where);
        }
        if (this.getPrecondition() != null) {
            SList precondition = new SList();
            precondition.add((Object)SExp.makeSValue((String)"pre"));
            precondition.add((Object)this.getPrecondition().toSValue());
            retval.add((Object)precondition);
        }
        if (this.getEffect() != null && this.getEffect().getStatements() != null && this.getEffect().getStatements().size() > 0) {
            SList effect = new SList();
            effect.add((Object)SExp.makeSValue((String)"eff"));
            effect.add((Object)this.getEffect().toSValue());
            if (this.getSoThatPred() != null) {
                SList ensuring = SExp.makeSList((SValue)SExp.makeSValue((String)"ensuring"));
                ensuring.add((Object)this.getSoThatPred().toSValue());
                effect.add((Object)ensuring);
            }
            retval.add((Object)effect);
        }
        return retval;
    }
}

