/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.NameCollisionException;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.BasicTrajectory;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.il.nodes.TrajectoryTable;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class BasicTrajectoryTable
extends BasicILElement
implements TrajectoryTable {
    protected Hashtable<String, Trajectory> trajTable;
    protected int uniqueCount = 999;
    protected String uniqueTrajPrefix = "$$$tj";
    protected List<Trajectory> trajList = new ArrayList<Trajectory>();

    public BasicTrajectoryTable() {
        this.trajTable = new Hashtable();
    }

    public void putTrajectory(Trajectory traj) throws NameCollisionException {
        if (traj.getTrajectoryId() == null && traj instanceof BasicTrajectory) {
            ((BasicTrajectory)traj).id = String.valueOf(this.uniqueTrajPrefix) + this.uniqueCount++;
        }
        if (this.trajTable.put(traj.getTrajectoryId(), traj) != null) {
            throw new NameCollisionException(traj.getTrajectoryId());
        }
        this.trajList.add(traj);
    }

    public Trajectory getTrajectory(String id) throws LookupException {
        Trajectory traj = this.trajTable.get(id);
        if (traj != null) {
            return traj;
        }
        throw new LookupException(id, "trajectory");
    }

    public Enumeration enumTrajectories() {
        return Collections.enumeration(this.trajList);
    }

    public void writeILForm(PrintWriter w) throws ILException, IOException {
        System.err.println("BasicTrajectoryTable.writeILForm not yet implemented");
    }

    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceTrajectoryTable(this);
    }

    protected BasicTrajectoryTable(TrajectoryTable obj, ILInstanceFactory f) throws ILException {
        this.trajTable = new Hashtable();
        Enumeration enum1 = f.instanceEnumeration(obj.enumTrajectories());
        while (enum1.hasMoreElements()) {
            this.putTrajectory((Trajectory)enum1.nextElement());
        }
    }

    public BasicTrajectoryTable appendTable(TrajectoryTable tt) throws NameCollisionException {
        BasicTrajectoryTable newTable = new BasicTrajectoryTable();
        Enumeration enum1 = this.enumTrajectories();
        while (enum1.hasMoreElements()) {
            newTable.putTrajectory((Trajectory)enum1.nextElement());
        }
        enum1 = tt.enumTrajectories();
        while (enum1.hasMoreElements()) {
            newTable.putTrajectory((Trajectory)enum1.nextElement());
        }
        return newTable;
    }

    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        Hashtable<String, Trajectory> trajTable2 = this.trajTable;
        this.trajTable = new Hashtable();
        Enumeration<Trajectory> enum1 = f.instanceEnumeration(trajTable2.elements());
        while (enum1.hasMoreElements()) {
            this.putTrajectory(enum1.nextElement());
        }
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        Enumeration e = this.enumTrajectories();
        while (e.hasMoreElements()) {
            retval.add((Object)((Trajectory)e.nextElement()).toSValue());
        }
        return retval;
    }
}

