/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTrajectory
extends BasicILElement
implements Trajectory {
    protected String id;
    protected String name;
    protected Term invariant;
    protected Term stopCondition;
    protected Vector<FuncDecl> funcDeclarations;
    protected Vector<Term> evolvePreds;

    public BasicTrajectory(String id, String name, Term invariant, Term stopCondition, Vector<FuncDecl> funcDeclarations, Vector<Term> evolvePreds) {
        this.id = id;
        this.name = name;
        this.invariant = invariant;
        this.stopCondition = stopCondition;
        this.funcDeclarations = funcDeclarations;
        this.evolvePreds = evolvePreds;
    }

    @Override
    public String getTrajectoryId() {
        return this.id;
    }

    @Override
    public String getTrajectoryName() {
        return this.name;
    }

    @Override
    public Term getInvariant() {
        return this.invariant;
    }

    @Override
    public Term getStopCondition() {
        return this.stopCondition;
    }

    @Override
    public Vector<FuncDecl> getFuncDeclarations() {
        return this.funcDeclarations;
    }

    @Override
    public Vector<Term> getEvolvePredicates() {
        return this.evolvePreds;
    }

    public void setId(String actionId) {
        this.id = actionId;
    }

    @Override
    public void setInvariant(Term invariant) {
        this.invariant = invariant;
    }

    @Override
    public void setStopCondition(Term stopCondition) {
        this.stopCondition = stopCondition;
    }

    @Override
    public void setFuncDeclarations(Vector<FuncDecl> funcDeclarations) {
        this.funcDeclarations = funcDeclarations;
    }

    @Override
    public void setEvolvePredicates(Vector<Term> evolvePreds) {
        this.evolvePreds = evolvePreds;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseTrajectory(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceTrajectory(this);
    }

    protected BasicTrajectory(Trajectory obj, ILInstanceFactory f) throws ILException {
        f.put(obj, this);
        this.id = obj.getTrajectoryId();
        this.invariant = (Term)f.makeInstance(obj.getInvariant());
        this.stopCondition = (Term)f.makeInstance(obj.getStopCondition());
        this.funcDeclarations = f.instanceVector(obj.getFuncDeclarations());
        this.evolvePreds = f.instanceVector(obj.getEvolvePredicates());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        f.put(this, this);
        this.invariant = (Term)f.makeInstance(this.getInvariant());
        this.stopCondition = (Term)f.makeInstance(this.getStopCondition());
        this.funcDeclarations = f.instanceVector(this.getFuncDeclarations());
        this.evolvePreds = f.instanceVector(this.getEvolvePredicates());
        return this;
    }

    public SValue toSValue() {
        int i;
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)this.getTrajectoryId()));
        retval.add((Object)SExp.makeSValue((String)this.getTrajectoryName()));
        if (this.getInvariant() != null) {
            SList invariant = new SList();
            invariant.add((Object)SExp.makeSValue((String)"invariant"));
            invariant.add((Object)this.getInvariant().toSValue());
            retval.add((Object)invariant);
        }
        if (this.getStopCondition() != null) {
            SList stopCond = new SList();
            stopCond.add((Object)SExp.makeSValue((String)"stop"));
            stopCond.add((Object)this.getStopCondition().toSValue());
            retval.add((Object)stopCond);
        }
        SList evolve = new SList();
        evolve.add((Object)SExp.makeSValue((String)"evolve"));
        if (this.getFuncDeclarations() != null) {
            i = 0;
            while (i < this.getFuncDeclarations().size()) {
                evolve.add((Object)this.getFuncDeclarations().elementAt(i).toSValue());
                ++i;
            }
        }
        i = 0;
        while (i < this.getEvolvePredicates().size()) {
            evolve.add((Object)this.getEvolvePredicates().elementAt(i).toSValue());
            ++i;
        }
        retval.add((Object)evolve);
        return retval;
    }
}

