/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.NameCollisionException;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.Binding;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.SymbolTable;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.util.ArrayUtil;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.FilterEnumeration;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSymbolTable
extends BasicILElement
implements SymbolTable {
    protected Hashtable<String, Binding> table;
    protected Vector<Sort> enums;
    protected Vector<Sort> unions;
    protected Vector<Sort> tuples;
    protected static String[] builtinOpKeys = new String[]{"false@{Bool@[]@}@", "true@{Bool@[]@}@", "~__@{Bool@[]@$Bool@[]@}@", "__/\\__@{Bool@[]@$Bool@[]@$Bool@[]@}@", "__\\/__@{Bool@[]@$Bool@[]@$Bool@[]@}@", "__=__@{Bool@[]@$Bool@[]@$Bool@[]@}@", "__~=__@{Bool@[]@$Bool@[]@$Bool@[]@}@", "__=>__@{Bool@[]@$Bool@[]@$Bool@[]@}@", "__<=>__@{Bool@[]@$Bool@[]@$Bool@[]@}@", "{__}@{Seq@[IOA_Parameter@[]@]@}@", "__\\in__@{Bool@[]@$IOA_Parameter@[]@$Seq@[IOA_Parameter@[]@]@}@", "__=__@{Bool@[]@$Seq@[IOA_Parameter@[]@]@$Seq@[IOA_Parameter@[]@]@}@", "__~=__@{Bool@[]@$Seq@[IOA_Parameter@[]@]@$Seq@[IOA_Parameter@[]@]@}@", "len@{Int@[]@$Seq@[IOA_Parameter@[]@]@}@", "__||__@{Seq@[IOA_Parameter@[]@]@$Seq@[IOA_Parameter@[]@]@$Seq@[IOA_Parameter@[]@]@}@", "head@{IOA_Parameter@[]@$Seq@[IOA_Parameter@[]@]@}@", "tail@{Seq@[IOA_Parameter@[]@]@$Seq@[IOA_Parameter@[]@]@}@", "last@{IOA_Parameter@[]@$Seq@[IOA_Parameter@[]@]@}@", "__-|__@{Seq@[IOA_Parameter@[]@]@$IOA_Parameter@[]@$Seq@[IOA_Parameter@[]@]@}@", "__|-__@{Seq@[IOA_Parameter@[]@]@$Seq@[IOA_Parameter@[]@]@$IOA_Parameter@[]@}@", "__[__]@{IOA_Parameter@[]@$Seq@[IOA_Parameter@[]@]@$Int@[]@}@", "__=__@{Bool@[]@$Int@[]@$Int@[]@}@", "__~=__@{Bool@[]@$Int@[]@$Int@[]@}@", "-__@{Int@[]@$Int@[]@}@", "abs@{Int@[]@$Int@[]@}@", "pred@{Int@[]@$Int@[]@}@", "succ@{Int@[]@$Int@[]@}@", "__+__@{Int@[]@$Int@[]@$Int@[]@}@", "__-__@{Int@[]@$Int@[]@$Int@[]@}@", "__*__@{Int@[]@$Int@[]@$Int@[]@}@", "div@{Int@[]@$Int@[]@$Int@[]@}@", "mod@{Int@[]@$Int@[]@$Int@[]@}@", "min@{Int@[]@$Int@[]@$Int@[]@}@", "max@{Int@[]@$Int@[]@$Int@[]@}@", "__<__@{Bool@[]@$Int@[]@$Int@[]@}@", "__<=__@{Bool@[]@$Int@[]@$Int@[]@}@", "__>__@{Bool@[]@$Int@[]@$Int@[]@}@", "__>=__@{Bool@[]@$Int@[]@$Int@[]@}@", "{__}@{LSeqIn@[IOA_Invocation@[]@]@}@", "__\\in__@{Bool@[]@$IOA_Invocation@[]@$LSeqIn@[IOA_Invocation@[]@]@}@", "__=__@{Bool@[]@$LSeqIn@[IOA_Invocation@[]@]@$LSeqIn@[IOA_Invocation@[]@]@}@", "__~=__@{Bool@[]@$LSeqIn@[IOA_Invocation@[]@]@$LSeqIn@[IOA_Invocation@[]@]@}@", "len@{Int@[]@$LSeqIn@[IOA_Invocation@[]@]@}@", "__||__@{LSeqIn@[IOA_Invocation@[]@]@$LSeqIn@[IOA_Invocation@[]@]@$LSeqIn@[IOA_Invocation@[]@]@}@", "head@{IOA_Invocation@[]@$LSeqIn@[IOA_Invocation@[]@]@}@", "tail@{LSeqIn@[IOA_Invocation@[]@]@$LSeqIn@[IOA_Invocation@[]@]@}@", "last@{IOA_Invocation@[]@$LSeqIn@[IOA_Invocation@[]@]@}@", "__-|__@{LSeqIn@[IOA_Invocation@[]@]@$IOA_Invocation@[]@$LSeqIn@[IOA_Invocation@[]@]@}@", "__|-__@{LSeqIn@[IOA_Invocation@[]@]@$LSeqIn@[IOA_Invocation@[]@]@$IOA_Invocation@[]@}@", "__[__]@{IOA_Invocation@[]@$LSeqIn@[IOA_Invocation@[]@]@$Int@[]@}@", "{__}@{LSeqOut@[IOA_Invocation@[]@]@}@", "__\\in__@{Bool@[]@$IOA_Invocation@[]@$LSeqOut@[IOA_Invocation@[]@]@}@", "__=__@{Bool@[]@$LSeqOut@[IOA_Invocation@[]@]@$LSeqOut@[IOA_Invocation@[]@]@}@", "__~=__@{Bool@[]@$LSeqOut@[IOA_Invocation@[]@]@$LSeqOut@[IOA_Invocation@[]@]@}@", "len@{Int@[]@$LSeqOut@[IOA_Invocation@[]@]@}@", "__||__@{LSeqOut@[IOA_Invocation@[]@]@$LSeqOut@[IOA_Invocation@[]@]@$LSeqOut@[IOA_Invocation@[]@]@}@", "head@{IOA_Invocation@[]@$LSeqOut@[IOA_Invocation@[]@]@}@", "tail@{LSeqOut@[IOA_Invocation@[]@]@$LSeqOut@[IOA_Invocation@[]@]@}@", "last@{IOA_Invocation@[]@$LSeqOut@[IOA_Invocation@[]@]@}@", "__-|__@{LSeqOut@[IOA_Invocation@[]@]@$IOA_Invocation@[]@$LSeqOut@[IOA_Invocation@[]@]@}@", "__|-__@{LSeqOut@[IOA_Invocation@[]@]@$LSeqOut@[IOA_Invocation@[]@]@$IOA_Invocation@[]@}@", "__[__]@{IOA_Invocation@[]@$LSeqOut@[IOA_Invocation@[]@]@$Int@[]@}@"};
    protected Operator[] builtinOps = new Operator[builtinOpKeys.length];
    protected static String[] builtinSortKeys = new String[]{"Bool@[]@", "Int@[]@", "Nat@[]@", "Seq@[IOA_Parameter@[]@]@", "LSeqIn@[IOA_Invocation@[]@]@", "LSeqOut@[IOA_Invocation@[]@]@", "Handle@[]@"};
    protected Sort[] builtinSorts = new Sort[builtinSortKeys.length];
    protected Hashtable ids = null;

    public BasicSymbolTable() {
        this.table = new Hashtable();
        this.enums = new Vector();
        this.tuples = new Vector();
        this.unions = new Vector();
    }

    @Override
    public Binding get(String id) throws LookupException {
        Binding b = this.table.get(id);
        if (b == null) {
            throw new LookupException(id, null);
        }
        return b;
    }

    @Override
    public Sort getSort(String id) throws LookupException {
        try {
            Sort sort = (Sort)this.table.get(id);
            if (sort != null) {
                return sort;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new LookupException(id, "sort");
    }

    @Override
    public Enumeration<Binding> enumBindings() {
        return this.table.elements();
    }

    @Override
    public Enumeration<Sort> enumSorts() {
        return new FilterEnumeration(this.table.elements()){

            public Object filter(Object obj) {
                return obj instanceof Sort ? obj : null;
            }
        };
    }

    @Override
    public Enumeration<Operator> enumOperators() {
        return new FilterEnumeration(this.table.elements()){

            public Object filter(Object obj) {
                return obj instanceof Operator ? obj : null;
            }
        };
    }

    @Override
    public Enumeration<Variable> enumVariables() {
        return new FilterEnumeration(this.table.elements()){

            public Object filter(Object obj) {
                return obj instanceof Variable ? obj : null;
            }
        };
    }

    @Override
    public void makeEnumSort(Sort sort, Operator succOp, Vector<String> eltNames, Vector<Operator> eltOps) {
        sort.setEnumData(succOp, eltNames, eltOps);
        this.enums.addElement(sort);
    }

    @Override
    public void makeUnionSort(Sort sort, Sort tagSort, Operator tagOp, Vector<String> fieldNames, Vector<Sort> fieldSorts, Vector<Operator> fieldToOps, Vector<Operator> fieldFromOps) {
        sort.setUnionData(tagSort, tagOp, fieldNames, fieldSorts, fieldToOps, fieldFromOps);
        this.unions.addElement(sort);
    }

    @Override
    public void makeTupleSort(Sort sort, Operator makeOp, Vector<String> fieldNames, Vector<Sort> fieldSorts, Vector<Operator> fieldSetOps, Vector<Operator> fieldGetOps) {
        sort.setTupleData(makeOp, fieldNames, fieldSorts, fieldSetOps, fieldGetOps);
        this.tuples.addElement(sort);
    }

    @Override
    public Operator getOperator(String id) throws LookupException {
        try {
            Operator op = (Operator)this.table.get(id);
            if (op != null) {
                return op;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new LookupException(id, "operator");
    }

    @Override
    public Operator getEqualityOperator(Sort s) throws ILException {
        String key = "__=__@{Bool@[]@$" + s.getKey() + "$" + s.getKey() + "}@";
        Enumeration<Operator> ops = this.enumOperators();
        while (ops.hasMoreElements()) {
            Operator op = ops.nextElement();
            if (!op.getKey().equals(key)) continue;
            return op;
        }
        throw new ILException("Couldn't find equality operator for " + s);
    }

    @Override
    public Variable getVariable(String id) throws LookupException {
        try {
            Variable var = (Variable)this.table.get(id);
            if (var != null) {
                return var;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new LookupException(id, "variable");
    }

    @Override
    public void put(Binding b) throws NameCollisionException {
        if (b instanceof Operator) {
            Operator op = (Operator)b;
            int i = 0;
            while (i < builtinOpKeys.length) {
                if (op.getKey().equals(builtinOpKeys[i])) {
                    this.builtinOps[i] = op;
                }
                ++i;
            }
        } else if (b instanceof Sort) {
            Sort sort = (Sort)b;
            int i = 0;
            while (i < builtinSortKeys.length) {
                if (sort.getKey().equals(builtinSortKeys[i])) {
                    this.builtinSorts[i] = sort;
                }
                ++i;
            }
        }
        if (this.table.put(b.getId(), b) != null) {
            throw new NameCollisionException(b.getId());
        }
    }

    @Override
    public Binding replace(Binding b) {
        return this.table.put(b.getId(), b);
    }

    @Override
    public final Operator getOperator(int code) {
        return this.builtinOps[code];
    }

    @Override
    public final Sort getSort(int code) {
        return this.builtinSorts[code];
    }

    @Override
    public String getFreshOpID() {
        return this.getFreshID("o");
    }

    @Override
    public String getFreshSortID() {
        return this.getFreshID("s");
    }

    @Override
    public String getFreshVarID() {
        return this.getFreshID("v");
    }

    private String getFreshID(String prefix) {
        if (this.ids == null) {
            this.ids = new Hashtable();
        }
        int start = 4;
        if (this.ids.containsKey(prefix)) {
            Integer Start = (Integer)this.ids.get(prefix);
            start = Start;
            this.ids.remove(prefix);
        }
        int i = start;
        while (i < Integer.MAX_VALUE) {
            if (!this.table.containsKey(String.valueOf(prefix) + i)) {
                this.ids.put(prefix, new Integer(i));
                return String.valueOf(prefix) + i;
            }
            ++i;
        }
        throw new RuntimeException("No more unique IDs for '" + prefix + "'.");
    }

    @Override
    public void copyFrom(SymbolTable st) {
        try {
            Enumeration<Binding> e = st.enumSorts();
            while (e.hasMoreElements()) {
                Sort s = e.nextElement();
                this.put(s);
            }
            e = st.enumOperators();
            while (e.hasMoreElements()) {
                Operator o = (Operator)e.nextElement();
                this.put(o);
            }
            e = st.enumVariables();
            while (e.hasMoreElements()) {
                Variable v = (Variable)e.nextElement();
                this.put(v);
            }
        }
        catch (NameCollisionException nameCollisionException) {
            // empty catch block
        }
    }

    @Override
    public void addInt(ILFactory fact) throws ILException {
        Sort boolSort = this.getSort(0);
        Assert.assertNotNull((Object)boolSort, (String)("Bool should be found in the built-in sorts: " + ArrayUtil.makeString((Object[])this.builtinSorts)));
        Sort intSort = fact.newSort(this.getFreshSortID(), "Int", new Vector<Sort>(), false, false, false, false, null);
        this.put(intSort);
        Vector<Sort> intSortVect = new Vector<Sort>();
        intSortVect.addElement(intSort);
        Vector<Sort> twoIntSortVect = new Vector<Sort>();
        twoIntSortVect.addElement(intSort);
        twoIntSortVect.addElement(intSort);
        Operator negation = fact.newOperator(this.getFreshOpID(), 1, "-", null, intSortVect, intSort, false, null);
        this.put(negation);
        Operator abs = fact.newOperator(this.getFreshOpID(), 0, "abs", null, intSortVect, intSort, false, null);
        this.put(abs);
        Operator pred = fact.newOperator(this.getFreshOpID(), 0, "pred", null, intSortVect, intSort, false, null);
        this.put(pred);
        Operator succ = fact.newOperator(this.getFreshOpID(), 0, "succ", null, intSortVect, intSort, false, null);
        this.put(succ);
        Operator plus = fact.newOperator(this.getFreshOpID(), 1, "+", null, twoIntSortVect, intSort, false, null);
        this.put(plus);
        Operator minus = fact.newOperator(this.getFreshOpID(), 1, "-", null, twoIntSortVect, intSort, false, null);
        this.put(minus);
        Operator times = fact.newOperator(this.getFreshOpID(), 1, "*", null, twoIntSortVect, intSort, false, null);
        this.put(times);
        Operator div = fact.newOperator(this.getFreshOpID(), 0, "div", null, twoIntSortVect, intSort, false, null);
        this.put(div);
        Operator mod = fact.newOperator(this.getFreshOpID(), 0, "mod", null, twoIntSortVect, intSort, false, null);
        this.put(mod);
        Operator min = fact.newOperator(this.getFreshOpID(), 0, "min", null, twoIntSortVect, intSort, false, null);
        this.put(min);
        Operator max = fact.newOperator(this.getFreshOpID(), 0, "max", null, twoIntSortVect, intSort, false, null);
        this.put(max);
        Operator lt = fact.newOperator(this.getFreshOpID(), 1, "<", null, twoIntSortVect, boolSort, false, null);
        this.put(lt);
        Operator lte = fact.newOperator(this.getFreshOpID(), 1, "<=", null, twoIntSortVect, boolSort, false, null);
        this.put(lte);
        Operator gt = fact.newOperator(this.getFreshOpID(), 1, ">", null, twoIntSortVect, boolSort, false, null);
        this.put(gt);
        Operator gte = fact.newOperator(this.getFreshOpID(), 1, ">=", null, twoIntSortVect, boolSort, false, null);
        Operator eq = fact.newOperator(this.getFreshOpID(), 1, "=", null, twoIntSortVect, boolSort, false, null);
        this.put(eq);
        Operator neq = fact.newOperator(this.getFreshOpID(), 1, "~=", null, twoIntSortVect, boolSort, false, null);
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseSymbolTable(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceSymbolTable(this);
    }

    protected BasicSymbolTable(SymbolTable obj, ILInstanceFactory f) throws ILException {
        this.table = new Hashtable();
        Enumeration<Binding> enum1 = f.instanceEnumeration(obj.enumBindings());
        while (enum1.hasMoreElements()) {
            this.put(enum1.nextElement());
        }
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        Hashtable<String, Binding> table2 = this.table;
        this.table = new Hashtable();
        Enumeration<Binding> enum1 = f.instanceEnumeration(table2.elements());
        while (enum1.hasMoreElements()) {
            this.put(enum1.nextElement());
        }
        return this;
    }

    @Override
    public void addSeq(ILFactory fact, Sort subsort, boolean lockable, boolean input) throws ILException {
        Sort boolSort = this.getSort("s0");
        Sort intSort = this.getSort(1);
        Vector<Sort> subsortVect = new Vector<Sort>();
        subsortVect.add(subsort);
        String sortName = lockable ? (input ? "LSeqIn" : "LSeqOut") : "Seq";
        Sort seqSort = fact.newSort(this.getFreshSortID(), sortName, subsortVect, false, false, false, false, null);
        this.put(seqSort);
        Vector<Sort> domainSeqSeq = new Vector<Sort>();
        domainSeqSeq.add(seqSort);
        domainSeqSeq.add(seqSort);
        Vector<Sort> domainSeqSub = new Vector<Sort>();
        domainSeqSub.add(seqSort);
        domainSeqSub.add(subsort);
        Vector<Sort> domainSubSeq = new Vector<Sort>();
        domainSubSeq.add(subsort);
        domainSubSeq.add(seqSort);
        Vector<Sort> domainSeqInt = new Vector<Sort>();
        domainSeqInt.add(seqSort);
        domainSeqInt.add(intSort);
        Vector<Sort> domainSeq = new Vector<Sort>();
        domainSeq.add(seqSort);
        Vector<Sort> domainEmpty = new Vector<Sort>();
        Operator empty = fact.newOperator(this.getFreshOpID(), 4, "{", "}", domainEmpty, seqSort, false, null);
        this.put(empty);
        Operator append = fact.newOperator(this.getFreshOpID(), 1, "|-", null, domainSeqSub, seqSort, false, null);
        this.put(append);
        Operator prepend = fact.newOperator(this.getFreshOpID(), 1, "-|", null, domainSubSeq, seqSort, false, null);
        this.put(prepend);
        Operator concat = fact.newOperator(this.getFreshOpID(), 1, "||", null, domainSeqSeq, seqSort, false, null);
        this.put(concat);
        Operator in = fact.newOperator(this.getFreshOpID(), 1, "\\in", null, domainSubSeq, boolSort, false, null);
        this.put(in);
        Operator head = fact.newOperator(this.getFreshOpID(), 0, "head", null, domainSeq, subsort, false, null);
        this.put(head);
        Operator last = fact.newOperator(this.getFreshOpID(), 0, "last", null, domainSeq, subsort, false, null);
        this.put(last);
        Operator tail = fact.newOperator(this.getFreshOpID(), 0, "tail", null, domainSeq, seqSort, false, null);
        this.put(tail);
        Operator init = fact.newOperator(this.getFreshOpID(), 0, "init", null, domainSeq, seqSort, false, null);
        this.put(init);
        Operator len = fact.newOperator(this.getFreshOpID(), 0, "len", null, domainSeq, intSort, false, null);
        this.put(len);
        Operator brackets = fact.newOperator(this.getFreshOpID(), 4, "__[", "]", domainSeqInt, subsort, false, null);
        this.put(brackets);
    }

    public SValue toSValue() {
        SList retval = new SList();
        SList sorts = new SList();
        retval.add((Object)sorts);
        sorts.add((Object)SExp.makeSValue((String)"sorts"));
        Enumeration enum1 = ILUnparser.sortBindingEnum(this.enumSorts());
        while (enum1.hasMoreElements()) {
            sorts.add((Object)((Sort)enum1.nextElement()).toSValue());
        }
        SList ops = new SList();
        retval.add((Object)ops);
        ops.add((Object)SExp.makeSValue((String)"ops"));
        Enumeration enum12 = ILUnparser.sortBindingEnum(this.enumOperators());
        while (enum12.hasMoreElements()) {
            ops.add((Object)((Operator)enum12.nextElement()).toSValue());
        }
        SList vars = new SList();
        retval.add((Object)vars);
        vars.add((Object)SExp.makeSValue((String)"vars"));
        Enumeration enum13 = ILUnparser.sortBindingEnum(this.enumVariables());
        while (enum13.hasMoreElements()) {
            vars.add((Object)((Variable)enum13.nextElement()).toSValue());
        }
        return retval;
    }
}

