/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.NameCollisionException;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.State;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class BasicStateTable
extends BasicILElement
implements StateTable {
    protected Hashtable<String, State> table;
    protected Hashtable<String, State> nameTable;
    protected List<State> stateList = new ArrayList<State>();

    public BasicStateTable() {
        this.table = new Hashtable();
        this.nameTable = new Hashtable();
    }

    public void put(State state) throws NameCollisionException {
        if (this.table.put(state.getId(), state) != null) {
            throw new NameCollisionException(state.getId());
        }
        if (this.nameTable.put(state.getName(), state) != null) {
            throw new NameCollisionException(state.getId());
        }
        this.stateList.add(state);
    }

    public State get(String id) throws LookupException {
        State state = this.table.get(id);
        if (state != null) {
            return state;
        }
        throw new LookupException(id, "state");
    }

    public State getByName(String name) throws LookupException {
        State state = this.nameTable.get(name);
        if (state != null) {
            return state;
        }
        throw new LookupException(name, "state (by name)");
    }

    public Enumeration enumerate() {
        return Collections.enumeration(this.stateList);
    }

    State internalGet(String id) {
        return this.table.get(id);
    }

    State internalGetByName(String name) {
        return this.nameTable.get(name);
    }

    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseStateTable(this, null, ip);
        ip.flush();
    }

    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceStateTable(this);
    }

    protected BasicStateTable(StateTable obj, ILInstanceFactory f) throws ILException {
        this.table = new Hashtable();
        Enumeration<State> enum1 = f.instanceEnumeration(obj.enumerate());
        while (enum1.hasMoreElements()) {
            this.put(enum1.nextElement());
        }
    }

    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        Hashtable<String, State> table2 = this.table;
        this.table = new Hashtable();
        Enumeration<State> enum1 = f.instanceEnumeration(table2.elements());
        while (enum1.hasMoreElements()) {
            this.put(enum1.nextElement());
        }
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)"states"));
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            retval.add((Object)((State)e.nextElement()).toSValue());
        }
        return retval;
    }
}

