/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.nodes.Automaton;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.BasicSymbolTable;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Invariant;
import com.veromodo.tioa.il.nodes.SimulationRelation;
import com.veromodo.tioa.il.nodes.Spec;
import com.veromodo.tioa.il.nodes.SymbolTable;
import com.veromodo.tioa.il.nodes.Vocabulary;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSpec
extends BasicILElement
implements Spec {
    protected SymbolTable st;
    protected Hashtable<String, Automaton> automata;
    protected Set<Vocabulary> vocabularies;
    protected Vector<FuncDecl> funcDecls;

    public BasicSpec() {
        this.st = new BasicSymbolTable();
        this.automata = new Hashtable();
        this.vocabularies = new HashSet<Vocabulary>();
        this.funcDecls = new Vector();
    }

    @Override
    public void addAutomaton(Automaton aut) {
        this.automata.put(aut.getName(), aut);
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.st;
    }

    @Override
    public Automaton getAutomaton(String id) throws LookupException {
        Automaton aut = this.automata.get(id);
        if (aut == null) {
            throw new LookupException(id, "automaton");
        }
        return aut;
    }

    @Override
    public Enumeration<Automaton> enumAutomata() {
        return this.automata.elements();
    }

    @Override
    public int nAutomata() {
        return this.automata.size();
    }

    @Override
    public void addVocabulary(Vocabulary vocabulary) {
        this.vocabularies.add(vocabulary);
    }

    @Override
    public Set<Vocabulary> getVocabularies() {
        return Collections.unmodifiableSet(this.vocabularies);
    }

    @Override
    public void addFuncDecls(Vector<FuncDecl> funcDecls) {
        this.funcDecls = new Vector<FuncDecl>(funcDecls);
    }

    @Override
    public Vector<FuncDecl> getFuncDecls() {
        return new Vector<FuncDecl>(this.funcDecls);
    }

    protected BasicSpec(Spec obj, ILInstanceFactory f) throws ILException {
        this.st = (SymbolTable)f.makeInstance(obj.getSymbolTable());
        this.automata = new Hashtable();
        Enumeration<Automaton> enum1 = f.instanceEnumeration(obj.enumAutomata());
        while (enum1.hasMoreElements()) {
            this.addAutomaton(enum1.nextElement());
        }
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.st = (SymbolTable)f.makeInstance(this.st);
        Hashtable<String, Automaton> automata2 = this.automata;
        this.automata = new Hashtable();
        Enumeration<Automaton> enum1 = f.instanceEnumeration(automata2.elements());
        while (enum1.hasMoreElements()) {
            this.addAutomaton(enum1.nextElement());
        }
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)"tioa"));
        retval.add((Object)this.getSymbolTable().toSValue());
        HashSet<SimulationRelation> relations = new HashSet<SimulationRelation>();
        HashSet<Invariant> invariants = new HashSet<Invariant>();
        Enumeration<Automaton> enum1 = this.enumAutomata();
        while (enum1.hasMoreElements()) {
            Automaton aut = enum1.nextElement();
            relations.addAll(aut.getSpecSimulations());
            relations.addAll(aut.getImplSimulations());
            invariants.addAll(aut.getInvariants());
            retval.add((Object)aut.toSValue());
        }
        Iterator r = relations.iterator();
        while (r.hasNext()) {
            retval.add((Object)((SimulationRelation)r.next()).toSValue());
        }
        Iterator i = invariants.iterator();
        while (i.hasNext()) {
            retval.add((Object)((Invariant)i.next()).toSValue());
        }
        return retval;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseSpec(this, ip);
        ip.flush();
    }

    @Override
    public void writeSourceForm(PrintWriter w) throws ILException, IOException {
        throw new RuntimeException("ILtoIOA  and ILtoSource not implemented for TIOA");
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceSpec(this);
    }
}

