/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.util.StringOps;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSort
extends BasicILElement
implements Sort {
    protected static final int SORT_UNEVENTFUL = 0;
    protected static final int SORT_BOOLEAN = 1;
    protected static final int SORT_TYPE = 2;
    protected static final int SORT_ENUM = 3;
    protected static final int SORT_TUPLE = 4;
    protected static final int SORT_UNION = 5;
    protected String id;
    protected String name;
    protected Vector<Sort> subsorts;
    protected String typeAsIdentifier = null;
    protected int kind = 0;
    protected boolean isLiteral;
    protected boolean isDiscrete;
    protected Operator typeConstOp;
    protected String key = null;
    protected Vector<String> enumValues = null;
    protected Vector<String> fieldNames = null;
    protected Vector<Sort> fieldSorts = null;
    protected Operator enumSuccOp;
    protected Vector<String> enumEltNames;
    protected Vector<Operator> enumEltOps;
    protected Sort unionTagSort;
    protected Operator unionTagOp;
    protected Vector<Operator> unionFieldToOps;
    protected Vector<Operator> unionFieldFromOps;
    protected Operator tupleMakeOp;
    protected Vector<Operator> tupleFieldSetOps;
    protected Vector<Operator> tupleFieldGetOps;
    protected Vector<Integer> scope;

    public BasicSort(String id, String name, Vector<Sort> subsorts, boolean isLiteral, boolean isBoolean, boolean isType, boolean isDiscrete, Vector<Integer> scope) {
        this.id = id;
        this.name = name;
        this.subsorts = subsorts;
        this.isLiteral = isLiteral;
        this.isDiscrete = isDiscrete;
        if (isBoolean) {
            this.kind = 1;
        }
        if (isType) {
            this.kind = 2;
        }
        this.scope = scope;
    }

    @Override
    public void setOperator(Operator op) {
        this.typeConstOp = op;
    }

    @Override
    public void setEnumData(Operator succOp, Vector<String> eltNames, Vector<Operator> eltOps) {
        this.kind = 3;
        this.enumSuccOp = succOp;
        this.enumEltNames = eltNames;
        this.enumEltOps = eltOps;
    }

    @Override
    public void setUnionData(Sort tagSort, Operator tagOp, Vector<String> fieldNames, Vector<Sort> fieldSorts, Vector<Operator> fieldToOps, Vector<Operator> fieldFromOps) {
        this.kind = 5;
        this.unionTagSort = tagSort;
        this.unionTagOp = tagOp;
        this.fieldNames = fieldNames;
        this.fieldSorts = fieldSorts;
        this.unionFieldToOps = fieldToOps;
        this.unionFieldFromOps = fieldFromOps;
    }

    @Override
    public void setTupleData(Operator makeOp, Vector<String> fieldNames, Vector<Sort> fieldSorts, Vector<Operator> fieldSetOps, Vector<Operator> fieldGetOps) {
        this.kind = 4;
        this.tupleMakeOp = makeOp;
        this.fieldNames = fieldNames;
        this.fieldSorts = fieldSorts;
        this.tupleFieldSetOps = fieldSetOps;
        this.tupleFieldGetOps = fieldGetOps;
    }

    @Override
    public void setSubsorts(Vector<Sort> subsorts) {
        this.subsorts = subsorts;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Vector<Integer> getScope() {
        return this.scope;
    }

    @Override
    public final boolean isLiteral() {
        return this.isLiteral;
    }

    @Override
    public final boolean isBoolean() {
        return this.kind == 1;
    }

    @Override
    public final boolean isDiscrete() {
        return this.isDiscrete;
    }

    @Override
    public final boolean isType() {
        return this.kind == 2;
    }

    @Override
    public boolean isAutomatonSort() {
        return this.name.equals("automaton") || this.name.equals("_States");
    }

    @Override
    public String getTypeAsIdentifier() {
        if (this.typeAsIdentifier == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(StringOps.replace((String)StringOps.replace((String)this.name, (String)"'", (String)"''"), (String)"_", (String)"__"));
            if (!this.subsorts.isEmpty()) {
                buffer.append("'_");
                Enumeration<Sort> enum1 = this.subsorts.elements();
                buffer.append(enum1.nextElement().getTypeAsIdentifier());
                while (enum1.hasMoreElements()) {
                    buffer.append("'").append(enum1.nextElement().getTypeAsIdentifier());
                }
                buffer.append("_'");
            }
            this.typeAsIdentifier = buffer.toString();
        }
        return this.typeAsIdentifier;
    }

    @Override
    public final boolean isEnum() {
        return this.kind == 3;
    }

    @Override
    public final boolean isTuple() {
        return this.kind == 4;
    }

    @Override
    public final boolean isUnion() {
        return this.kind == 5;
    }

    @Override
    public final Vector<String> getEnumValues() {
        return this.enumValues;
    }

    @Override
    public final Vector<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public final Vector<Sort> getFieldSorts() {
        return this.fieldSorts;
    }

    @Override
    public final Operator getTypeConstOperator() {
        return this.typeConstOp;
    }

    @Override
    public final Vector<Sort> getSubsorts() {
        return this.subsorts;
    }

    @Override
    public Enumeration<Sort> enumSubsorts() {
        return this.subsorts.elements();
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            StringBuffer buf = new StringBuffer().append(this.name).append("@[");
            if (!this.subsorts.isEmpty()) {
                Enumeration<Sort> enum1 = this.subsorts.elements();
                buf.append(enum1.nextElement().getKey());
                while (enum1.hasMoreElements()) {
                    buf.append("$").append(enum1.nextElement().getKey());
                }
            }
            this.key = buf.append("]@").toString();
        }
        return this.key;
    }

    @Override
    public String toString() {
        String result = this.getName();
        if (this.getSubsorts().isEmpty()) {
            return result;
        }
        result = String.valueOf(result) + "[";
        Enumeration<Sort> enum1 = this.getSubsorts().elements();
        while (enum1.hasMoreElements()) {
            Sort sort = enum1.nextElement();
            result = String.valueOf(result) + sort.toString() + ", ";
        }
        result = result.substring(0, result.length() - 2);
        result = String.valueOf(result) + "]";
        return result;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseSort(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceSort(this);
    }

    protected BasicSort(Sort obj, ILInstanceFactory f) throws ILException {
        f.put(obj, this);
        this.id = obj.getId();
        this.name = obj.getName();
        this.isLiteral = obj.isLiteral();
        this.isDiscrete = obj.isDiscrete();
        if (obj.isBoolean()) {
            this.kind = 1;
        } else if (obj.isType()) {
            this.kind = 2;
        } else if (obj.isEnum()) {
            this.kind = 3;
            this.enumValues = new Vector<String>(obj.getEnumValues());
        } else if (obj.isTuple()) {
            this.kind = 4;
            this.fieldNames = (Vector)obj.getFieldNames().clone();
            this.fieldSorts = f.instanceVector(obj.getFieldSorts());
        }
        this.subsorts = f.instanceVector(obj.getSubsorts());
        this.typeConstOp = (Operator)f.makeInstance(obj.getTypeConstOperator());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        f.put(this, this);
        this.subsorts = f.instanceVector(this.subsorts);
        this.typeConstOp = (Operator)f.makeInstance(this.typeConstOp);
        return this;
    }

    @Override
    public Vector<String> getEnumEltNames() {
        return this.enumEltNames;
    }

    @Override
    public Vector<Operator> getEnumEltOps() {
        return this.enumEltOps;
    }

    @Override
    public Operator getEnumSuccOp() {
        return this.enumSuccOp;
    }

    @Override
    public Vector<Operator> getTupleFieldSetOps() {
        return this.tupleFieldSetOps;
    }

    @Override
    public Vector<Operator> getTupleFieldGetOps() {
        return this.tupleFieldGetOps;
    }

    @Override
    public Operator getTupleMakeOp() {
        return this.tupleMakeOp;
    }

    @Override
    public Vector<Operator> getUnionFieldToOps() {
        return this.unionFieldToOps;
    }

    @Override
    public Vector<Operator> getUnionFieldFromOps() {
        return this.unionFieldFromOps;
    }

    @Override
    public Operator getUnionTagOp() {
        return this.unionTagOp;
    }

    @Override
    public Sort getUnionTagSort() {
        return this.unionTagSort;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)this.toSValueId());
        retval.add((Object)SExp.makeSValue((String)("\"" + this.getName() + "\"")));
        SList subsorts = new SList();
        retval.add((Object)subsorts);
        Enumeration<Sort> enum1 = this.enumSubsorts();
        while (enum1.hasMoreElements()) {
            subsorts.add((Object)SExp.makeSValue((String)enum1.nextElement().getId()));
        }
        if (this.isLiteral()) {
            retval.add((Object)SExp.makeSValue((String)"lit"));
        }
        if (this.isDiscrete()) {
            retval.add((Object)SExp.makeSValue((String)"discrete"));
        }
        return retval;
    }

    public SValue toSValueId() {
        return SExp.makeSValue((String)this.getId());
    }
}

