/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Signature;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSignature
extends BasicILElement
implements Signature {
    protected Vector<Sort> domain;
    protected Sort range;

    public BasicSignature(Vector<Sort> domain, Sort range) {
        this.domain = domain;
        this.range = range;
    }

    @Override
    public Vector<Sort> getDomain() {
        return this.domain;
    }

    @Override
    public Enumeration<Sort> enumDomain() {
        return this.domain.elements();
    }

    @Override
    public Sort getRange() {
        return this.range;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseSignature(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceSignature(this);
    }

    protected BasicSignature(Signature obj, ILInstanceFactory f) throws ILException {
        this.domain = f.instanceVector(obj.getDomain());
        this.range = (Sort)f.makeInstance(obj.getRange());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.domain = f.instanceVector(this.domain);
        this.range = (Sort)f.makeInstance(this.range);
        return this;
    }

    @Override
    public String toString() {
        String result = "";
        Enumeration<Sort> domain = this.enumDomain();
        if (domain.hasMoreElements()) {
            while (domain.hasMoreElements()) {
                Sort sort = domain.nextElement();
                result = String.valueOf(result) + sort.toString() + ", ";
            }
            result = result.substring(0, result.length() - 2);
        }
        result = String.valueOf(result) + " -> " + this.getRange().toString();
        return result;
    }

    public SValue toSValue() {
        SList retval = new SList();
        SList domain = new SList();
        retval.add((Object)domain);
        Enumeration<Sort> e = this.enumDomain();
        while (e.hasMoreElements()) {
            Sort s = e.nextElement();
            domain.add((Object)SExp.makeSValue((String)s.getId()));
        }
        retval.add((Object)SExp.makeSValue((String)this.getRange().getId()));
        return retval;
    }
}

