/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.BasicAutomaton;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Task;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.il.nodes.TrajectoryTable;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPrimitiveAutomaton
extends BasicAutomaton
implements PrimitiveAutomaton {
    protected ActionTable actions;
    protected StateTable states;
    protected Vector<FuncDecl> funcDecls;
    protected Term soThat;
    protected Vector<Task> tasks;
    protected TrajectoryTable trajectories;

    public BasicPrimitiveAutomaton(String name, Vector<Term> formals, Term where, ActionTable actions, StateTable states, Vector<FuncDecl> funcDecls, Term soThat, Vector<Task> tasks) {
        this(name, formals, where, actions, states, funcDecls, soThat, tasks, null);
    }

    public BasicPrimitiveAutomaton(String name, Vector<Term> formals, Term where, ActionTable actions, StateTable states, Vector<FuncDecl> funcDecls, Term soThat, Vector<Task> tasks, TrajectoryTable trajectories) {
        super(name, formals, where);
        this.actions = actions;
        this.funcDecls = funcDecls;
        this.states = states;
        this.soThat = soThat;
        this.tasks = tasks;
        this.trajectories = trajectories;
    }

    public BasicPrimitiveAutomaton() {
    }

    @Override
    public void set(String name, Vector<Term> formals, Term where, ActionTable actions, StateTable states, Vector<FuncDecl> funcDecls, Term soThat, Vector<Task> tasks, TrajectoryTable trajectories) {
        super.set(name, formals, where);
        this.actions = actions;
        this.states = states;
        this.funcDecls = funcDecls;
        this.soThat = soThat;
        this.tasks = tasks;
        this.trajectories = trajectories;
    }

    @Override
    public ActionTable getActionTable() {
        return this.actions;
    }

    @Override
    public StateTable getStates() {
        return this.states;
    }

    @Override
    public Vector<FuncDecl> getFuncDecls() {
        return this.funcDecls;
    }

    @Override
    public Term getStateSoThatPred() {
        return this.soThat;
    }

    @Override
    public Vector<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public TrajectoryTable getTrajectoryTable() {
        return this.trajectories;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparsePrimitiveAutomaton(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instancePrimitiveAutomaton(this);
    }

    protected BasicPrimitiveAutomaton(PrimitiveAutomaton obj, ILInstanceFactory f) throws ILException {
        super(obj, f);
        this.actions = (ActionTable)f.makeInstance(obj.getActionTable());
        this.states = (StateTable)f.makeInstance(obj.getStates());
        this.funcDecls = f.instanceVector(obj.getFuncDecls());
        this.soThat = (Term)f.makeInstance(obj.getStateSoThatPred());
        this.tasks = f.instanceVector(obj.getTasks());
        this.trajectories = (TrajectoryTable)f.makeInstance(obj.getTrajectoryTable());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        super.internalSurgery(f);
        this.actions = (ActionTable)f.makeInstance(this.actions);
        this.states = (StateTable)f.makeInstance(this.states);
        this.funcDecls = f.instanceVector(this.funcDecls);
        this.soThat = (Term)f.makeInstance(this.soThat);
        this.tasks = f.instanceVector(this.tasks);
        this.trajectories = (TrajectoryTable)f.makeInstance(this.trajectories);
        return this;
    }

    @Override
    public SValue toSValue() {
        SList retval = (SList)super.toSValue();
        SList primAut = new SList();
        retval.add((Object)primAut);
        SList actions = new SList();
        primAut.add((Object)actions);
        actions.add((Object)SExp.makeSValue((String)"actions"));
        actions.addAll((Collection)((SList)this.getActionTable().toSValue()));
        SList statesTab = SExp.makeSList((SValue)this.getStates().toSValue());
        if (this.soThat != null) {
            SList init = SExp.makeSList((SValue)SExp.makeSValue((String)"initially"));
            init.add((Object)this.soThat.toSValue());
            statesTab.add((Object)init);
        }
        primAut.add((Object)statesTab);
        primAut.add((Object)this.toSValueTransitions());
        if (this.getTrajectoryTable() != null) {
            primAut.add((Object)this.toSValueTrajectories());
        }
        if (this.getTasks() != null && this.getTasks().size() > 0) {
            SList tasks = new SList();
            primAut.add((Object)tasks);
            tasks.add((Object)SExp.makeSValue((String)"tasks"));
            int i = 0;
            while (i < this.getTasks().size()) {
                tasks.add((Object)this.getTasks().elementAt(i).toSValue());
                ++i;
            }
        }
        return retval;
    }

    public SValue toSValueTransitions() {
        SList transitions = new SList();
        transitions.add((Object)SExp.makeSValue((String)"transitions"));
        Enumeration<Action> e = this.getActionTable().enumActions();
        while (e.hasMoreElements()) {
            Action a = e.nextElement();
            Enumeration<Transition> et = a.enumTransitions();
            while (et.hasMoreElements()) {
                Transition ta = et.nextElement();
                transitions.add((Object)ta.toSValue());
            }
        }
        return transitions;
    }

    public SValue toSValueTrajectories() {
        SList trajList = new SList();
        trajList.add((Object)SExp.makeSValue((String)"trajectories"));
        Enumeration e = this.getTrajectoryTable().enumTrajectories();
        while (e.hasMoreElements()) {
            Trajectory t = (Trajectory)e.nextElement();
            trajList.add((Object)t.toSValue());
        }
        return trajList;
    }

    @Override
    public PrimitiveAutomaton copy(String compName) {
        return this;
    }
}

