/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Signature;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicOperator
extends BasicILElement
implements Operator {
    protected String id;
    protected int type;
    protected Vector<Integer> scope;
    protected String name;
    protected String name1;
    protected String name2;
    protected Signature sig;
    protected boolean _isTypeConst;
    private String key = null;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Vector<Integer> getScope() {
        return this.scope;
    }

    public BasicOperator(String id, int type, String name1, String name2, Vector<Sort> domain, Sort range, boolean isTypeConst, Vector<Integer> scope) throws ILException {
        this.id = id;
        this.type = type;
        this.name1 = name1;
        this.name2 = name2;
        this.sig = ILFactory.getInstance().newSignature(domain, range);
        this._isTypeConst = isTypeConst;
        this.scope = scope;
        int masktype = type & 0xF;
        switch (masktype) {
            case 0: {
                this.name = name1;
                break;
            }
            case 1: {
                this.name = "__" + name1 + "__";
                break;
            }
            case 2: {
                this.name = String.valueOf(name1) + "__";
                break;
            }
            case 3: {
                this.name = "__" + name1;
                break;
            }
            case 4: {
                if (name2 == null) {
                    throw new Error();
                }
                boolean before = (type & 0x40) != 0;
                boolean after = (type & 0x80) != 0;
                this.name = String.valueOf(before ? "__" : "") + name1 + "__" + name2 + (after ? "__" : "");
                break;
            }
            case 5: {
                this.name = "@<sel>" + name1;
                break;
            }
            case 6: {
                this.name = "@<const>" + name1;
                break;
            }
            case 7: {
                this.name = "@<if>";
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getName1() {
        return this.name1;
    }

    @Override
    public String getName2() {
        return this.name2;
    }

    @Override
    public Vector<Sort> getDomain() {
        return this.sig.getDomain();
    }

    @Override
    public Sort getRange() {
        return this.sig.getRange();
    }

    @Override
    public Signature getSignature() {
        return this.sig;
    }

    @Override
    public boolean isTypeConst() {
        return this._isTypeConst;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            StringBuffer buf = new StringBuffer().append(this.getName()).append("@{");
            buf.append(this.sig.getRange().getKey());
            Enumeration<Sort> enum1 = this.sig.enumDomain();
            while (enum1.hasMoreElements()) {
                buf.append("$").append(enum1.nextElement().getKey());
            }
            this.key = buf.append("}@").toString();
        }
        return this.key;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + ": " + this.getSignature().toString();
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseOperator(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceOperator(this);
    }

    protected BasicOperator(Operator obj, ILInstanceFactory f) throws ILException {
        f.put(obj, this);
        this.id = obj.getId();
        this.type = obj.getType();
        this.name = obj.getName();
        this.name1 = obj.getName1();
        this.name2 = obj.getName2();
        this._isTypeConst = obj.isTypeConst();
        this.sig = (Signature)f.makeInstance(obj.getSignature());
        this.key = null;
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        f.put(this, this);
        this.sig = (Signature)f.makeInstance(this.sig);
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)this.getId()));
        retval.add((Object)this.toSValueOpName());
        retval.add((Object)this.getSignature().toSValue());
        return retval;
    }

    private SValue toSValueOpName() {
        SList retval = new SList();
        int i = this.getType();
        if (i == 6) {
            retval.add((Object)SExp.makeSValue((String)"const"));
            retval.add((Object)SExp.makeSValue((String)this.getName()));
        } else if (i == 0) {
            retval.add((Object)SExp.makeSValue((String)"id"));
            retval.add((Object)SExp.makeSValue((String)this.getName()));
        } else if (i == 1) {
            retval.add((Object)SExp.makeSValue((String)"infix"));
            retval.add((Object)SExp.makeSValue((String)this.name1));
        } else if (i == 3) {
            retval.add((Object)SExp.makeSValue((String)"postfix"));
            retval.add((Object)SExp.makeSValue((String)"postfix"));
            retval.add((Object)SExp.makeSValue((String)this.name1));
        } else if (i == 7) {
            retval.add((Object)SExp.makeSValue((String)"if"));
        } else if (i == 5) {
            retval.add((Object)SExp.makeSValue((String)"select"));
            retval.add((Object)SExp.makeSValue((String)this.name1));
        } else if (i == 2) {
            retval.add((Object)SExp.makeSValue((String)"prefix"));
            retval.add((Object)SExp.makeSValue((String)this.name1));
        } else {
            retval.add((Object)SExp.makeSValue((String)"mixfix"));
            retval.add((Object)SExp.makeSValue((int)this.getDomain().size()));
            String before = (this.getType() & 0x40) != 0 ? "true" : "false";
            String after = (this.getType() & 0x80) != 0 ? "true" : "false";
            retval.add((Object)SExp.makeSValue((String)before));
            retval.add((Object)SExp.makeSValue((String)after));
            retval.add((Object)SExp.makeSValue((String)this.getName1()));
            retval.add((Object)SExp.makeSValue((String)this.getName2()));
        }
        return retval;
    }
}

