/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.Automaton;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Invariant;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;

public class BasicInvariant
extends BasicILElement
implements Invariant {
    protected String name;
    protected Automaton aut;
    protected Term pred;

    public BasicInvariant(String name, Automaton aut, Term pred) {
        this.name = name;
        this.aut = aut;
        this.pred = pred;
    }

    public Term getPredicate() {
        return this.pred;
    }

    public Automaton getAutomaton() {
        return this.aut;
    }

    public String getName() {
        return this.name;
    }

    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceInvariant(this);
    }

    protected BasicInvariant(Invariant obj, ILInstanceFactory f) throws ILException {
        f.put(obj, this);
        this.name = obj.getName();
        this.pred = (Term)f.makeInstance(obj.getPredicate());
        this.aut = (Automaton)f.makeInstance(obj.getAutomaton());
    }

    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        f.put(this, this);
        this.pred = (Term)f.makeInstance(this.pred);
        this.aut = (Automaton)f.makeInstance(this.aut);
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)"invariant"));
        retval.add((Object)SExp.makeSValue((String)this.getName()));
        retval.add((Object)SExp.makeSValue((String)this.getAutomaton().getName()));
        retval.add((Object)this.getPredicate().toSValue());
        return retval;
    }
}

