/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.ForClause;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicForClause
extends BasicILElement
implements ForClause {
    protected Vector<Variable> vars;
    protected Term where;

    public BasicForClause(Vector<Variable> vars, Term where) {
        this.vars = vars;
        this.where = where;
    }

    @Override
    public Vector<Variable> getVariables() {
        return this.vars;
    }

    @Override
    public Term getWherePred() {
        return this.where;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseForClause(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceForClause(this);
    }

    protected BasicForClause(ForClause obj, ILInstanceFactory f) throws ILException {
        this.vars = f.instanceVector(obj.getVariables());
        this.where = (Term)f.makeInstance(obj.getWherePred());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.vars = f.instanceVector(this.vars);
        this.where = (Term)f.makeInstance(this.where);
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)"for"));
        if (this.getVariables() != null) {
            SList vars = new SList();
            retval.add((Object)vars);
            int i = 0;
            while (i < this.getVariables().size()) {
                Variable v = this.getVariables().elementAt(i);
                vars.add((Object)v.toSValue());
                vars.add((Object)SExp.makeSValue((String)v.getId()));
                ++i;
            }
        }
        if (this.getWherePred() != null) {
            SList where = new SList();
            retval.add((Object)where);
            where.add((Object)SExp.makeSValue((String)"where"));
            where.add((Object)this.getWherePred().toSValue());
        }
        return retval;
    }
}

