/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.BasicStatement;
import com.veromodo.tioa.il.nodes.Conditional;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicConditional
extends BasicStatement
implements Conditional {
    protected Vector<Term> preds;
    protected Vector<Program> progs;
    protected Program elseProg;

    public BasicConditional(Vector<Term> preds, Vector<Program> progs, Program elseProg) {
        this.preds = preds;
        this.progs = progs;
        this.elseProg = elseProg;
        Assert.assertTrue((preds.size() == progs.size() ? 1 : 0) != 0, (String)"Number of predicates and programs must match");
    }

    @Override
    public Vector<Term> getPreds() {
        return this.preds;
    }

    @Override
    public Vector<Program> getProgs() {
        return this.progs;
    }

    @Override
    public Program getElseProg() {
        return this.elseProg;
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseConditional(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceConditional(this);
    }

    protected BasicConditional(Conditional obj, ILInstanceFactory f) throws ILException {
        this.preds = f.instanceVector(obj.getPreds());
        this.progs = f.instanceVector(obj.getProgs());
        this.elseProg = (Program)f.makeInstance(obj.getElseProg());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.preds = f.instanceVector(this.preds);
        this.progs = f.instanceVector(this.progs);
        this.elseProg = (Program)f.makeInstance(this.elseProg);
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)"if"));
        SList predThens = new SList();
        retval.add((Object)predThens);
        int i = 0;
        while (i < this.getPreds().size()) {
            SList predThen = new SList();
            predThens.add((Object)predThen);
            predThen.add((Object)this.getPreds().elementAt(i).toSValue());
            predThen.add((Object)((SPrintable)this.getProgs().elementAt(i)).toSValue());
            ++i;
        }
        if (this.getElseProg() != null) {
            retval.add((Object)this.getElseProg().toSValue());
        }
        return retval;
    }
}

