/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.Automaton;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Invariant;
import com.veromodo.tioa.il.nodes.SimulationRelation;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicAutomaton
extends BasicILElement
implements Automaton {
    protected String name;
    protected Vector<Term> formals;
    protected Term where;
    protected Vector<Invariant> invariants;
    protected Vector<SimulationRelation> implSims;
    protected Vector<SimulationRelation> specSims;

    protected BasicAutomaton(String name, Vector<Term> formals, Term where) {
        this.name = name;
        this.formals = formals;
        this.where = where;
        this.invariants = new Vector();
        this.implSims = new Vector();
        this.specSims = new Vector();
    }

    public void setInvariants(Vector<Invariant> inv) {
        this.invariants = inv;
    }

    protected BasicAutomaton() {
    }

    protected void set(String name, Vector<Term> formals, Term where) {
        this.name = name;
        this.formals = formals;
        this.where = where;
        this.invariants = new Vector();
        this.implSims = new Vector();
        this.specSims = new Vector();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Term getWhere() {
        return this.where;
    }

    @Override
    public void addInvariant(Invariant inv) {
        this.invariants.addElement(inv);
    }

    @Override
    public void addImplSimulation(SimulationRelation sim) {
        this.implSims.addElement(sim);
    }

    @Override
    public void addSpecSimulation(SimulationRelation sim) {
        this.specSims.addElement(sim);
    }

    @Override
    public Vector<Invariant> getInvariants() {
        return this.invariants;
    }

    @Override
    public Enumeration<Invariant> enumInvariants() {
        return this.invariants.elements();
    }

    @Override
    public Enumeration<SimulationRelation> enumImplSimulations() {
        return this.implSims.elements();
    }

    @Override
    public Enumeration<SimulationRelation> enumSpecSimulations() {
        return this.specSims.elements();
    }

    @Override
    public Vector<SimulationRelation> getImplSimulations() {
        return this.implSims;
    }

    @Override
    public Vector<SimulationRelation> getSpecSimulations() {
        return this.specSims;
    }

    @Override
    public abstract ActionTable getActionTable();

    @Override
    public Vector<Term> getFormals() {
        return this.formals;
    }

    protected BasicAutomaton(Automaton obj, ILInstanceFactory f) throws ILException {
        this.name = obj.getName();
        this.where = obj.getWhere();
        this.formals = f.instanceVector(obj.getFormals());
        this.invariants = f.instanceVector(obj.getInvariants());
        this.implSims = f.instanceVector(obj.getImplSimulations());
        this.specSims = f.instanceVector(obj.getSpecSimulations());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.formals = f.instanceVector(this.formals);
        this.where = (Term)f.makeInstance(this.where);
        this.invariants = f.instanceVector(this.invariants);
        this.implSims = f.instanceVector(this.implSims);
        this.specSims = f.instanceVector(this.specSims);
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)"automaton"));
        retval.add((Object)SExp.makeSValue((String)("\"" + this.getName() + "\"")));
        if (this.getFormals() != null) {
            int i = 0;
            while (i < this.getFormals().size()) {
                retval.add((Object)this.getFormals().elementAt(i).toSValue());
                ++i;
            }
        }
        if (this.where != null) {
            SList wherelist = new SList();
            retval.add((Object)wherelist);
            wherelist.add((Object)SExp.makeSValue((String)"where"));
            wherelist.add((Object)this.getWhere().toSValue());
        }
        return retval;
    }
}

