/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.ApplicationTerm;
import com.veromodo.tioa.il.nodes.BasicValue;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.il.util.FreeVarSet;
import com.veromodo.tioa.util.Assert;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicApplicationTerm
extends BasicValue
implements ApplicationTerm {
    protected Operator optor;
    protected Vector<Term> opands;
    protected boolean constant = false;
    private static final IOACategory cat = IOACategory.getInstance(BasicApplicationTerm.class.getName());
    static /* synthetic */ Class class$0;

    public BasicApplicationTerm(Operator optor, Vector<Term> opands) {
        this.optor = optor;
        this.opands = opands;
        int numActuals = opands.size();
        int numFormals = optor.getDomain().size();
        Assert.assertTrue((numActuals == numFormals ? 1 : 0) != 0, (String)("In application of operator " + optor + ", number of actuals (" + numActuals + ") must match number of formals (" + numFormals + ")"));
        if (cat.isDebugEnabled()) {
            cat.debug("Formals: " + optor.getDomain().toString());
            cat.debug("Actuals: " + opands.toString());
        }
        int i = 0;
        while (i < opands.size()) {
            Sort formalSort = optor.getDomain().get(i);
            Sort actualSort = opands.get(i).getSort();
            if (cat.isDebugEnabled()) {
                cat.debug("Formal: " + formalSort + " " + formalSort.hashCode());
                cat.debug("Actual: " + actualSort + " " + actualSort.hashCode());
            }
            ++i;
        }
    }

    @Override
    public Operator getOperator() {
        return this.optor;
    }

    @Override
    public Vector<Term> getOperands() {
        return this.opands;
    }

    @Override
    public Sort getSort() {
        return this.optor.getRange();
    }

    @Override
    public Enumeration enumFreeVars() {
        FreeVarSet s = new FreeVarSet();
        this.getFreeVars(s);
        return s.enumFreeVars();
    }

    @Override
    public void getFreeVars(FreeVarSet s) {
        Enumeration<Term> e = this.opands.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextElement();
            t.getFreeVars(s);
        }
    }

    @Override
    public void replaceVar(Variable original, Variable replacement) {
        Enumeration<Term> e = this.opands.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextElement();
            t.replaceVar(original, replacement);
        }
    }

    @Override
    public Object clone() {
        Vector<Term> o = new Vector<Term>();
        Enumeration<Term> e = this.opands.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextElement();
            o.addElement((Term)t.clone());
        }
        return new BasicApplicationTerm(this.optor, o);
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseApplicationTerm(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceApplicationTerm(this);
    }

    protected BasicApplicationTerm(ApplicationTerm obj, ILInstanceFactory f) throws ILException {
        this.optor = (Operator)f.makeInstance(obj.getOperator());
        this.opands = f.instanceVector(obj.getOperands());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        this.optor = (Operator)f.makeInstance(this.optor);
        this.opands = f.instanceVector(this.opands);
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)"apply"));
        retval.add((Object)SExp.makeSValue((String)this.getOperator().getId()));
        if (this.getOperands() != null) {
            int i = 0;
            while (i < this.getOperands().size()) {
                retval.add((Object)this.getOperands().elementAt(i).toSValue());
                ++i;
            }
        }
        return retval;
    }

    @Override
    public void setConstant() {
        this.constant = true;
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }
}

