/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.NameCollisionException;
import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.BasicAction;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.BasicTransition;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicActionTable
extends BasicILElement
implements ActionTable {
    protected Hashtable<String, Action> table;
    protected Hashtable<String, Transition> transTable;
    protected int uniqueCount = 666;
    protected String uniquePrefix = "$$$a";
    protected String uniqueTransPrefix = "$$$t";
    protected List<Transition> transList = new ArrayList<Transition>();
    protected List<Action> actionList = new ArrayList<Action>();

    public BasicActionTable() {
        this.table = new Hashtable();
        this.transTable = new Hashtable();
    }

    @Override
    public void put(Action act) throws NameCollisionException {
        if (act.getId() == null && act instanceof BasicAction) {
            ((BasicAction)act).id = String.valueOf(this.uniquePrefix) + this.uniqueCount++;
        }
        if (this.table.put(act.getId(), act) != null) {
            throw new NameCollisionException(act.getId());
        }
        this.actionList.add(act);
        Enumeration<Transition> transitions = act.enumTransitions();
        while (transitions.hasMoreElements()) {
            Transition trans = transitions.nextElement();
            this.put(trans);
            trans.setActionId(act.getId());
        }
    }

    @Override
    public void put(Transition trans) throws NameCollisionException {
        if (trans.getTransitionId() == null && trans instanceof BasicTransition) {
            ((BasicTransition)trans).tid = String.valueOf(this.uniqueTransPrefix) + this.uniqueCount++;
        }
        if (this.transTable.put(trans.getTransitionId(), trans) != null) {
            throw new NameCollisionException(trans.getTransitionId());
        }
        this.transList.add(trans);
    }

    @Override
    public Action get(String id) throws LookupException {
        Action act = this.table.get(id);
        if (act != null) {
            return act;
        }
        throw new LookupException(id, "action");
    }

    @Override
    public Transition getTransition(String id) throws LookupException {
        Transition trans = this.transTable.get(id);
        if (trans != null) {
            return trans;
        }
        throw new LookupException(id, "transition");
    }

    @Override
    public Enumeration<Action> enumActions() {
        return Collections.enumeration(this.actionList);
    }

    @Override
    public Enumeration<Transition> enumTransitions() {
        return Collections.enumeration(this.transList);
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseActionTable(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceActionTable(this);
    }

    protected BasicActionTable(ActionTable obj, ILInstanceFactory f) throws ILException {
        this.table = new Hashtable();
        this.transTable = new Hashtable();
        Enumeration<ILElement> enum1 = f.instanceEnumeration(obj.enumActions());
        while (enum1.hasMoreElements()) {
            this.put(enum1.nextElement());
        }
        enum1 = f.instanceEnumeration(obj.enumTransitions());
        while (enum1.hasMoreElements()) {
            this.put((Transition)enum1.nextElement());
        }
    }

    public BasicActionTable appendTable(ActionTable at) throws NameCollisionException {
        BasicActionTable newTable = new BasicActionTable();
        Enumeration<ILElement> enum1 = this.enumActions();
        while (enum1.hasMoreElements()) {
            newTable.put(enum1.nextElement());
        }
        enum1 = this.enumTransitions();
        while (enum1.hasMoreElements()) {
            newTable.put((Transition)enum1.nextElement());
        }
        enum1 = at.enumActions();
        while (enum1.hasMoreElements()) {
            newTable.put((Action)enum1.nextElement());
        }
        enum1 = at.enumTransitions();
        while (enum1.hasMoreElements()) {
            newTable.put((Transition)enum1.nextElement());
        }
        return newTable;
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        Hashtable<String, Action> table2 = this.table;
        this.table = new Hashtable();
        Enumeration<Action> enum1 = f.instanceEnumeration(table2.elements());
        while (enum1.hasMoreElements()) {
            this.put(enum1.nextElement());
        }
        Hashtable<String, Transition> transTable2 = this.transTable;
        this.transTable = new Hashtable();
        Enumeration<Transition> enum12 = f.instanceEnumeration(transTable2.elements());
        while (enum12.hasMoreElements()) {
            this.put(enum12.nextElement());
        }
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        Enumeration<Action> e = this.enumActions();
        while (e.hasMoreElements()) {
            retval.add((Object)e.nextElement().toSValue());
        }
        return retval;
    }
}

