/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il.nodes;

import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILUnparser;
import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.ApplicationTerm;
import com.veromodo.tioa.il.nodes.BasicILElement;
import com.veromodo.tioa.il.nodes.BasicTransition;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILInstanceFactory;
import com.veromodo.tioa.il.nodes.QuantifierTerm;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAction
extends BasicILElement
implements Action {
    protected String id;
    protected int type;
    protected String name;
    protected Vector<Term> formals;
    protected Term where;
    protected Vector<Transition> transitions;

    public BasicAction(String id, int type, String name, Vector<Term> formals, Term where) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.formals = formals != null ? formals : new Vector();
        this.where = where;
        this.transitions = new Vector();
    }

    @Override
    public void addTransition(Transition trans) {
        ((BasicTransition)trans).id = this.id;
        this.transitions.addElement(trans);
    }

    @Override
    public Vector<Term> getFormals() {
        return this.formals;
    }

    @Override
    public final Term getWherePred() {
        return this.where;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final String getTypeString() {
        switch (this.type) {
            case 0: {
                return "input";
            }
            case 1: {
                return "output";
            }
            case 2: {
                return "internal";
            }
        }
        throw new RuntimeException("Unknown action type");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public Vector<Transition> getTransitions() {
        return this.transitions;
    }

    @Override
    public Enumeration<Transition> enumTransitions() {
        return this.transitions.elements();
    }

    @Override
    public void writeILForm(PrintWriter w) throws ILException, IOException {
        iprinter ip = new iprinter(w);
        ILUnparser.unparseAction(this, ip);
        ip.flush();
    }

    @Override
    protected ILElement internalMakeInstance(ILInstanceFactory f) throws ILException {
        return f.instanceAction(this);
    }

    protected BasicAction(Action obj, ILInstanceFactory f) throws ILException {
        f.put(obj, this);
        this.id = obj.getId();
        this.type = obj.getType();
        this.name = obj.getName();
        this.formals = f.instanceVector(obj.getFormals());
        this.where = (Term)f.makeInstance(obj.getWherePred());
        this.transitions = f.instanceVector(obj.getTransitions());
    }

    @Override
    protected ILElement internalSurgery(ILInstanceFactory f) throws ILException {
        f.put(this, this);
        this.formals = f.instanceVector(this.formals);
        this.where = (Term)f.makeInstance(this.where);
        this.transitions = f.instanceVector(this.transitions);
        return this;
    }

    public SValue toSValue() {
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)this.getId()));
        if (this.getType() == 0) {
            retval.add((Object)SExp.makeSValue((String)"input"));
        } else if (this.getType() == 2) {
            retval.add((Object)SExp.makeSValue((String)"internal"));
        } else {
            retval.add((Object)SExp.makeSValue((String)"output"));
        }
        retval.add((Object)SExp.makeSValue((String)("\"" + this.getName() + "\"")));
        if (this.getFormals() != null && this.getFormals().size() > 0) {
            SList formals = new SList();
            retval.add((Object)formals);
            formals.add((Object)SExp.makeSValue((String)"formals"));
            int i = 0;
            while (i < this.getFormals().size()) {
                Term t = this.getFormals().elementAt(i);
                if (t instanceof VarRefTerm) {
                    formals.add((Object)t.toSValue());
                } else if (t instanceof ApplicationTerm || t instanceof QuantifierTerm) {
                    SList constantList = SExp.makeSList((SValue)SExp.makeSValue((String)"const"));
                    constantList.add((Object)t.toSValue());
                    formals.add((Object)constantList);
                } else {
                    throw new RuntimeException("Unknown SortRefTerm in action formal");
                }
                ++i;
            }
            if (this.getWherePred() != null) {
                SList whereClause = new SList();
                retval.add((Object)whereClause);
                whereClause.add((Object)SExp.makeSValue((String)"where"));
                whereClause.add((Object)this.getWherePred().toSValue());
            }
        }
        return retval;
    }
}

