/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il;

import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.ApplicationTerm;
import com.veromodo.tioa.il.nodes.Assignment;
import com.veromodo.tioa.il.nodes.Automaton;
import com.veromodo.tioa.il.nodes.Choice;
import com.veromodo.tioa.il.nodes.Conditional;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.Invariant;
import com.veromodo.tioa.il.nodes.LiteralTerm;
import com.veromodo.tioa.il.nodes.Loop;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.QuantifierTerm;
import com.veromodo.tioa.il.nodes.ReferenceTerm;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.State;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Statement;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.Value;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.util.CollectionsUtils;
import com.veromodo.tioa.util.logger.IOACategory;
import java.util.Iterator;
import java.util.Vector;

public class ILVisitor {
    private static final IOACategory cat = IOACategory.getInstance(ILVisitor.class.getName());
    static /* synthetic */ Class class$0;

    public Object visit(ILElement elt) {
        if (cat.isDebugEnabled()) {
            if (elt != null) {
                cat.debug("starting visit of " + elt.getClass().getName());
            }
            cat.debug(elt);
        }
        if (elt instanceof PrimitiveAutomaton) {
            return this.visitPrimitiveAutomaton((PrimitiveAutomaton)elt);
        }
        if (elt instanceof Automaton) {
            return this.visitAutomaton((Automaton)elt);
        }
        if (elt instanceof Invariant) {
            return this.visitInvariant((Invariant)elt);
        }
        if (elt instanceof Action) {
            return this.visitAction((Action)elt);
        }
        if (elt instanceof Transition) {
            return this.visitTransition((Transition)elt);
        }
        if (elt instanceof State) {
            return this.visitState((State)elt);
        }
        if (elt instanceof Variable) {
            return this.visitVariable((Variable)elt);
        }
        if (elt instanceof Operator) {
            return this.visitOperator((Operator)elt);
        }
        if (elt instanceof Sort) {
            return this.visitSort((Sort)elt);
        }
        if (elt instanceof Assignment) {
            return this.visitAssignment((Assignment)elt);
        }
        if (elt instanceof Conditional) {
            return this.visitConditional((Conditional)elt);
        }
        if (elt instanceof Loop) {
            return this.visitLoop((Loop)elt);
        }
        if (elt instanceof Statement) {
            return this.visitStatement((Statement)elt);
        }
        if (elt instanceof Program) {
            return this.visitProgram((Program)elt);
        }
        if (elt instanceof ApplicationTerm) {
            return this.visitApplicationTerm((ApplicationTerm)elt);
        }
        if (elt instanceof LiteralTerm) {
            return this.visitLiteralTerm((LiteralTerm)elt);
        }
        if (elt instanceof QuantifierTerm) {
            return this.visitQuantifierTerm((QuantifierTerm)elt);
        }
        if (elt instanceof VarRefTerm) {
            return this.visitVarRefTerm((VarRefTerm)elt);
        }
        if (elt instanceof ReferenceTerm) {
            return this.visitReferenceTerm((ReferenceTerm)elt);
        }
        if (elt instanceof Term) {
            return this.visitTerm((Term)elt);
        }
        if (elt instanceof Choice) {
            return this.visitChoice((Choice)elt);
        }
        if (elt instanceof Value) {
            return this.visitValue((Value)elt);
        }
        return elt;
    }

    public Object visitAutomaton(Automaton elt) {
        return elt;
    }

    public Object visitVariable(Variable elt) {
        return this.visit(elt.getSort());
    }

    public Object visitState(State elt) {
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visit(elt.getVariable()));
        result = this.accumulate(elt, result, this.visit(elt.getInitialValue()));
        return result;
    }

    public Object visitOperator(Operator elt) {
        return elt;
    }

    public Object visitSort(Sort elt) {
        return elt;
    }

    public Object visitTransition(Transition elt) {
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visit(elt.getWherePred()));
        if (elt.getChooseFormals() != null) {
            for (Variable var : elt.getChooseFormals()) {
                result = this.accumulate(elt, result, this.visit(var));
            }
        }
        result = this.accumulate(elt, result, this.visit(elt.getPrecondition()));
        result = this.accumulate(elt, result, this.visit(elt.getEffect()));
        return result;
    }

    public Object visitAction(Action elt) {
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visit(elt.getWherePred()));
        Iterator i = elt.getFormals().iterator();
        while (i.hasNext()) {
            result = this.accumulate(elt, result, this.visit((VarRefTerm)i.next()));
        }
        i = CollectionsUtils.enumToIter(elt.enumTransitions());
        while (i.hasNext()) {
            result = this.accumulate(elt, result, this.visit((Transition)i.next()));
        }
        return result;
    }

    public Object visitPrimitiveAutomaton(PrimitiveAutomaton elt) {
        Object result = this.getDefaultAccum();
        ActionTable actionTable = elt.getActionTable();
        Iterator i = CollectionsUtils.enumToIter(actionTable.enumActions());
        while (i.hasNext()) {
            Action action = (Action)i.next();
            result = this.accumulate(elt, result, this.visit(action));
        }
        StateTable stateTable = elt.getStates();
        Iterator i2 = CollectionsUtils.enumToIter(stateTable.enumerate());
        while (i2.hasNext()) {
            State state = (State)i2.next();
            result = this.accumulate(elt, result, this.visit(state));
        }
        i2 = CollectionsUtils.enumToIter(elt.enumInvariants());
        while (i2.hasNext()) {
            result = this.accumulate(elt, result, this.visit((Invariant)i2.next()));
        }
        return result;
    }

    public Object visitInvariant(Invariant elt) {
        return this.visit(elt.getPredicate());
    }

    public Object visitAssignment(Assignment elt) {
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visit(elt.getLValue()));
        result = this.accumulate(elt, result, this.visit(elt.getValue()));
        return result;
    }

    public Object visitConditional(Conditional elt) {
        Object result = this.getDefaultAccum();
        for (Term pred : elt.getPreds()) {
            result = this.accumulate(elt, result, this.visit(pred));
        }
        for (Program prog : elt.getProgs()) {
            result = this.accumulate(elt, result, this.visit(prog));
        }
        result = this.accumulate(elt, result, this.visit(elt.getElseProg()));
        return result;
    }

    public Object visitLoop(Loop elt) {
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visit(elt.getVariable()));
        result = this.accumulate(elt, result, this.visit(elt.getCondition()));
        result = this.accumulate(elt, result, this.visit(elt.getBody()));
        return result;
    }

    public Object visitChoice(Choice elt) {
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visit(elt.getVariable()));
        result = this.accumulate(elt, result, this.visit(elt.getWherePred()));
        return result;
    }

    public Object visitStatement(Statement elt) {
        cat.error("No such thing as a generic statement");
        return elt;
    }

    public Object visitProgram(Program elt) {
        Vector<Statement> statements = elt.getStatements();
        Object result = this.getDefaultAccum();
        for (Statement stmt : statements) {
            result = this.accumulate(elt, result, this.visit(stmt));
        }
        return result;
    }

    public Object visitApplicationTerm(ApplicationTerm elt) {
        Vector<Term> opands = elt.getOperands();
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visitTerm(elt));
        result = this.accumulate(elt, result, this.visit(elt.getOperator()));
        for (Term term : opands) {
            result = this.accumulate(elt, result, this.visit(term));
        }
        return result;
    }

    public Object visitLiteralTerm(LiteralTerm elt) {
        return elt;
    }

    public Object visitQuantifierTerm(QuantifierTerm elt) {
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visitTerm(elt));
        result = this.accumulate(elt, result, this.visit(elt.getVariable()));
        result = this.accumulate(elt, result, this.visit(elt.getTerm()));
        return result;
    }

    public Object visitReferenceTerm(ReferenceTerm elt) {
        return this.visitTerm(elt);
    }

    public Object visitVarRefTerm(VarRefTerm elt) {
        Object result = this.getDefaultAccum();
        result = this.accumulate(elt, result, this.visitTerm(elt));
        return this.accumulate(elt, result, this.visit(elt.getRefVariable()));
    }

    public Object visitTerm(Term elt) {
        return this.visitValue(elt);
    }

    public Object visitValue(Value elt) {
        return this.visit(elt.getSort());
    }

    protected Object accumulate(ILElement elt, Object soFar, Object newResult) {
        return soFar;
    }

    protected Object getDefaultAccum() {
        return null;
    }
}

