/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il;

import com.veromodo.tioa.il.ILParseException;
import com.veromodo.tioa.il.ILParser;
import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.ActionSet;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.ActualAction;
import com.veromodo.tioa.il.nodes.ApplicationTerm;
import com.veromodo.tioa.il.nodes.Assignment;
import com.veromodo.tioa.il.nodes.AutComponent;
import com.veromodo.tioa.il.nodes.Automaton;
import com.veromodo.tioa.il.nodes.Binding;
import com.veromodo.tioa.il.nodes.Choice;
import com.veromodo.tioa.il.nodes.CompositeAutomaton;
import com.veromodo.tioa.il.nodes.Conditional;
import com.veromodo.tioa.il.nodes.ExistsTerm;
import com.veromodo.tioa.il.nodes.ForClause;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.HidingAutomaton;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.LiteralTerm;
import com.veromodo.tioa.il.nodes.Loop;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.QuantifierTerm;
import com.veromodo.tioa.il.nodes.ReferenceTerm;
import com.veromodo.tioa.il.nodes.Signature;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Spec;
import com.veromodo.tioa.il.nodes.State;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Statement;
import com.veromodo.tioa.il.nodes.SymbolTable;
import com.veromodo.tioa.il.nodes.Task;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.Value;
import com.veromodo.tioa.il.nodes.VarRefTerm;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.il.nodes.ndr.NDRILFactory;
import com.veromodo.tioa.util.CollectionsUtils;
import com.veromodo.tioa.util.Iprintable;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.logger.Logger;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class ILUnparser {
    public static void unparseSpec(Spec spec, iprinter ip) throws IOException {
        ip.align().put("tioa");
        ILUnparser.unparseSymbolTable(spec.getSymbolTable(), ip);
        Enumeration<Automaton> enum1 = spec.enumAutomata();
        while (enum1.hasMoreElements()) {
            Automaton aut = enum1.nextElement();
            ILUnparser.unparseAutomaton(aut, ip);
        }
        ip.end();
    }

    public static void unparseSymbolTable(SymbolTable st, iprinter ip) {
        ip.align();
        ip.align();
        ip.put("sorts");
        Enumeration enum1 = ILUnparser.sortBindingEnum(st.enumSorts());
        while (enum1.hasMoreElements()) {
            ILUnparser.unparseSort((Sort)enum1.nextElement(), ip);
        }
        ip.end();
        ip.align();
        ip.put("ops");
        enum1 = ILUnparser.sortBindingEnum(st.enumOperators());
        while (enum1.hasMoreElements()) {
            ILUnparser.unparseOperator((Operator)enum1.nextElement(), ip);
        }
        ip.end();
        ip.align();
        ip.put("vars");
        enum1 = ILUnparser.sortBindingEnum(st.enumVariables());
        while (enum1.hasMoreElements()) {
            ILUnparser.unparseVariable((Variable)enum1.nextElement(), ip);
        }
        ip.end();
        ip.end();
    }

    public static Enumeration sortBindingEnum(Enumeration enum1) {
        return CollectionsUtils.sort((Enumeration)enum1, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                Binding b1 = (Binding)o1;
                Binding b2 = (Binding)o2;
                String id1 = b1.getId();
                String id2 = b2.getId();
                if (id1.length() > id2.length()) {
                    return 1;
                }
                if (id1.length() < id2.length()) {
                    return -1;
                }
                return id1.compareTo(id2);
            }
        });
    }

    public static void unparseSort(Sort sort, iprinter ip) {
        ip.align();
        ip.put(sort.getId());
        ip.put("\"" + sort.getName() + "\"");
        ip.align();
        Enumeration<Sort> enum1 = sort.enumSubsorts();
        while (enum1.hasMoreElements()) {
            ip.put(enum1.nextElement().getId());
        }
        ip.end();
        if (sort.isLiteral()) {
            ip.put("lit");
        }
        ip.end();
    }

    public static void unparseSortId(Sort s, iprinter ip) {
        ILUnparser.unparseId(s.getId(), ip);
    }

    public static void unparseId(String i, iprinter ip) {
        ip.put(i);
    }

    public static void unparseOperator(Operator op, iprinter ip) {
        ip.align();
        ip.put(op.getId());
        ip.align();
        ILUnparser.unparseOpName(op, ip);
        ip.end();
        ILUnparser.unparseSignature(op.getSignature(), ip);
        ip.end();
    }

    public static void unparseVariable(Variable var, iprinter ip) {
        ip.align();
        ip.put(var.getId());
        ip.put("\"" + var.getName() + "\"");
        ILUnparser.unparseSortId(var.getSort(), ip);
        ip.end();
    }

    public static void unparseSignature(Signature sg, iprinter ip) {
        ip.align();
        Enumeration<Sort> e = sg.enumDomain();
        ip.align();
        while (e.hasMoreElements()) {
            Sort s = e.nextElement();
            ILUnparser.unparseSortId(s, ip);
        }
        ip.end();
        ILUnparser.unparseSortId(sg.getRange(), ip);
        ip.end();
    }

    private static void unparseOpName(Operator op, iprinter ip) {
        int i = op.getType();
        if (i == 6) {
            ip.put("const");
            ip.put("\"" + op.getName() + "\"");
        } else if (i == 0) {
            ip.put("id");
            ip.put("\"" + op.getName() + "\"");
        } else if (i == 1) {
            ip.put("infix");
            ip.put("\"" + op.getName() + "\"");
        } else if (i == 3) {
            ip.put("postfix");
            ip.put("postfix");
            ip.put("\"" + op.getName() + "\"");
        } else if (i == 7) {
            ip.put("if");
        } else if (i == 5) {
            ip.put("select");
            ip.put("\"" + op.getName() + "\"");
        } else if (i == 2) {
            ip.put("prefix");
            ip.put("\"" + op.getName() + "\"");
        } else {
            ip.put("mixfix");
            ip.put(op.getDomain().size());
            boolean before = (op.getType() & 0x40) != 0;
            boolean after = (op.getType() & 0x80) != 0;
            ip.put(before);
            ip.put(after);
            ip.put("\"" + op.getName1() + "\"");
            ip.put("\"" + op.getName2() + "\"");
        }
    }

    public static void unparseTerm(Term term, iprinter ip) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)term;
            ILUnparser.unparseApplicationTerm(at, ip);
        } else if (term instanceof QuantifierTerm) {
            QuantifierTerm qt = (QuantifierTerm)term;
            ILUnparser.unparseQuantifierTerm(qt, ip);
        } else if (term instanceof ReferenceTerm) {
            ReferenceTerm rt = (ReferenceTerm)term;
            ILUnparser.unparseReferenceTerm(rt, ip);
        } else if (term instanceof LiteralTerm) {
            LiteralTerm lt = (LiteralTerm)term;
            ILUnparser.unparseLiteralTerm(lt, ip);
        }
    }

    public static void unparseApplicationTerm(ApplicationTerm at, iprinter ip) {
        ip.align();
        ip.put("apply");
        ip.put(at.getOperator().getId());
        if (at.getOperands() != null) {
            int i = 0;
            while (i < at.getOperands().size()) {
                ILUnparser.unparseTerm(at.getOperands().elementAt(i), ip);
                ++i;
            }
        }
        ip.end();
    }

    public static void unparseQuantifierTerm(QuantifierTerm qt, iprinter ip) {
        ip.align();
        if (qt instanceof ExistsTerm) {
            ip.put("exists");
        } else {
            ip.put("all");
        }
        ip.put(qt.getVariable().getId());
        ILUnparser.unparseTerm(qt.getTerm(), ip);
        ip.end();
    }

    public static void unparseReferenceTerm(ReferenceTerm rt, iprinter ip) {
        ip.put(rt.getRefObject().getId());
    }

    public static void unparseLiteralTerm(LiteralTerm lt, iprinter ip) {
        ip.align();
        ip.put("lit");
        ip.put(lt.getSort().getId());
        ip.put(String.valueOf(lt.getValue()));
        ip.end();
    }

    public static void unparseAutomaton(Automaton aut, iprinter ip) {
        ip.align();
        ip.put("automaton");
        ip.put("\"" + aut.getName() + "\"");
        if (aut.getFormals() != null) {
            int i = 0;
            while (i < aut.getFormals().size()) {
                ILUnparser.unparseTerm(aut.getFormals().elementAt(i), ip);
                ++i;
            }
        }
        if (aut instanceof PrimitiveAutomaton) {
            PrimitiveAutomaton pa = (PrimitiveAutomaton)aut;
            ILUnparser.unparsePrimitiveAutomaton(pa, ip);
        } else if (aut instanceof CompositeAutomaton) {
            CompositeAutomaton ca = (CompositeAutomaton)aut;
            ILUnparser.unparseCompositeAutomaton(ca, ip);
        } else if (aut instanceof HidingAutomaton) {
            HidingAutomaton ha = (HidingAutomaton)aut;
            ILUnparser.unparseHidingAutomaton(ha, ip);
        }
        ip.end();
    }

    public static void unparsePrimitiveAutomaton(PrimitiveAutomaton pa, iprinter ip) {
        ip.align();
        ip.align();
        ip.put("actions");
        ILUnparser.unparseActionTable(pa.getActionTable(), ip);
        ip.end();
        ILUnparser.unparseStateTable(pa.getStates(), pa.getStateSoThatPred(), ip);
        ip.align();
        ip.put("transitions");
        ILUnparser.unparseTransitions(pa.getActionTable(), ip);
        ip.end();
        if (pa.getTasks() != null && pa.getTasks().size() > 0) {
            ip.align();
            ip.put("tasks");
            int i = 0;
            while (i < pa.getTasks().size()) {
                ILUnparser.unparseTask(pa.getTasks().elementAt(i), ip);
                ++i;
            }
            ip.end();
        }
        ip.end();
    }

    public static void unparseCompositeAutomaton(CompositeAutomaton ca, iprinter ip) {
        ip.align();
        ip.put("compose");
        Enumeration e = ca.enumComposites();
        while (e.hasMoreElements()) {
            ip.align();
            AutComponent a = (AutComponent)e.nextElement();
            ip.put(a.getAutomaton().getName());
            ip.align();
            ip.put("actuals");
            Enumeration<Term> g = a.getActuals().elements();
            while (g.hasMoreElements()) {
                Term t = g.nextElement();
                ILUnparser.unparseTerm(t, ip);
            }
            ip.end();
            if (a.getCompWhere() != null) {
                ILUnparser.unparseTerm(a.getCompWhere(), ip);
            }
            ip.end();
        }
        ip.end();
    }

    public static void unparseHidingAutomaton(HidingAutomaton ha, iprinter ip) {
        ip.align();
        ip.put("hidden");
        ip.put(ha.getBaseAutomaton().getName());
        ILUnparser.unparseActionSet(ha.getHiddenActions(), ip);
        ip.end();
    }

    public static void unparseAction(Action a, iprinter ip) {
        ip.align();
        ip.put(a.getId());
        if (a.getType() == 0) {
            ip.put("input");
        } else if (a.getType() == 2) {
            ip.put("internal");
        } else {
            ip.put("output");
        }
        ip.put("\"" + a.getName() + "\"");
        if (a.getFormals() != null && a.getFormals().size() > 0) {
            ip.align();
            ip.put("formals");
            int i = 0;
            while (i < a.getFormals().size()) {
                Term t = a.getFormals().elementAt(i);
                if (t instanceof VarRefTerm) {
                    ILUnparser.unparseTerm(t, ip);
                } else if (t instanceof ApplicationTerm || t instanceof QuantifierTerm) {
                    ip.align();
                    ip.put("const");
                    ILUnparser.unparseTerm(t, ip);
                    ip.end();
                } else {
                    throw new RuntimeException("SortRefTerm in action formal");
                }
                ++i;
            }
            if (a.getWherePred() != null) {
                ILUnparser.unparseTerm(a.getWherePred(), ip);
            }
            ip.end();
        }
        ip.end();
    }

    public static void unparseState(State s, iprinter ip) {
        ip.align();
        ip.put(s.getId());
        if (s.getInitialValue() != null) {
            ILUnparser.unparseValue(s.getInitialValue(), ip);
        }
        ip.end();
    }

    public static void unparseValue(Value v, iprinter ip) {
        if (v instanceof Term) {
            ILUnparser.unparseTerm((Term)v, ip);
        } else {
            ILUnparser.unparseChoice((Choice)v, ip);
        }
    }

    public static void unparseChoice(Choice c, iprinter ip) {
        ip.align();
        ip.put("choose");
        ip.fill();
        if (c.getVariable() != null) {
            ip.put(c.getVariable().getId());
            if (c.getWherePred() != null) {
                ILUnparser.unparseTerm(c.getWherePred(), ip);
            }
        } else if (c.getWherePred() != null) {
            ILUnparser.unparseTerm(c.getWherePred(), ip);
        }
        ip.end();
        ip.end();
    }

    public static void unparseActionTable(ActionTable at, iprinter ip) {
        Enumeration<Action> e = at.enumActions();
        while (e.hasMoreElements()) {
            ILUnparser.unparseAction(e.nextElement(), ip);
        }
    }

    public static void unparseTransition(Transition ta, iprinter ip) {
        int i;
        ip.fill();
        ip.put(ta.getTransitionId());
        ip.align();
        if (ta.getCaseName() != null && !ta.getCaseName().equals("")) {
            ip.put("case");
            ip.put(ta.getCaseName());
        }
        ip.end();
        ip.put(ta.getId());
        if (ta.getActionActuals() != null && ta.getActionActuals().size() > 0) {
            ip.align();
            ip.put("actuals");
            i = 0;
            while (i < ta.getActionActuals().size()) {
                ILUnparser.unparseTerm(ta.getActionActuals().elementAt(i), ip);
                ++i;
            }
            ip.end();
        }
        if (ta.getChooseFormals() != null && ta.getChooseFormals().size() > 0) {
            ip.align();
            ip.put("locals");
            i = 0;
            while (i < ta.getChooseFormals().size()) {
                Variable v = ta.getChooseFormals().elementAt(i);
                ip.put(v.getId());
                ++i;
            }
            ip.end();
        }
        if (ta.getWherePred() != null) {
            ip.align();
            ip.put("where");
            ILUnparser.unparseTerm(ta.getWherePred(), ip);
            ip.end();
        }
        if (ta.getPrecondition() != null) {
            ip.align();
            ip.put("pre");
            ILUnparser.unparseTerm(ta.getPrecondition(), ip);
            ip.end();
        }
        if (ta.getEffect() != null && ta.getEffect().getStatements() != null && ta.getEffect().getStatements().size() > 0) {
            ip.align();
            ip.put("eff");
            ILUnparser.unparseProgram(ta.getEffect(), ip);
            if (ta.getSoThatPred() != null) {
                ip.align();
                ip.put("ensuring");
                ILUnparser.unparseTerm(ta.getSoThatPred(), ip);
                ip.end();
            }
            ip.end();
        }
        ip.end();
    }

    public static void unparseTransitions(ActionTable at, iprinter ip) {
        Enumeration<Action> e = at.enumActions();
        while (e.hasMoreElements()) {
            Action a = e.nextElement();
            Enumeration<Transition> et = a.enumTransitions();
            while (et.hasMoreElements()) {
                Transition ta = et.nextElement();
                ILUnparser.unparseTransition(ta, ip);
            }
        }
    }

    public static void unparseTrajectory(Trajectory tj, iprinter ip) {
        int i;
        SList retval = new SList();
        retval.add((Object)SExp.makeSValue((String)tj.getTrajectoryId()));
        retval.add((Object)SExp.makeSValue((String)tj.getTrajectoryName()));
        if (tj.getInvariant() != null) {
            SList invariant = new SList();
            invariant.add((Object)SExp.makeSValue((String)"invariant"));
            invariant.add((Object)tj.getInvariant().toSValue());
            retval.add((Object)invariant);
        }
        if (tj.getStopCondition() != null) {
            SList stopCond = new SList();
            stopCond.add((Object)SExp.makeSValue((String)"stop"));
            stopCond.add((Object)tj.getStopCondition().toSValue());
            retval.add((Object)stopCond);
        }
        SList evolve = new SList();
        evolve.add((Object)SExp.makeSValue((String)"evolve"));
        if (tj.getFuncDeclarations() != null) {
            i = 0;
            while (i < tj.getFuncDeclarations().size()) {
                evolve.add((Object)tj.getFuncDeclarations().elementAt(i).toSValue());
                ++i;
            }
        }
        i = 0;
        while (i < tj.getEvolvePredicates().size()) {
            evolve.add((Object)tj.getEvolvePredicates().elementAt(i).toSValue());
            ++i;
        }
        retval.add((Object)evolve);
        ip.align();
        ip.print((Iprintable)retval);
        ip.end();
    }

    public static void unparseFuncDecl(FuncDecl funcDecl, iprinter ip) {
        System.out.println("function declaration unparsing Not yet implemented");
    }

    public static void unparseProgram(Program pgm, iprinter ip) {
        ip.align();
        if (pgm != null && pgm.getStatements() != null) {
            Enumeration<Statement> e = pgm.getStatements().elements();
            while (e.hasMoreElements()) {
                Statement next = e.nextElement();
                ILUnparser.unparseStatement(next, ip);
            }
        }
        ip.end();
    }

    public static void unparseStatement(Statement s, iprinter ip) {
        if (s instanceof Assignment) {
            Assignment a = (Assignment)s;
            ILUnparser.unparseAssignment(a, ip);
        } else if (s instanceof Conditional) {
            Conditional c = (Conditional)s;
            ILUnparser.unparseConditional(c, ip);
        } else if (s instanceof Loop) {
            Loop l = (Loop)s;
            ILUnparser.unparseLoop(l, ip);
        }
    }

    public static void unparseAssignment(Assignment a, iprinter ip) {
        ip.align();
        ip.put("assign");
        ILUnparser.unparseTerm(a.getLValue(), ip);
        ILUnparser.unparseValue(a.getValue(), ip);
        ip.end();
    }

    public static void unparseConditional(Conditional c, iprinter ip) {
        ip.align();
        ip.put("if");
        ip.align();
        int i = 0;
        while (i < c.getPreds().size()) {
            ip.align();
            ILUnparser.unparseTerm(c.getPreds().elementAt(i), ip);
            ILUnparser.unparseProgram(c.getProgs().elementAt(i), ip);
            ip.end();
            ++i;
        }
        ip.end();
        if (c.getElseProg() != null) {
            ILUnparser.unparseProgram(c.getElseProg(), ip);
        } else {
            ip.fill().end();
        }
        ip.end();
    }

    public static void unparseLoop(Loop l, iprinter ip) {
        ip.align();
        ip.put("for");
        ip.put(l.getVariable().getId());
        ILUnparser.unparseTerm(l.getCondition(), ip);
        ILUnparser.unparseProgram(l.getBody(), ip);
        ILUnparser.unparseExtension(ip);
        ip.end();
    }

    public static void unparseExtension(iprinter ip) {
    }

    public static void unparseStateTable(StateTable st, Term soThat, iprinter ip) {
        ip.align();
        ip.put("states");
        if (soThat != null) {
            ip.align();
            ip.put("initially");
            ILUnparser.unparseTerm(soThat, ip);
            ip.end();
        }
        Enumeration<State> e = st.enumerate();
        while (e.hasMoreElements()) {
            ILUnparser.unparseState(e.nextElement(), ip);
        }
        ip.end();
    }

    public static void unparseTask(Task t, iprinter ip) {
        ip.align();
        ip.put("task");
        if (t.getActions() != null) {
            ILUnparser.unparseActionSet(t.getActions(), ip);
        }
        if (t.getForClause() != null) {
            ILUnparser.unparseForClause(t.getForClause(), ip);
        }
        ILUnparser.unparseExtension(ip);
        ip.end();
    }

    public static void unparseActionSet(ActionSet as, iprinter ip) {
        ip.align();
        if (as.getActions() != null) {
            ip.align();
            int i = 0;
            while (i < as.getActions().size()) {
                ILUnparser.unparseActualAction(as.getActions().elementAt(i), ip);
                ++i;
            }
            ip.end();
        }
        ILUnparser.unparseForClause(as.getForClause(), ip);
        ip.end();
    }

    public static void unparseForClause(ForClause fc, iprinter ip) {
        ip.align();
        ip.put("for");
        if (fc.getVariables() != null) {
            ip.align();
            int i = 0;
            while (i < fc.getVariables().size()) {
                Variable v = fc.getVariables().elementAt(i);
                ip.put(v.getId());
                ++i;
            }
            ip.end();
        }
        if (fc.getWherePred() != null) {
            ip.align();
            ip.put("where");
            ILUnparser.unparseTerm(fc.getWherePred(), ip);
        }
        ip.end();
    }

    public static void unparseActualAction(ActualAction aa, iprinter ip) {
        ip.align();
        ip.put(aa.getAction().getId());
        Vector<Term> actActs = aa.getActuals();
        if (actActs != null) {
            ip.align();
            ip.put("actuals");
            int i = 0;
            while (i < actActs.size()) {
                ILUnparser.unparseTerm(actActs.elementAt(i), ip);
                ++i;
            }
            ip.end();
        }
        ip.end();
    }

    public static void unparsePredicate(Term t, iprinter ip) {
        ILUnparser.unparseTerm(t, ip);
    }

    public static void main(String[] args) {
        Logger.setupLogs();
        try {
            ILFactory.setInstance(new NDRILFactory());
            FileInputStream in = new FileInputStream(new File(args[0]));
            ILParser parser = new ILParser(new InputStreamReader(in));
            Spec spec = parser.getSpec();
            PrintWriter pw = new PrintWriter(System.out);
            iprinter ip = new iprinter(pw);
            spec.toSValue().print(ip);
            ip.flush();
        }
        catch (ILParseException e) {
            e.printStackTrace();
            Throwable f = e.getPiggyback();
            if (f != null) {
                System.err.println("piggyback: ");
                f.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

