/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.il;

import com.veromodo.tioa.il.CacheILFactory;
import com.veromodo.tioa.il.ILException;
import com.veromodo.tioa.il.ILParseException;
import com.veromodo.tioa.il.LookupException;
import com.veromodo.tioa.il.NameCollisionException;
import com.veromodo.tioa.il.TempComponent;
import com.veromodo.tioa.il.nodes.Action;
import com.veromodo.tioa.il.nodes.ActionSet;
import com.veromodo.tioa.il.nodes.ActionTable;
import com.veromodo.tioa.il.nodes.Assignment;
import com.veromodo.tioa.il.nodes.Automaton;
import com.veromodo.tioa.il.nodes.BasicTrajectoryTable;
import com.veromodo.tioa.il.nodes.Binding;
import com.veromodo.tioa.il.nodes.Choice;
import com.veromodo.tioa.il.nodes.CompositeAutomaton;
import com.veromodo.tioa.il.nodes.Conditional;
import com.veromodo.tioa.il.nodes.Constructor;
import com.veromodo.tioa.il.nodes.ForClause;
import com.veromodo.tioa.il.nodes.FuncDecl;
import com.veromodo.tioa.il.nodes.HidingAutomaton;
import com.veromodo.tioa.il.nodes.ILElement;
import com.veromodo.tioa.il.nodes.ILFactory;
import com.veromodo.tioa.il.nodes.Invariant;
import com.veromodo.tioa.il.nodes.Loop;
import com.veromodo.tioa.il.nodes.Operator;
import com.veromodo.tioa.il.nodes.PrimitiveAutomaton;
import com.veromodo.tioa.il.nodes.Program;
import com.veromodo.tioa.il.nodes.SimulationRelation;
import com.veromodo.tioa.il.nodes.Sort;
import com.veromodo.tioa.il.nodes.Spec;
import com.veromodo.tioa.il.nodes.State;
import com.veromodo.tioa.il.nodes.StateTable;
import com.veromodo.tioa.il.nodes.Statement;
import com.veromodo.tioa.il.nodes.SymbolTable;
import com.veromodo.tioa.il.nodes.Task;
import com.veromodo.tioa.il.nodes.Term;
import com.veromodo.tioa.il.nodes.Trajectory;
import com.veromodo.tioa.il.nodes.TrajectoryTable;
import com.veromodo.tioa.il.nodes.Transition;
import com.veromodo.tioa.il.nodes.Value;
import com.veromodo.tioa.il.nodes.Variable;
import com.veromodo.tioa.il.nodes.VocabRef;
import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.logger.IOACategory;
import com.veromodo.tioa.util.logger.Logger;
import com.veromodo.tioa.util.sexp.SExp;
import com.veromodo.tioa.util.sexp.SExpException;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SNumber;
import com.veromodo.tioa.util.sexp.SParser;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ILParser {
    static IOACategory debug = IOACategory.getInstance(ILParser.class.getName());
    private CacheILFactory fact;
    private Spec spec;
    public SymbolTable st;
    private Reader reader;
    public ActionTable actions;
    protected boolean warnings;
    public SimulationRelation curSimRel = null;
    public PrimitiveAutomaton curPrimAut = null;
    public Automaton curAut = null;
    public TrajectoryTable trajTable = new BasicTrajectoryTable();
    public Hashtable<String, TempComponent> compNameToTempComp = new Hashtable();
    public Hashtable<String, String> handleNameToCompName = new Hashtable();
    public static final String SPECIAL_BOOLEAN = "s0";
    public static final String SPECIAL_TYPE = "s1";
    public String context;
    private Sort universalSort;
    private int dummyCounter = 1;
    static /* synthetic */ Class class$0;

    private ILParseException errorUnrecognized(String elt) {
        return new ILParseException("unrecognized element while parsing " + this.context + ": " + elt);
    }

    private void warn(String warning) {
        debug.debug("warning while parsing " + this.context + " in line * " + ": " + warning);
    }

    public String setContext(String c) {
        this.context = c;
        return this.context;
    }

    public Variable newDummyVariable() throws ILException {
        String name = "dummyVar" + this.dummyCounter;
        return this.fact.newVariable(name, name, this.universalSort, null);
    }

    public Spec getSpec() throws ILParseException, IOException {
        try {
            debug.debug("getSpec: making parser");
            SParser parser = new SParser();
            SValue sValue = parser.parse(this.reader);
            if (!(sValue instanceof SList)) {
                throw new ILParseException("no s-expression found");
            }
            SList sSpec = (SList)sValue;
            this.parseSpec(sSpec);
            debug.debug("getSpec: spec parsed");
            Enumeration enum1 = this.fact.elements();
            while (enum1.hasMoreElements()) {
                ILElement elt = (ILElement)enum1.nextElement();
                if (debug.isDebugEnabled()) {
                    debug.debug("getSpec: setting spec for " + elt.toString());
                }
                elt.setSpec(this.spec);
                if (debug.isDebugEnabled()) {
                    debug.debug("getSpec: initializing " + elt.toString());
                }
                elt.initialize();
            }
            this.fact.clear();
            debug.debug("getSpec: spec registered with elements");
            return this.spec;
        }
        catch (SExpException e) {
            throw new ILParseException("error parsing " + this.context + " [" + e.toString() + "]", (Exception)((Object)e));
        }
        catch (NoSuchElementException e) {
            throw new ILParseException("error parsing " + this.context + " [" + e.toString() + "]", e);
        }
        catch (ILParseException e) {
            throw e;
        }
        catch (LookupException e) {
            throw new ILParseException("lookup error while parsing " + this.context + " [" + e.toString() + "]", (Exception)((Object)e));
        }
        catch (NameCollisionException e) {
            throw new ILParseException("name collision while parsing " + this.context + " [" + e.toString() + "]", (Exception)((Object)e));
        }
        catch (ILException e) {
            throw new ILParseException("unexpected error while parsing " + this.context + " [" + e.toString() + "]", (Exception)((Object)e));
        }
        catch (ClassCastException e) {
            throw new ILParseException("error parsing " + this.context + " [" + e.toString() + "]", e);
        }
    }

    public ILParser(Reader r) throws ILParseException, IOException {
        this(r, false);
    }

    public ILParser(Reader r, boolean warnings) throws ILParseException, IOException {
        try {
            this.fact = new CacheILFactory(ILFactory.getInstance());
            this.universalSort = this.fact.newSort("universalSort", "universalSort", new Vector<Sort>(), false, false, false, false, new Vector<Integer>());
        }
        catch (ILException e) {
            throw new ILParseException("error initializing parser", (Exception)((Object)e));
        }
        this.reader = r;
        this.warnings = warnings;
    }

    public final void assertHead(SList sexp, String s) throws ILParseException, IOException, SExpException {
        if (sexp.size() < 1) {
            throw new ILParseException("parse error: expected non empty s-exp while parsing " + this.context);
        }
        if (!sexp.getString(0).equals(s)) {
            throw new ILParseException("parse error: expected \"" + s + "\", while parsing " + this.context);
        }
    }

    public final void assertLength(SList sexp, int n) throws ILParseException, IOException, SExpException {
        if (sexp.size() != n) {
            throw new ILParseException("parse error: wrong number of sub-expressions in " + sexp.toString() + ", while parsing " + this.context);
        }
    }

    public final void assertLengthMin(SList sexp, int n) throws ILParseException, IOException, SExpException {
        if (sexp.size() < n) {
            throw new ILParseException("parse error: insufficient number of sub-expressions in " + sexp.toString() + ", while parsing " + this.context);
        }
    }

    public void parseSpec(SList sSpec) throws ILException, SExpException, IOException {
        debug.debug("parseSpec");
        String oldContext = this.setContext("spec");
        this.assertHead(sSpec, "tioa");
        this.assertLengthMin(sSpec, 2);
        debug.debug("parseSpec: sufficient number of arguments");
        this.spec = this.fact.newSpec();
        this.st = this.spec.getSymbolTable();
        Iterator i = sSpec.iterator();
        this.parseDeclarations(sSpec.getSList(1));
        i.next();
        i.next();
        while (i.hasNext()) {
            SList sexp = SExp.getSList((Object)((SValue)i.next()));
            this.assertLengthMin(sexp, 1);
            String head = sexp.getString(0);
            if (head.equals("automaton")) {
                this.parseAutomaton(sexp);
                continue;
            }
            if (head.equals("invariant")) {
                this.parseInvariant(sexp);
                continue;
            }
            if (head.equals("sim")) {
                this.parseSimulation(sexp);
                continue;
            }
            if (head.equals("vocabulary")) {
                this.parseVocabulary(sexp);
                continue;
            }
            if (head.equals("let")) {
                Vector<FuncDecl> funcDecls = this.parseFuncDecls(sexp);
                this.spec.addFuncDecls(funcDecls);
                continue;
            }
            throw this.errorUnrecognized(head);
        }
        this.setContext(oldContext);
    }

    public void parseEnum(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("enum");
        this.assertHead(sexp, "enum");
        this.assertLengthMin(sexp, 4);
        Sort sort = this.st.getSort(sexp.getString(1));
        Operator succOp = this.st.getOperator(sexp.getString(2));
        Vector<String> eltNames = new Vector<String>();
        Vector<Operator> eltOps = new Vector<Operator>();
        int i = 3;
        while (i < sexp.size()) {
            SList sexp2 = sexp.getSList(i);
            this.assertLength(sexp2, 2);
            eltNames.addElement(sexp2.getString(0));
            eltOps.addElement(this.st.getOperator(sexp2.getString(1)));
            ++i;
        }
        this.st.makeEnumSort(sort, succOp, eltNames, eltOps);
        this.setContext(oldContext);
    }

    public void parseUnion(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("union");
        this.assertHead(sexp, "union");
        this.assertLengthMin(sexp, 5);
        Sort sort = this.st.getSort(sexp.getString(1));
        Sort tagSort = this.st.getSort(sexp.getString(2));
        Operator tagOp = this.st.getOperator(sexp.getString(3));
        Vector<String> fieldNames = new Vector<String>();
        Vector<Sort> fieldSorts = new Vector<Sort>();
        Vector<Operator> fieldToOps = new Vector<Operator>();
        Vector<Operator> fieldFromOps = new Vector<Operator>();
        Vector<Operator> enumOps = new Vector<Operator>();
        int i = 4;
        while (i < sexp.size()) {
            SList sexp2 = sexp.getSList(i);
            this.assertLength(sexp2, 4);
            fieldNames.addElement(sexp2.getString(0));
            fieldSorts.addElement(this.st.getSort(sexp2.getString(1)));
            fieldToOps.addElement(this.st.getOperator(sexp2.getString(2)));
            fieldFromOps.addElement(this.st.getOperator(sexp2.getString(3)));
            Operator enumOp = this.fact.newOperator("tempop" + i, 0, sexp2.getString(0), "", new Vector<Sort>(), tagSort, false, new Vector<Integer>());
            enumOps.add(enumOp);
            ++i;
        }
        Vector<Sort> succOpdomain = new Vector<Sort>();
        succOpdomain.add(tagSort);
        Operator succOp = this.fact.newOperator("tempop_succ", 0, "succ", "", succOpdomain, tagSort, false, new Vector<Integer>());
        this.st.makeEnumSort(tagSort, succOp, fieldNames, enumOps);
        this.st.makeUnionSort(sort, tagSort, tagOp, fieldNames, fieldSorts, fieldToOps, fieldFromOps);
        this.setContext(oldContext);
    }

    public void parseTuple(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("tuple");
        this.assertHead(sexp, "tuple");
        this.assertLengthMin(sexp, 4);
        Sort sort = this.st.getSort(sexp.getString(1));
        Operator makeOp = this.st.getOperator(sexp.getString(2));
        Vector<String> fieldNames = new Vector<String>();
        Vector<Sort> fieldSorts = new Vector<Sort>();
        Vector<Operator> fieldSetOps = new Vector<Operator>();
        Vector<Operator> fieldGetOps = new Vector<Operator>();
        int i = 3;
        while (i < sexp.size()) {
            SList sexp2 = sexp.getSList(i);
            this.assertLength(sexp2, 4);
            fieldNames.addElement(sexp2.getString(0));
            fieldSorts.addElement(this.st.getSort(sexp2.getString(1)));
            fieldSetOps.addElement(this.st.getOperator(sexp2.getString(2)));
            fieldGetOps.addElement(this.st.getOperator(sexp2.getString(3)));
            ++i;
        }
        this.st.makeTupleSort(sort, makeOp, fieldNames, fieldSorts, fieldSetOps, fieldGetOps);
        this.setContext(oldContext);
    }

    public void parseImports(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("imports");
        this.assertHead(sexp, "imports");
        SList sexp2 = sexp.getSList(1);
        if (!sexp2.getString(0).equals("vocabulary")) {
            throw this.errorUnrecognized(sexp2.getString(0));
        }
        this.parseVocabRef(sexp2);
        this.setContext(oldContext);
    }

    public VocabRef parseVocabRef(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("vocabRef");
        this.assertHead(sexp, "vocabulary");
        this.assertLength(sexp, 3);
        String vocabName = sexp.getString(1);
        SList actualsList = sexp.getSList(2);
        LinkedList<Sort> actualParameters = new LinkedList<Sort>();
        int i = 1;
        while (i < actualsList.size()) {
            String actual = actualsList.getString(i);
            Sort sort = this.st.getSort(actual);
            actualParameters.add(sort);
            ++i;
        }
        VocabRef vocabRef = this.fact.newVocabRef(vocabName, actualParameters);
        this.setContext(oldContext);
        return vocabRef;
    }

    public void parseExtensions(ILElement elt, SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseExtensions " + sexp + ";");
        }
        int i = 0;
        while (i < sexp.size()) {
            this.parseTrailing(elt, sexp.getSList(i));
            ++i;
        }
    }

    public void parseTrailing(ILElement elt, SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseTrailing for " + elt + " with " + sexp);
        }
        this.assertLengthMin(sexp, 1);
        String head = sexp.getString(0);
        String oldContext = this.setContext(String.valueOf(this.context) + ": extension=\"" + head + "\"");
        elt.parseExtension(sexp, this);
        this.setContext(oldContext);
    }

    public void parseAutomaton(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseAutomaton: " + sexp);
        }
        String oldContext = this.setContext("automaton");
        this.assertHead(sexp, "automaton");
        this.assertLengthMin(sexp, 3);
        String name = sexp.getString(1);
        SList contentsSexp = sexp.getSList(2);
        this.assertLengthMin(sexp, 1);
        int autStart = 2;
        Vector<Term> formals = new Vector();
        if (contentsSexp.get(0) instanceof SString && contentsSexp.getString(0).equals("formals")) {
            formals = this.parseFormals(contentsSexp);
            if (debug.isDebugEnabled()) {
                debug.debug("Formals exist: " + formals);
            }
            contentsSexp = sexp.getSList(3);
            autStart = 3;
        }
        if (debug.isDebugEnabled()) {
            debug.debug("contentsSexp: " + contentsSexp);
        }
        Term where = null;
        if (contentsSexp.get(0) instanceof SString && contentsSexp.getString(0).equals("where")) {
            where = this.parseWhere(contentsSexp);
            if (debug.isDebugEnabled()) {
                debug.debug("Where exist: " + where);
            }
            contentsSexp = sexp.getSList(++autStart);
        }
        if (debug.isDebugEnabled()) {
            debug.debug("contentsSexp: " + contentsSexp);
        }
        Automaton aut = null;
        SList firstContent = SExp.getSList((Object)contentsSexp.get(0));
        String firstContentHead = SExp.getString((Object)firstContent.get(0));
        if (firstContentHead.equals("actions")) {
            aut = this.parsePrimitiveAut(name, formals, where, contentsSexp);
            int i = autStart + 1;
            while (i < sexp.size()) {
                this.parseTrailing(aut, sexp.getSList(i));
                ++i;
            }
        } else if (firstContentHead.equals("compose")) {
            debug.debug("Parsing composition automaton: " + contentsSexp);
            aut = this.parseCompositeAut(name, formals, where, contentsSexp);
        } else {
            throw this.errorUnrecognized(firstContentHead);
        }
        this.spec.addAutomaton(aut);
        this.setContext(oldContext);
    }

    public Term parseWhere(SList sexp) throws ILException, SExpException, IOException {
        debug.debug("parseWhere " + sexp);
        String oldContext = this.setContext("where");
        this.assertHead(sexp, "where");
        Term where = this.parseTerm((SValue)sexp.get(1));
        this.setContext(oldContext);
        return where;
    }

    public Vector<Term> parseFormals(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseFormals " + sexp);
        }
        String oldContext = this.setContext("formal parameters");
        this.assertHead(sexp, "formals");
        Vector<Term> formals = new Vector<Term>();
        int i = 1;
        while (i < sexp.size()) {
            formals.addElement(this.parseTerm((SValue)sexp.get(i)));
            ++i;
        }
        this.setContext(oldContext);
        return formals;
    }

    public PrimitiveAutomaton parsePrimitiveAut(String name, Vector<Term> formals, Term where, SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parsePrimitiveAutomaton");
        }
        String oldContext = this.setContext("primitive automaton");
        this.curPrimAut = this.fact.newPrimitiveAutomaton();
        this.curAut = this.curPrimAut;
        this.assertLengthMin(sexp, 3);
        Iterator i = sexp.iterator();
        this.parseActions(SExp.getSList(i.next()));
        Term[] soThat = new Term[1];
        StateTable states = this.parseStates(SExp.getSList(i.next()), soThat, name, this.curAut);
        Vector<FuncDecl> funcDecls = null;
        boolean parsedTransitions = false;
        SList sexpExtension = null;
        Vector<Task> tasks = null;
        boolean parsedTrajectories = false;
        TrajectoryTable trajectories = null;
        while (i.hasNext()) {
            SList sexp2 = SExp.getSList(i.next());
            this.assertLengthMin(sexp2, 1);
            String head = sexp2.getString(0);
            if (head.equals("let")) {
                funcDecls = this.parseFuncDecls(sexp2);
                continue;
            }
            if (head.equals("transitions")) {
                if (parsedTransitions) {
                    throw new ILParseException("multiple transition definitions given in primitive automaton");
                }
                if (tasks != null) {
                    throw new ILParseException("transitions must come before tasks in primitive automaton");
                }
                this.parseTransitions(sexp2);
                parsedTransitions = true;
                continue;
            }
            if (head.equals("trajectories")) {
                if (parsedTrajectories) {
                    throw new ILParseException("multiple trajectory definitions given in primitive automaton");
                }
                if (tasks != null) {
                    throw new ILParseException("trajectories must come before tasks in primitive automaton");
                }
                this.parseTrajectories(sexp2);
                parsedTrajectories = true;
                continue;
            }
            if (head.equals("tasks")) {
                if (tasks != null) {
                    throw new ILParseException("multiple task definitions given in primitive automaton");
                }
                tasks = this.parseTasks(sexp2);
                continue;
            }
            sexpExtension = sexp2;
            break;
        }
        trajectories = this.trajTable;
        this.curPrimAut.set(name, formals, where, this.actions, states, funcDecls, soThat[0], tasks, trajectories);
        PrimitiveAutomaton aut = this.curPrimAut;
        if (sexpExtension != null) {
            this.parseTrailing(aut, sexpExtension);
            while (i.hasNext()) {
                this.parseTrailing(aut, SExp.getSList(i.next()));
            }
        }
        this.curAut = null;
        this.curPrimAut = null;
        this.actions = null;
        this.setContext(oldContext);
        return aut;
    }

    public ActionTable parseActions(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseActions");
        }
        String oldContext = this.setContext("automaton actions");
        this.assertHead(sexp, "actions");
        this.assertLengthMin(sexp, 1);
        this.actions = this.fact.newActionTable();
        Iterator i = sexp.iterator();
        i.next();
        while (i.hasNext()) {
            SList actionSexp = SExp.getSList(i.next());
            this.actions.put(this.parseAction(actionSexp));
        }
        this.setContext(oldContext);
        return this.actions;
    }

    public Action parseAction(SList sexp) throws ILException, SExpException, IOException {
        int type;
        if (debug.isDebugEnabled()) {
            debug.debug("parseAction " + sexp.toString());
        }
        String oldContext = this.setContext("action");
        this.assertLengthMin(sexp, 3);
        String id = sexp.getString(0);
        String typeStr = sexp.getString(1);
        if (typeStr.equals("input")) {
            type = 0;
        } else if (typeStr.equals("output")) {
            type = 1;
        } else if (typeStr.equals("internal")) {
            type = 2;
        } else {
            throw this.errorUnrecognized(typeStr);
        }
        String name = sexp.getString(2);
        Vector<Term> formals = null;
        Term where = null;
        int startTrailing = 3;
        if (sexp.size() > 3 && sexp.getSList(3).getString(0).equals("formals")) {
            formals = this.parseFormals(sexp.getSList(3));
            startTrailing = 4;
            if (sexp.size() > 4 && sexp.getSList(4).getString(0).equals("where")) {
                where = this.parseHeadedTerm("where", "where clause", sexp.getSList(4), false, false);
                startTrailing = 5;
            }
        }
        Action act = this.fact.newAction(id, type, name, formals, where);
        while (startTrailing < sexp.size()) {
            this.parseTrailing(act, sexp.getSList(startTrailing));
            ++startTrailing;
        }
        this.setContext(oldContext);
        return act;
    }

    public ActionSet parseActionSet(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("action set");
        this.assertLengthMin(sexp, 1);
        SList sexp2 = sexp.getSList(0);
        ActionSet actSet = this.fact.newActionSet();
        Iterator i = sexp2.iterator();
        while (i.hasNext()) {
            SList sexp3 = SExp.getSList(i.next());
            this.assertLengthMin(sexp3, 1);
            Action act = this.actions.get(sexp3.getString(0));
            if (sexp3.size() >= 2) {
                this.assertLength(sexp3, 2);
                actSet.addAction(act, this.parseActionActuals(sexp3.getSList(1)));
                continue;
            }
            actSet.addAction(act, null);
        }
        if (sexp.size() >= 2) {
            actSet.setForClause(this.parseForClause(sexp.getSList(1)));
            this.assertLength(sexp, 2);
        }
        this.setContext(oldContext);
        return actSet;
    }

    public Vector<Term> parseActionActuals(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseActionActuals: " + sexp);
        }
        String oldContext = this.setContext("action actuals");
        this.assertHead(sexp, "actuals");
        Vector<Term> actuals = new Vector<Term>();
        Iterator i = sexp.iterator();
        i.next();
        while (i.hasNext()) {
            actuals.add(this.parseTerm((SValue)i.next()));
        }
        this.setContext(oldContext);
        return actuals;
    }

    public Vector<Variable> parseLocalVariables(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseLocalVariables: " + sexp);
        }
        String oldContext = this.setContext("local Variables");
        this.assertHead(sexp, "locals");
        Vector<Variable> locals = new Vector<Variable>();
        int j = 1;
        while (j < sexp.size()) {
            locals.add(this.st.getVariable(sexp.getString(j)));
            ++j;
        }
        this.setContext(oldContext);
        return locals;
    }

    public StateTable parseStates(SList sexp, Term[] soThat, String name, Automaton aut) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("states");
        this.assertHead(sexp, "states");
        this.assertLengthMin(sexp, 1);
        StateTable states = this.fact.newStateTable();
        soThat[0] = null;
        int i = 1;
        while (i < sexp.size()) {
            SList sexp2 = sexp.getSList(i);
            if (sexp2.getString(0).equals("initially") && soThat[0] == null) {
                soThat[0] = this.parseHeadedTerm("initially", "initially clause", sexp2, false, false);
            } else if (sexp2.getString(0).equals("det")) {
                this.parseTrailing(aut, sexp.getSList(i));
            } else {
                states.put(this.parseState(sexp2, name));
            }
            ++i;
        }
        this.setContext(oldContext);
        return states;
    }

    public StateTable parseStates(SList sexp, Term[] soThat) throws ILException, SExpException, IOException {
        return this.parseStates(sexp, soThat, "", null);
    }

    public State parseState(SList sexp, String name) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("state");
        this.assertLengthMin(sexp, 1);
        Variable var = this.st.getVariable(sexp.getString(0));
        var.setAutName(name);
        Value val = null;
        if (sexp.size() > 1) {
            val = this.parseValue((SValue)sexp.get(1));
            this.assertLength(sexp, 2);
        }
        State state = this.fact.newState(var, val, this.curAut.getName());
        this.setContext(oldContext);
        return state;
    }

    public void parseTransitions(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseTransitions");
        }
        String oldContext = this.setContext("transitions");
        this.assertHead(sexp, "transitions");
        this.assertLengthMin(sexp, 2);
        Iterator i = sexp.iterator();
        i.next();
        while (i.hasNext()) {
            this.actions.put(this.parseTransition(SExp.getSList(i.next())));
        }
        this.setContext(oldContext);
    }

    public Transition parseTransition(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseTransition " + sexp);
        }
        String oldContext = this.setContext("transition");
        boolean DOING_ACTUALS = false;
        boolean DOING_WHERE = true;
        int DOING_LET = 3;
        int DOING_PRE = 4;
        int DOING_EFF = 5;
        int DOING_EXTENSIONS = 6;
        int DOING_LOCALS = 7;
        this.assertLengthMin(sexp, 3);
        Iterator i = sexp.iterator();
        String tid = SExp.getString(i.next());
        SList caseList = SExp.getSList(i.next());
        String caseName = "";
        if (caseList.size() > 1) {
            SValue caseN = caseList.getSValue(1);
            caseName = caseN instanceof SNumber ? ((SNumber)caseN).toString() : ((SString)caseN).toString();
        }
        String aid = SExp.getString(i.next());
        Vector<Term> actuals = null;
        Term where = null;
        Vector<Variable> chooseActuals = null;
        Vector<Variable> locals = null;
        Vector<FuncDecl> funcDecls = null;
        Term precondition = null;
        Program effect = null;
        Term soThat = null;
        SList extSexp = null;
        int doing = 0;
        block8: while (i.hasNext()) {
            SList sexp2 = SExp.getSList(i.next());
            this.assertLengthMin(sexp2, 1);
            String head = sexp2.getString(0);
            switch (doing) {
                case 0: {
                    doing = 7;
                    if (head.equals("actuals")) {
                        actuals = this.parseActionActuals(sexp2);
                        break;
                    }
                }
                case 7: {
                    doing = 1;
                    if (head.equals("locals")) {
                        locals = this.parseLocalVariables(sexp2);
                        break;
                    }
                }
                case 1: {
                    doing = 3;
                    if (actuals != null && head.equals("where")) {
                        where = this.parseHeadedTerm("where", "where clause", sexp2, false, false);
                        break;
                    }
                }
                case 3: {
                    doing = 4;
                    if (head.equals("let")) {
                        funcDecls = this.parseFuncDecls(sexp2);
                        break;
                    }
                }
                case 4: {
                    doing = 5;
                    if (head.equals("pre")) {
                        precondition = this.parseHeadedTerm("pre", "precondition", sexp2, false, false);
                        break;
                    }
                }
                case 5: {
                    doing = 6;
                    if (head.equals("eff")) {
                        this.assertLengthMin(sexp2, 2);
                        effect = this.parseProgram(sexp2.getSList(1));
                        if (sexp2.size() < 3) continue block8;
                        this.assertLength(sexp2, 4);
                        soThat = this.parseHeadedTerm("ensuring", "ensuring clause", sexp2.rest(2), false, false);
                        break;
                    }
                }
                default: {
                    extSexp = sexp2;
                    break block8;
                }
            }
        }
        Action action = this.actions.get(aid);
        if (actuals == null) {
            actuals = new Vector<Term>();
        }
        Transition trans = this.fact.newTransition(tid, caseName, action, aid, actuals, funcDecls, where, chooseActuals, precondition, effect, soThat, locals);
        if (extSexp != null) {
            this.parseTrailing(trans, extSexp);
            while (i.hasNext()) {
                this.parseTrailing(trans, SExp.getSList(i.next()));
            }
        }
        action.addTransition(trans);
        this.setContext(oldContext);
        return trans;
    }

    public void parseTrajectories(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseTrajectories");
        }
        String oldContext = this.setContext("trajectories");
        this.assertHead(sexp, "trajectories");
        this.assertLengthMin(sexp, 1);
        Iterator i = sexp.iterator();
        i.next();
        this.trajTable = this.fact.newTrajectoryTable();
        while (i.hasNext()) {
            this.trajTable.putTrajectory(this.parseTrajectory(SExp.getSList(i.next())));
        }
        this.setContext(oldContext);
    }

    public Trajectory parseTrajectory(SList slist) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseTrajectory " + slist);
        }
        String oldContext = this.setContext("trajectory");
        this.assertLengthMin(slist, 3);
        Iterator i = slist.iterator();
        String tjId = SExp.getString(i.next());
        String tjName = SExp.getString(i.next());
        Term invariant = null;
        Term stopCond = null;
        Vector<FuncDecl> funcDecls = null;
        Vector<Term> evolvePreds = new Vector<Term>();
        while (i.hasNext()) {
            SList slist2 = SExp.getSList(i.next());
            this.assertLengthMin(slist2, 2);
            String head = slist2.getString(0);
            if (head.equals("invariant")) {
                invariant = this.parseHeadedTerm("invariant", "Trajectory Invariant", slist2, false, false);
                continue;
            }
            if (head.equals("let")) {
                if (funcDecls == null) {
                    funcDecls = new Vector<FuncDecl>();
                }
                funcDecls.addAll(this.parseFuncDecls(slist2));
                continue;
            }
            if (head.equals("stop")) {
                stopCond = this.parseHeadedTerm("stop", "Stop when condition", slist2, false, false);
                continue;
            }
            if (!head.equals("evolve")) continue;
            Iterator i2 = slist2.iterator();
            i2.next();
            while (i2.hasNext()) {
                SList slist3 = SExp.getSList(i2.next());
                this.assertLengthMin(slist3, 1);
                evolvePreds.add(this.parseTerm((SValue)slist3));
            }
        }
        Trajectory traj = this.fact.newTrajectory(tjId, tjName, invariant, stopCond, funcDecls, evolvePreds);
        this.setContext(oldContext);
        return traj;
    }

    public Vector<FuncDecl> parseFuncDecls(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("funcDecls");
        this.assertHead(sexp, "let");
        Iterator i = sexp.iterator();
        i.next();
        Vector<FuncDecl> funcDecls = new Vector<FuncDecl>();
        while (i.hasNext()) {
            Object next = i.next();
            funcDecls.add(this.parseFuncDecl(SExp.getSList(next)));
        }
        this.setContext(oldContext);
        return funcDecls;
    }

    public FuncDecl parseFuncDecl(SList slist) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("Function Declaration");
        this.assertLengthMin(slist, 2);
        String opId = slist.getString(0);
        Term term = this.parseTerm((SValue)slist.getLast());
        Vector<Term> varRefTerms = new Vector<Term>();
        int i = 0;
        while (i < slist.size() - 2) {
            varRefTerms.add(this.parseTerm(slist.getSValue(i + 1)));
            ++i;
        }
        this.setContext(oldContext);
        return this.fact.newFuncDecl(opId, varRefTerms, term);
    }

    public Vector<Task> parseTasks(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("tasks");
        this.assertHead(sexp, "tasks");
        Vector<Task> tasks = new Vector<Task>();
        Iterator i = sexp.iterator();
        while (i.hasNext()) {
            tasks.add(this.parseTask(SExp.getSList(i.next())));
        }
        this.setContext(oldContext);
        return tasks;
    }

    public Task parseTask(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("task");
        this.assertLengthMin(sexp, 1);
        ActionSet actSet = this.parseActionSet(sexp.getSList(0));
        ForClause forClause = null;
        if (sexp.size() > 1 && sexp.getSList(1).getString(0).equals("for")) {
            forClause = this.parseForClause(sexp.getSList(1));
        }
        Task task = this.fact.newTask(actSet, forClause);
        int i = forClause == null ? 1 : 2;
        while (i < sexp.size()) {
            this.parseTrailing(task, sexp.getSList(i));
            ++i;
        }
        this.setContext(oldContext);
        return task;
    }

    public void parseVocabulary(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("vocabulary");
        int i = 2;
        while (i < sexp.size()) {
            int j;
            SList sublist = sexp.getSList(i);
            String head = sublist.getSString(0).toString();
            if (head.equals("imports")) {
                j = 1;
                while (j < sublist.size()) {
                    VocabRef vocabRef = this.parseVocabRef(sublist.getSList(j));
                    ++j;
                }
            } else if (head.equals("sorts")) {
                j = 1;
                while (j < sublist.size()) {
                    if (sublist.get(j) instanceof SList && sublist.getSList(j).getFirst() instanceof SString) {
                        if (sublist.getSList(j).getSString(0).toString().equals("tuple")) {
                            this.parseTuple(sublist.getSList(j));
                        } else if (sublist.getSList(j).getSString(0).toString().equals("union")) {
                            this.parseUnion(sublist.getSList(j));
                        } else if (sublist.getSList(j).getSString(0).toString().equals("enum")) {
                            this.parseEnum(sublist.getSList(j));
                        } else {
                            throw new ILException("error while parsing sorts in vocabulary");
                        }
                    }
                    ++j;
                }
            } else if (!(head.equals("ops") || head.equals("formals") || head.equals("actuals") || head.equals("defines"))) {
                throw new ILParseException("unknown element in vocabulary: " + sublist + " head= " + head);
            }
            ++i;
        }
        this.setContext(oldContext);
    }

    public void parseDeclarations(SList sexp) throws ILException, SExpException, IOException {
        debug.debug("parseDeclarations");
        String oldContext = this.setContext("declarations");
        this.assertLengthMin(sexp, 3);
        SList sublist = sexp.getSList(0);
        this.assertHead(sublist, "sorts");
        int i = 1;
        while (i < sublist.size()) {
            this.putSym(this.st, this.parseSort(sublist.getSList(i)));
            ++i;
        }
        sublist = sexp.getSList(1);
        this.assertHead(sublist, "constructors");
        i = 1;
        while (i < sublist.size()) {
            this.parseConstructor(sublist.getSList(i));
            ++i;
        }
        sublist = sexp.getSList(2);
        this.assertHead(sublist, "ops");
        i = 1;
        while (i < sublist.size()) {
            this.putSym(this.st, this.parseOperator(sublist.getSList(i)));
            ++i;
        }
        sublist = sexp.getSList(3);
        this.assertHead(sublist, "vars");
        i = 1;
        while (i < sublist.size()) {
            this.putSym(this.st, this.parseVariable(sublist.getSList(i)));
            ++i;
        }
        if (sexp.size() >= 5) {
            sublist = sexp.getSList(4);
            i = 1;
            while (i < sublist.size()) {
                this.parseTrailing(this.st, sublist.getSList(i));
                ++i;
            }
        }
        this.setContext(oldContext);
    }

    public Sort parseSort(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseSort: " + sexp.toString());
        }
        String oldContext = this.setContext("sort");
        this.assertLengthMin(sexp, 4);
        String id = sexp.getString(0).toString();
        String name = sexp.getString(1).toString();
        Vector<Sort> subsorts = new Vector<Sort>();
        SList subsortsSexp = sexp.getSList(2);
        Iterator i = subsortsSexp.iterator();
        while (i.hasNext()) {
            subsorts.add(this.st.getSort(SExp.getString(i.next())));
        }
        boolean isLiteral = false;
        boolean isDiscrete = false;
        if (sexp.size() >= 4 && sexp.get(3) instanceof SString) {
            String sym = sexp.getString(3);
            if (sym.equals("lit")) {
                isLiteral = true;
            } else if (sym.equals("discrete")) {
                isDiscrete = true;
            } else {
                throw this.errorUnrecognized(sym);
            }
            if (sexp.size() >= 5 && sexp.get(4) instanceof SString) {
                String sym2 = sexp.getString(4);
                if (sym2.equals("lit")) {
                    isLiteral = true;
                } else if (sym2.equals("discrete")) {
                    isDiscrete = true;
                } else {
                    throw this.errorUnrecognized(sym);
                }
            }
        }
        int start = 3;
        if (isLiteral) {
            ++start;
        }
        if (isDiscrete) {
            ++start;
        }
        Vector<Integer> scope = new Vector<Integer>();
        SList scopesSexp = sexp.getSList(start);
        int i2 = 1;
        while (i2 < scopesSexp.size()) {
            scope.add(new Integer(scopesSexp.getInt(i2)));
            ++i2;
        }
        Sort sort = this.fact.newSort(id, name, subsorts, isLiteral, isDiscrete, id.equals(SPECIAL_BOOLEAN), id.equals(SPECIAL_TYPE), scope);
        int i3 = start + 1;
        while (i3 < sexp.size()) {
            this.parseTrailing(sort, sexp.getSList(i3));
            ++i3;
        }
        this.setContext(oldContext);
        return sort;
    }

    public void parseConstructor(SList sexp) throws ILException, SExpException, IOException {
        debug.debug("parseConstructor: " + sexp.toString());
        String oldContext = this.setContext("constructor");
        this.assertLengthMin(sexp, 4);
        String id = sexp.getString(0).toString();
        String name = sexp.getString(1).toString();
        int arity = sexp.getInt(2);
        Vector<Integer> scope = new Vector<Integer>();
        SList scopesSexp = sexp.getSList(3);
        int i = 1;
        while (i < scopesSexp.size()) {
            scope.add(new Integer(scopesSexp.getInt(i)));
            ++i;
        }
        Constructor cons = this.fact.newConstructor(id, name, arity, scope);
        Enumeration<Sort> e = this.st.enumSorts();
        while (e.hasMoreElements()) {
            Sort s = e.nextElement();
            this.replaceSortName(cons, s);
        }
        int i2 = 4;
        while (i2 < sexp.size()) {
            this.parseTrailing(cons, sexp.getSList(i2));
            ++i2;
        }
        this.setContext(oldContext);
    }

    private void replaceSortName(Constructor c, Sort s) throws ILException {
        if (s.getName().equals(c.getId()) && !c.getName().startsWith("_")) {
            debug.debug("Sort " + s.toString() + " matches constructor " + c.getId() + " " + c.getName());
            s.setName(c.getName());
        }
        Enumeration<Sort> e = s.enumSubsorts();
        while (e.hasMoreElements()) {
            Sort sub = e.nextElement();
            debug.debug("Testing subsort: " + sub);
            this.replaceSortName(c, sub);
        }
    }

    public Operator parseOperator(SList sexp) throws ILException, SExpException, IOException {
        int type;
        if (debug.isDebugEnabled()) {
            debug.debug("parseOperator: " + sexp.toString());
        }
        String oldContext = this.setContext("operator");
        this.assertLengthMin(sexp, 3);
        String id = sexp.getString(0);
        String name = null;
        String name2 = null;
        SList typeSexp = sexp.getSList(1);
        String typeStr = typeSexp.getString(0);
        if (typeStr.equals("mixfix")) {
            type = 4;
            if (typeSexp.getString(2).equals("true")) {
                type |= 0x40;
            }
            if (typeSexp.getString(3).equals("true")) {
                type |= 0x80;
            }
            name = typeSexp.getString(4);
            name2 = typeSexp.getString(5);
        } else if (typeStr.equals("if")) {
            type = 7;
            name = "@<if>";
        } else {
            if (typeStr.equals("id")) {
                type = 0;
            } else if (typeStr.equals("infix")) {
                type = 1;
            } else if (typeStr.equals("prefix")) {
                type = 2;
            } else if (typeStr.equals("postfix")) {
                type = 3;
            } else if (typeStr.equals("select")) {
                type = 5;
            } else if (typeStr.equals("const")) {
                type = 6;
            } else {
                throw this.errorUnrecognized(typeStr);
            }
            name = typeSexp.getString(1);
        }
        SList sigSexp = sexp.getSList(2);
        this.assertLength(sigSexp, 2);
        Vector<Sort> domain = new Vector<Sort>();
        SList domainSexp = sigSexp.getSList(0);
        Iterator i = domainSexp.iterator();
        while (i.hasNext()) {
            domain.add(this.st.getSort(SExp.getString(i.next())));
        }
        Sort range = this.st.getSort(sigSexp.getString(1));
        boolean isTypeConst = range.isType() && domain.isEmpty();
        Sort sort = null;
        if (isTypeConst) {
            try {
                sort = this.st.getSort(name);
            }
            catch (LookupException e) {
                isTypeConst = false;
                this.warn("suspicious type-valued operator: " + name);
            }
        }
        Vector<Integer> scope = new Vector<Integer>();
        SList scopesSexp = sexp.getSList(sexp.size() - 1);
        int i2 = 1;
        while (i2 < scopesSexp.size()) {
            scope.add(new Integer(scopesSexp.getInt(i2)));
            ++i2;
        }
        Operator op = this.fact.newOperator(id, type, name, name2, domain, range, isTypeConst, scope);
        int i3 = 3;
        while (i3 < sexp.size()) {
            this.parseTrailing(op, sexp.getSList(i3));
            ++i3;
        }
        if (isTypeConst) {
            sort.setOperator(op);
        }
        this.setContext(oldContext);
        return op;
    }

    public Variable parseVariable(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseVariable: " + sexp.toString());
        }
        String oldContext = this.setContext("variable");
        this.assertLengthMin(sexp, 3);
        String id = sexp.getString(0);
        String name = sexp.get(1).toString();
        Sort sort = this.st.getSort(sexp.getString(2));
        Vector<Integer> scope = new Vector<Integer>();
        SList scopesSexp = sexp.getSList(3);
        int i = 1;
        while (i < scopesSexp.size()) {
            scope.add(new Integer(scopesSexp.getInt(i)));
            ++i;
        }
        Variable var = this.fact.newVariable(id, name, sort, scope);
        int i2 = 4;
        while (i2 < sexp.size()) {
            this.parseTrailing(var, sexp.getSList(i2));
            ++i2;
        }
        this.setContext(oldContext);
        return var;
    }

    public CompositeAutomaton parseCompositeAut(String name, Vector<Term> formals, Term where, SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("composite automaton");
        SList schedule = null;
        boolean withBlock = false;
        debug.debug("Parse composite: " + name);
        debug.debug("Parse composite: " + formals);
        debug.debug("Parse composite: " + where);
        debug.debug("Parse composite: " + sexp);
        this.assertLengthMin(sexp, 2);
        SList components = SExp.getSList((Object)sexp.get(0));
        this.assertHead(components, "compose");
        CompositeAutomaton aut = this.fact.newCompositeAutomaton(name, formals, where);
        if (sexp.size() > 2) {
            schedule = SExp.getSList((Object)sexp.get(2));
            SList firstList = SExp.getSList((Object)schedule.get(1));
            String firstScheduleWord = firstList.getString(0);
            if (firstScheduleWord.equals("with")) {
                withBlock = true;
            }
            debug.debug("First schedule word : " + firstScheduleWord);
        }
        this.curAut = aut;
        Iterator i = components.iterator();
        i.next();
        while (i.hasNext()) {
            TempComponent tComp;
            PrimitiveAutomaton copiedAut;
            PrimitiveAutomaton sAut;
            SList sexp2 = SExp.getSList(i.next());
            this.assertLengthMin(sexp2, 1);
            int compSize = sexp2.size();
            int next = 1;
            debug.debug("Comp : " + sexp2 + " has size : " + compSize);
            String compName = sexp2.getString(0);
            debug.debug("comp name : " + compName);
            String baseName = null;
            Vector<Term> actuals = null;
            Vector<Term> compFormals = null;
            Term compWhere = null;
            if (sexp2.size() >= 2) {
                int k;
                SList sexpF;
                if (sexp2.size() >= 4) {
                    debug.debug("Parsing actuals");
                    debug.debug(sexp2.get(1).getClass());
                    sexpF = sexp2.getSList(next);
                    compFormals = new Vector<Term>();
                    this.assertHead(sexpF, "formals");
                    k = 1;
                    while (k < sexpF.size()) {
                        compFormals.add(this.parseTerm((SValue)sexpF.get(k)));
                        ++k;
                    }
                    ++next;
                }
                if (sexp2.size() >= 3) {
                    debug.debug("List For Base Name: " + sexp2);
                    debug.debug("Next : " + next);
                    if (sexp2.get(next) instanceof SString) {
                        baseName = sexp2.getString(next);
                    } else {
                        baseName = compName;
                        sexpF = sexp2.getSList(next);
                        compFormals = new Vector();
                        this.assertHead(sexpF, "formals");
                        k = 1;
                        while (k < sexpF.size()) {
                            compFormals.add(this.parseTerm((SValue)sexpF.get(k)));
                            ++k;
                        }
                    }
                    ++next;
                }
                debug.debug("compFormals:" + compFormals);
                debug.debug("List For Actuals: " + sexp2);
                debug.debug("Next : " + next);
                SList sexp3 = sexp2.getSList(next);
                actuals = new Vector<Term>();
                if (sexp3.size() > 0) {
                    this.assertHead(sexp3, "actuals");
                    int j = 1;
                    while (j < sexp3.size() - 1) {
                        actuals.add(this.parseTerm((SValue)sexp3.get(j)));
                        ++j;
                    }
                    compWhere = this.parseTerm((SValue)sexp3.getLast());
                }
            }
            if (baseName == null) {
                debug.debug("null basename");
                baseName = compName;
                sAut = (PrimitiveAutomaton)this.spec.getAutomaton(baseName);
                copiedAut = sAut.copy(compName);
                aut.addComponent(copiedAut, compFormals, actuals, compWhere, compName);
                continue;
            }
            if (withBlock) {
                tComp = new TempComponent(compFormals, baseName, actuals, compWhere);
                this.compNameToTempComp.put(compName, tComp);
                sAut = (PrimitiveAutomaton)this.spec.getAutomaton(baseName);
                copiedAut = sAut.copy(compName);
                aut.addComponent(copiedAut, compFormals, actuals, compWhere, compName);
                continue;
            }
            sAut = (PrimitiveAutomaton)this.spec.getAutomaton(baseName);
            copiedAut = sAut.copy(compName);
            tComp = new TempComponent(null, baseName, null, null);
            this.compNameToTempComp.put(compName, tComp);
            aut.addComponent(copiedAut, compFormals, actuals, compWhere, compName);
        }
        if (schedule != null) {
            this.parseTrailing(aut, schedule);
        }
        this.curAut = null;
        this.setContext(oldContext);
        return aut;
    }

    public HidingAutomaton parseHidingAut(String name, Vector<Term> formals, SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("action-hiding automaton");
        this.assertHead(sexp, "hidden");
        this.assertLength(sexp, 3);
        Automaton aut = this.spec.getAutomaton(sexp.getString(1));
        ActionTable oldActions = this.actions;
        this.actions = aut.getActionTable();
        ActionSet actionSet = this.parseActionSet(sexp.getSList(2));
        this.actions = oldActions;
        HidingAutomaton hidAut = this.fact.newHidingAutomaton(name, formals, null, aut, actionSet);
        this.setContext(oldContext);
        return hidAut;
    }

    public void parseInvariant(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseInvariant: " + sexp.toString());
        }
        String oldContext = this.setContext("invariant");
        this.assertHead(sexp, "invariant");
        this.assertLength(sexp, 4);
        String invName = sexp.getString(1);
        if (invName.length() == 0) {
            invName = null;
        }
        Automaton aut = this.spec.getAutomaton(sexp.getString(2));
        Term pred = this.parseTerm((SValue)sexp.get(3));
        Invariant inv = this.fact.newInvariant(invName, aut, pred);
        aut.addInvariant(inv);
        this.setContext(oldContext);
    }

    /*
     * WARNING - void declaration
     */
    public void parseSimulation(SList sexp) throws ILException, SExpException, IOException {
        void var4_4;
        SimulationRelation sim;
        boolean kind;
        String oldContext = this.setContext("simulation relation");
        this.assertHead(sexp, "sim");
        this.assertLengthMin(sexp, 5);
        String kindStr = sexp.getString(1);
        if (kindStr.equals("forward")) {
            kind = false;
        } else if (kindStr.equals("backward")) {
            kind = true;
        } else {
            throw this.errorUnrecognized(kindStr);
        }
        Automaton aut1 = this.spec.getAutomaton(sexp.getString(2));
        Automaton aut2 = this.spec.getAutomaton(sexp.getString(3));
        Term pred = this.parseTerm((SValue)sexp.get(4));
        this.curSimRel = sim = this.fact.newSimulationRelation((int)var4_4, aut1, aut2, pred);
        this.parseExtensions(sim, new SList(sexp.subList(5, sexp.size())));
        this.curSimRel = null;
        aut1.addImplSimulation(sim);
        aut2.addSpecSimulation(sim);
        this.setContext(oldContext);
    }

    public Program parseProgram(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseProgram: " + sexp.toString());
        }
        debug.debug("parseProgram: " + sexp.toString());
        String oldContext = this.setContext("program");
        Vector<Statement> statements = new Vector<Statement>();
        Iterator i = sexp.iterator();
        while (i.hasNext()) {
            Statement stmt = null;
            SList sexp2 = SExp.getSList(i.next());
            this.assertLengthMin(sexp2, 1);
            String head = sexp2.getString(0);
            if (head.equals("assign")) {
                stmt = this.parseAssignment(sexp2);
            } else if (head.equals("if")) {
                stmt = this.parseConditional(sexp2);
            } else if (head.equals("for")) {
                stmt = this.parseLoop(sexp2);
            } else {
                stmt = this.fact.parseExtendedStatement(head, sexp2, this);
                if (stmt == null) {
                    throw this.errorUnrecognized(head);
                }
            }
            statements.add(stmt);
        }
        Program prog = this.fact.newProgram(statements);
        this.setContext(oldContext);
        return prog;
    }

    public Term parseHeadedTerm(String head, String _context, SList sexp, boolean allowEmpty, boolean allowMore) throws ILException, SExpException, IOException {
        String oldContext = this.setContext(_context);
        if (allowEmpty && sexp.size() == 0) {
            return null;
        }
        this.assertHead(sexp, head);
        Term term = this.parseTerm((SValue)sexp.get(1));
        if (!allowMore) {
            this.assertLength(sexp, 2);
        }
        this.setContext(oldContext);
        return term;
    }

    public Assignment parseAssignment(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("assignment");
        this.assertHead(sexp, "assign");
        this.assertLength(sexp, 3);
        Term lvalue = this.parseTerm((SValue)sexp.get(1));
        Value value = this.parseValue((SValue)sexp.get(2));
        Assignment ass = this.fact.newAssignment(lvalue, value);
        this.setContext(oldContext);
        return ass;
    }

    public Loop parseLoop(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("loop");
        this.assertHead(sexp, "for");
        this.assertLengthMin(sexp, 4);
        Variable var = this.st.getVariable(sexp.getString(1));
        Term term = this.parseTerm((SValue)sexp.get(2));
        Program prog = this.parseProgram(sexp.getSList(3));
        Loop loop = this.fact.newLoop(var, term, prog);
        int i = 4;
        while (i < sexp.size()) {
            this.parseTrailing(loop, sexp.getSList(i));
            ++i;
        }
        this.setContext(oldContext);
        return loop;
    }

    public Conditional parseConditional(SList sexp) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseConditional: " + sexp);
        }
        String oldContext = this.setContext("conditional");
        this.assertHead(sexp, "if");
        this.assertLengthMin(sexp, 2);
        SList sexp2 = sexp.getSList(1);
        Vector<Term> preds = new Vector<Term>();
        Vector<Program> progs = new Vector<Program>();
        int i = 0;
        while (i < sexp2.size()) {
            SList sexp3 = sexp2.getSList(i);
            if (debug.isDebugEnabled()) {
                debug.debug("parseConditional pred pair: " + sexp3);
            }
            this.assertLength(sexp3, 2);
            preds.add(this.parseTerm((SValue)sexp3.get(0)));
            progs.add(this.parseProgram(sexp3.getSList(1)));
            ++i;
        }
        Program elseProg = null;
        if (sexp.size() > 2) {
            this.assertLength(sexp, 3);
            sexp2 = sexp.getSList(2);
            if (sexp2.size() > 0) {
                elseProg = this.parseProgram(sexp2);
            }
        }
        Conditional cond = this.fact.newConditional(preds, progs, elseProg);
        this.setContext(oldContext);
        return cond;
    }

    public Value parseValue(SValue sval) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("value");
        Value value = null;
        if (sval instanceof SList) {
            SList sexp = (SList)sval;
            this.assertLengthMin(sexp, 1);
            if (sexp.getString(0).equals("choose")) {
                value = this.parseChoice(sexp);
            }
        }
        if (value == null) {
            value = this.parseTerm(sval);
        }
        this.setContext(oldContext);
        return value;
    }

    public Choice parseChoice(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("choice");
        Choice choice = null;
        this.assertHead(sexp, "choose");
        Variable var = null;
        Term pred = null;
        if (sexp.size() > 1) {
            SList choiceVarList = sexp.getSList(1);
            if (choiceVarList.size() >= 1) {
                var = this.st.getVariable(choiceVarList.getString(0));
            }
            if (choiceVarList.size() >= 2) {
                pred = this.parseTerm((SValue)choiceVarList.get(1));
                this.assertLength(choiceVarList, 2);
            }
        }
        choice = this.fact.newChoice(var, pred);
        int i = 2;
        while (i < sexp.size()) {
            this.parseTrailing(choice, sexp.getSList(i));
            ++i;
        }
        this.setContext(oldContext);
        return choice;
    }

    public void storeComp(String compName, TempComponent tc) {
        this.compNameToTempComp.put(compName, tc);
    }

    public void storeHandle(String handleName, String compName) {
        this.handleNameToCompName.put(handleName, compName);
    }

    public TempComponent getTempComp(String compName) {
        return this.compNameToTempComp.get(compName);
    }

    public String getCompName(String handleName) {
        return this.handleNameToCompName.get(handleName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Term parseTerm(SValue sval) throws ILException, SExpException, IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("parseTerm: " + sval.toString() + ";");
        }
        String oldContext = this.setContext("term");
        Term term = null;
        if (sval instanceof SString) {
            String str = SExp.getString((Object)sval);
            Binding b = this.st.get(str);
            term = b instanceof Variable ? this.fact.newReferenceTerm((Variable)b) : (b instanceof Operator ? this.fact.newApplicationTerm((Operator)b, new Vector<Term>()) : this.fact.newReferenceTerm((Sort)b));
        } else {
            if (!(sval instanceof SList)) throw new ILException("error parsing term: " + sval.toString() + " is not a term");
            SList sexp = SExp.getSList((Object)sval);
            this.assertLengthMin(sexp, 1);
            String head = sexp.getString(0);
            if (head.equals("apply")) {
                this.assertLengthMin(sexp, 2);
                Operator optor = this.st.getOperator(sexp.getString(1));
                Vector<Term> opands = new Vector<Term>();
                int i = 2;
                while (i < sexp.size()) {
                    opands.add(this.parseTerm((SValue)sexp.get(i)));
                    ++i;
                }
                term = this.fact.newApplicationTerm(optor, opands);
                if (debug.isDebugEnabled()) {
                    debug.debug("result: " + term.getClass().toString() + " " + term + term.hashCode());
                }
            } else if (head.equals("all")) {
                this.assertLengthMin(sexp, 3);
                Variable var = this.st.getVariable(sexp.getString(1));
                Term term2 = this.parseTerm((SValue)sexp.get(2));
                term = this.fact.newForAllTerm(var, term2);
            } else if (head.equals("exists")) {
                this.assertLengthMin(sexp, 3);
                Variable var = this.st.getVariable(sexp.getString(1));
                Term term2 = this.parseTerm((SValue)sexp.get(2));
                term = this.fact.newExistsTerm(var, term2);
            } else if (head.equals("lit")) {
                this.assertLengthMin(sexp, 3);
                Sort sort = this.st.getSort(sexp.getString(1));
                int val = (int)sexp.getNumber(2);
                term = this.fact.newLiteralTerm(sort, val);
            } else {
                if (!head.equals("const")) throw new ILParseException("error parsing term: \"" + head + "\" is unknown");
                term = this.parseTerm((SValue)sexp.get(1));
                term.setConstant();
            }
        }
        this.setContext(oldContext);
        return term;
    }

    public ForClause parseForClause(SList sexp) throws ILException, SExpException, IOException {
        String oldContext = this.setContext("for clause for " + this.context);
        this.assertHead(sexp, "for");
        this.assertLengthMin(sexp, 2);
        SList sexp2 = sexp.getSList(1);
        Vector<Variable> vars = new Vector<Variable>();
        int i = 0;
        while (i < sexp2.size()) {
            vars.addElement(this.st.getVariable(sexp2.getString(i)));
            ++i;
        }
        Term where = null;
        if (sexp.size() >= 3) {
            where = this.parseHeadedTerm("where", "where clause for " + oldContext, sexp.getSList(2), false, false);
            this.assertLength(sexp, 3);
        }
        ForClause forClause = this.fact.newForClause(vars, where);
        this.setContext(oldContext);
        return forClause;
    }

    public void putSym(SymbolTable st, Binding b) throws NameCollisionException {
        try {
            st.get(b.getId());
            this.warn("repeated definition of binding " + b.getId() + " (" + b.getName() + ")");
            st.replace(b);
        }
        catch (LookupException e) {
            st.put(b);
        }
    }

    public Spec getSpecInProgress() {
        return this.spec;
    }

    public static void main(String[] args) {
        if (args.length > 1 && args[1].equalsIgnoreCase("d")) {
            Logger.setupLogs(Logger.DEBUG);
        } else {
            Logger.setupLogs(Logger.INFO);
        }
        try {
            InputStream in = System.in;
            if (args.length != 0) {
                in = new FileInputStream(new File(args[0]));
            }
            System.err.print("Parsing...");
            ILParser parser = new ILParser(new InputStreamReader(in), true);
            Spec spec = parser.getSpec();
            System.err.println("done");
            System.err.println("Unparsing into s-expressions");
            SValue v = spec.toSValue();
            PrintWriter pw = new PrintWriter(System.out);
            iprinter ip = new iprinter(pw);
            v.print(ip);
            ip.flush();
            System.err.println("done");
        }
        catch (ILParseException e) {
            e.printStackTrace();
            Throwable f = e.getPiggyback();
            if (f != null) {
                System.err.println("piggyback: ");
                f.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

