/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Comm;
import mpi.Datatype;
import mpi.MPI;
import mpi.MPIException;
import mpi.Status;

public class Request {
    protected static final int NULL = 0;
    protected static final int TYPE_NORMAL = 0;
    protected static final int TYPE_OBJECT = 1;
    protected static final int OP_SEND = 0;
    protected static final int OP_RECV = 1;
    protected Request hdrReq;
    protected int typeTag = 0;
    protected int opTag;
    protected int mode;
    protected Object buf;
    protected int offset;
    protected int count;
    protected Datatype type;
    protected int dest;
    protected int tag;
    protected Comm comm;
    protected int[] length_buf;
    protected long handle;
    protected Object bufSave;
    protected int countSave;
    protected int offsetSave;
    protected long bufbaseSave;
    protected long bufptrSave;
    protected int baseTypeSave;
    protected long commSave;
    protected long typeSave;

    private static native void init();

    private native void GetReq(int var1);

    protected Request() {
    }

    protected Request(int n) {
        this.GetReq(n);
    }

    protected Request(Request request) {
        this.typeTag = 1;
        this.opTag = 0;
        this.hdrReq = request;
    }

    protected Request(Object object, int n, int n2, Datatype datatype, int n3, Comm comm, int[] nArray) {
        this.typeTag = 1;
        this.opTag = 1;
        this.buf = object;
        this.offset = n;
        this.count = n2;
        this.type = datatype;
        this.tag = n3;
        this.comm = comm;
        this.length_buf = nArray;
    }

    public native void Free() throws MPIException;

    public native void Cancel() throws MPIException;

    public native boolean Is_null();

    private Status complete(Status status) throws MPIException {
        block0 : switch (this.typeTag) {
            case 0: {
                break;
            }
            case 1: {
                switch (this.opTag) {
                    case 0: {
                        this.hdrReq.Wait(new Status());
                        break block0;
                    }
                    case 1: {
                        int n = status.index;
                        byte[] byArray = new byte[this.length_buf[0]];
                        status = this.comm.Recv(byArray, 0, this.length_buf[0], MPI.BYTE, status.source, this.tag);
                        this.comm.Object_Deserialize(this.buf, byArray, this.offset, this.length_buf[1], this.type);
                        status.object_count = this.length_buf[1];
                        status.index = n;
                    }
                }
            }
        }
        return status;
    }

    public Status Wait() throws MPIException {
        Status status = new Status();
        this.Wait(status);
        return this.complete(status);
    }

    private native Status Wait(Status var1);

    public Status Test() throws MPIException {
        Status status = new Status();
        if (this.Test(status) == null) {
            return null;
        }
        return this.complete(status);
    }

    private native Status Test(Status var1);

    public static Status Waitany(Request[] requestArray) throws MPIException {
        Status status = new Status();
        Request.Waitany(requestArray, status);
        if (status == null) {
            return null;
        }
        return requestArray[status.index].complete(status);
    }

    private static native Status Waitany(Request[] var0, Status var1);

    public static Status Testany(Request[] requestArray) throws MPIException {
        Status status = new Status();
        if ((status = Request.Testany(requestArray, status)) == null) {
            return null;
        }
        return requestArray[status.index].complete(status);
    }

    private static native Status Testany(Request[] var0, Status var1);

    public static Status[] Waitall(Request[] requestArray) throws MPIException {
        Status[] statusArray = Request.waitall(requestArray);
        for (int i = 0; i < requestArray.length; ++i) {
            statusArray[i] = requestArray[i].complete(statusArray[i]);
        }
        return statusArray;
    }

    private static native Status[] waitall(Request[] var0);

    public static Status[] Testall(Request[] requestArray) throws MPIException {
        Status[] statusArray = Request.testall(requestArray);
        if (statusArray == null) {
            return null;
        }
        for (int i = 0; i < requestArray.length; ++i) {
            statusArray[i] = requestArray[i].complete(statusArray[i]);
        }
        return statusArray;
    }

    private static native Status[] testall(Request[] var0);

    public static Status[] Waitsome(Request[] requestArray) throws MPIException {
        Status[] statusArray = Request.waitsome(requestArray);
        for (int i = 0; i < statusArray.length; ++i) {
            statusArray[i] = requestArray[statusArray[i].index].complete(statusArray[i]);
        }
        return statusArray;
    }

    private static native Status[] waitsome(Request[] var0);

    public static Status[] Testsome(Request[] requestArray) throws MPIException {
        Status[] statusArray = Request.testsome(requestArray);
        if (statusArray == null) {
            return null;
        }
        for (int i = 0; i < statusArray.length; ++i) {
            statusArray[i] = requestArray[statusArray[i].index].complete(statusArray[i]);
        }
        return statusArray;
    }

    private static native Status[] testsome(Request[] var0);

    static {
        Request.init();
    }
}

