/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util.sexp;

import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SNumber;
import com.veromodo.tioa.util.sexp.SParseException;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SParser {
    public SValue parse(String s) throws SParseException {
        return this.parse(new StringReader(s));
    }

    public SValue parse(Reader r) throws SParseException {
        List<SToken> l = this.parseToList(r);
        SList sl = this.parseNumbers(this.listToSList(l));
        if (sl.size() == 0) {
            throw new SParseException("Tried to parse empty item");
        }
        return (SValue)sl.get(0);
    }

    private List<SToken> parseToList(Reader reader) throws SParseException {
        STokenizer tk = new STokenizer(reader);
        Stack<LinkedList<SToken>> stack = new Stack<LinkedList<SToken>>();
        LinkedList retval = new LinkedList<SToken>();
        try {
            while (tk.hasNext()) {
                SToken s = tk.next();
                if (s.type == 0) {
                    stack.push(retval);
                    retval = new LinkedList();
                    continue;
                }
                if (s.type == 1) {
                    LinkedList<SToken> temp = retval;
                    if (stack.empty()) {
                        throw new SParseException("Unmatched closing paren");
                    }
                    retval = (LinkedList)stack.pop();
                    retval.add(temp);
                    continue;
                }
                retval.add((SToken)s);
            }
        }
        catch (IOException e) {
            throw new SParseException(e.toString());
        }
        if (!stack.empty()) {
            throw new SParseException("Unmatched open paren");
        }
        return retval;
    }

    private SList parseNumbers(SList arg) {
        Iterator i = arg.iterator();
        SList retval = new SList();
        while (i.hasNext()) {
            SValue v = (SValue)i.next();
            if (v instanceof SString) {
                try {
                    v = new SNumber(v.toString());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (v instanceof SList) {
                v = this.parseNumbers((SList)v);
            }
            retval.add(v);
        }
        return retval;
    }

    private SList listToSList(List<SToken> input) {
        ListIterator<SToken> i = input.listIterator();
        SList retval = new SList();
        while (i.hasNext()) {
            SToken o = i.next();
            SValue current = new SList();
            if (o instanceof SToken) {
                SToken tok = o;
                if (tok.type == 5) {
                    current = new SString(tok.sval);
                    retval.add(current);
                    continue;
                }
                if (tok.type != 6) continue;
                current = new SString(tok.sval);
                retval.add(current);
                continue;
            }
            if (!(o instanceof List)) continue;
            current = this.listToSList((List)((Object)o));
            retval.add(current);
        }
        return retval;
    }

    class SToken {
        public static final int INVALID = -1;
        public static final int OPEN_PAREN = 0;
        public static final int CLOSE_PAREN = 1;
        public static final int SYMBOL = 5;
        public static final int STRING = 6;
        public int type;
        public String sval;

        public String toString() {
            if (this.type == 5) {
                return this.sval;
            }
            if (this.type == 0) {
                return "(";
            }
            if (this.type == 1) {
                return ")";
            }
            if (this.type == 6) {
                return "\"" + this.sval + "\"";
            }
            return "null";
        }
    }

    class STokenizer {
        StreamTokenizer tk;

        public STokenizer(Reader r) {
            this.tk = new StreamTokenizer(r);
            this.tk.resetSyntax();
            this.tk.wordChars(0, 255);
            this.tk.ordinaryChar(40);
            this.tk.ordinaryChar(41);
            this.tk.whitespaceChars(32, 32);
            this.tk.whitespaceChars(13, 13);
            this.tk.whitespaceChars(10, 10);
            this.tk.whitespaceChars(9, 9);
            this.tk.quoteChar(34);
            this.tk.lowerCaseMode(false);
        }

        public boolean hasNext() {
            return this.tk.ttype != -1;
        }

        public SToken next() throws IOException {
            SToken current = new SToken();
            this.tk.nextToken();
            current.type = -1;
            current.sval = this.tk.sval;
            if (this.tk.ttype == -3) {
                current.type = 5;
            } else if (this.tk.ttype > 0 && this.tk.sval != null) {
                current.type = 6;
            } else if (this.tk.ttype == 40) {
                current.type = 0;
            } else if (this.tk.ttype == 41) {
                current.type = 1;
            } else if (this.tk.ttype == -1) {
                current.type = -1;
            }
            return current;
        }
    }
}

