/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util.sexp;

import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SValue;
import com.veromodo.tioa.util.sexp.SWriter;
import java.io.IOException;
import java.math.BigDecimal;

public class SNumber
extends SValue {
    private BigDecimal value;

    public SNumber(String numberString) {
        try {
            this.value = new BigDecimal(numberString);
        }
        catch (Exception e) {
            throw new NumberFormatException(numberString);
        }
    }

    public SNumber(Float f) {
        this.value = new BigDecimal(f.toString());
    }

    public SNumber(float f) {
        this.value = new BigDecimal(String.valueOf(f));
    }

    public boolean equals(Object o) {
        if (o instanceof SNumber) {
            return this.equals((SNumber)o);
        }
        return false;
    }

    public boolean equals(SNumber n) {
        return this.value.equals(n.value);
    }

    public int intValue() {
        return this.value.intValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public Float toFloat() {
        return new Float(this.floatValue());
    }

    public String toString() {
        return this.value.toString();
    }

    public void write(SWriter w) throws IOException {
        w.write(this.toString());
    }

    public iprinter print(iprinter ip) {
        return ip.put(this.toString());
    }

    public int hashCode() {
        return this.value.hashCode() ^ 0x4EDA;
    }
}

