/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util.sexp;

import com.veromodo.tioa.util.iprinter;
import com.veromodo.tioa.util.sexp.SNumber;
import com.veromodo.tioa.util.sexp.SPrintable;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import com.veromodo.tioa.util.sexp.SValueException;
import com.veromodo.tioa.util.sexp.SWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SList
extends SValue
implements List {
    private List data;
    protected static HashSet carsToAlign = null;
    protected static HashSet caarsToAlign = null;

    public SList() {
        this.data = new ArrayList();
    }

    public SList(SList l) {
        this.data = new ArrayList(l.data);
    }

    public SList(List l) {
        this.data = new ArrayList();
        for (Object o : l) {
            if (o instanceof SValue) {
                this.data.add(o);
                continue;
            }
            this.data.add(((SPrintable)o).toSValue());
        }
    }

    public SList(Collection c) {
        this();
        this.addAll(c);
    }

    public SList(SValue[] arg) {
        this(Arrays.asList(arg));
    }

    public void add(int index, Object o) {
        this.data.add(index, (SValue)o);
    }

    public boolean add(Object o) {
        return this.data.add((SValue)o);
    }

    public boolean addAll(Collection c) {
        for (SValue sValue : c) {
        }
        return this.data.addAll(c);
    }

    public boolean addAll(int position, Collection c) {
        for (SValue sValue : c) {
        }
        return this.data.addAll(position, c);
    }

    public void addFirst(Object o) {
        this.data.add(0, (SValue)o);
    }

    public void addLast(Object o) {
        this.data.add(this.data.size(), (SValue)o);
    }

    public void clear() {
        this.data.clear();
    }

    public Object clone() {
        return new SList(this);
    }

    public Collection toCollection() {
        return Collections.unmodifiableCollection(this.data);
    }

    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.data.containsAll(c);
    }

    public Object get(int index) {
        return this.data.get(index);
    }

    public SValue getSValue(int index) {
        return (SValue)this.get(index);
    }

    public String getString(int index) throws SValueException {
        Object o = this.get(index);
        if (!(o instanceof SString)) {
            throw new SValueException("SString", o.getClass().toString(), this);
        }
        SString s = (SString)o;
        return s.toString();
    }

    public SString getSString(int index) throws SValueException {
        Object o = this.get(index);
        if (!(o instanceof SString)) {
            throw new SValueException("SString", o.getClass().toString(), this);
        }
        SString s = (SString)o;
        return s;
    }

    public float getNumber(int index) throws SValueException {
        Object o = this.get(index);
        if (!(o instanceof SNumber)) {
            throw new SValueException("SNumber", o.getClass().toString(), this);
        }
        SNumber s = (SNumber)o;
        return s.floatValue();
    }

    public int getInt(int index) throws SValueException {
        Object o = this.get(index);
        if (!(o instanceof SNumber)) {
            throw new SValueException("SNumber", o.getClass().toString(), this);
        }
        SNumber s = (SNumber)o;
        return (int)s.floatValue();
    }

    public SNumber getSNumber(int index) throws SValueException {
        Object o = this.get(index);
        if (!(o instanceof SNumber)) {
            throw new SValueException("SNumber", o.getClass().toString(), this);
        }
        SNumber s = (SNumber)o;
        return s;
    }

    public SList getSList(int index) throws SValueException {
        Object o = this.get(index);
        if (!(o instanceof SList)) {
            throw new SValueException("SList", o.getClass().toString(), this);
        }
        return (SList)o;
    }

    public Object getFirst() {
        return this.data.get(0);
    }

    public Object getLast() {
        return this.data.get(this.data.size() - 1);
    }

    public int indexOf(Object o) {
        return this.data.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.data.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.data.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.data.listIterator(index);
    }

    public Object remove(int index) {
        return this.data.remove(index);
    }

    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.data.removeAll(c);
    }

    public Object removeFirst() {
        return this.data.remove(0);
    }

    public Object removeLast() {
        return this.data.remove(this.data.size() - 1);
    }

    public boolean retainAll(Collection c) {
        return this.data.retainAll(c);
    }

    public Object set(int index, Object o) {
        return this.data.set(index, (SValue)o);
    }

    public boolean equals(Object o) {
        if (o instanceof SList) {
            SList s = (SList)o;
            return this.data.equals(s.data);
        }
        return false;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Iterator iterator() {
        return this.data.iterator();
    }

    public List subList(int a, int b) {
        return new SList(this.data.subList(a, b));
    }

    public SList rest(int a) {
        return (SList)this.subList(a, this.size());
    }

    public Object[] toArray() {
        return this.data.toArray();
    }

    public Object[] toArray(Object[] arg) {
        return this.data.toArray(arg);
    }

    public void write(SWriter w) throws IOException {
        Iterator i = this.iterator();
        w.write("(");
        while (i.hasNext()) {
            SValue v = (SValue)i.next();
            if (v == null) continue;
            v.write(w);
            if (!i.hasNext()) continue;
            w.write(" ");
        }
        w.write(")");
    }

    public iprinter print(iprinter ip) {
        if (this.shouldAlign()) {
            ip.align();
        } else {
            ip.fill();
        }
        for (SValue v : this) {
            ip.print(v);
        }
        ip.end();
        return ip;
    }

    protected boolean shouldAlign() {
        Object car2;
        try {
            if (carsToAlign == null) {
                carsToAlign = new HashSet();
                carsToAlign.add("vars");
                carsToAlign.add("sorts");
                carsToAlign.add("actions");
                carsToAlign.add("states");
                carsToAlign.add("ops");
            }
            if (this.size() < 1) {
                return false;
            }
            car2 = this.getString(0);
            if (carsToAlign.contains(car2)) {
                return true;
            }
        }
        catch (SValueException car2) {
            // empty catch block
        }
        try {
            if (caarsToAlign == null) {
                caarsToAlign = new HashSet();
                caarsToAlign.add("assign");
            }
            if (this.size() < 1) {
                return false;
            }
            car2 = this.getSList(0);
            if (((SList)car2).size() < 1) {
                return false;
            }
            String caar = ((SList)car2).getString(0);
            if (caarsToAlign.contains(caar)) {
                return true;
            }
        }
        catch (SValueException sValueException) {
            // empty catch block
        }
        return false;
    }

    public SValue replace(SValue pattern, SValue replacement2) {
        if (this.equals(pattern)) {
            return replacement2;
        }
        SList result = new SList();
        for (SValue sexp : this) {
            result.add(sexp.replace(pattern, replacement2));
        }
        return result;
    }
}

