/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util.sexp;

import com.veromodo.tioa.util.sexp.SExpAccumulator;
import com.veromodo.tioa.util.sexp.SList;
import com.veromodo.tioa.util.sexp.SNumber;
import com.veromodo.tioa.util.sexp.SParser;
import com.veromodo.tioa.util.sexp.SString;
import com.veromodo.tioa.util.sexp.SValue;
import com.veromodo.tioa.util.sexp.SValueException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public class SExp {
    private SExp() {
        throw new RuntimeException("Instantiation not supported");
    }

    public static SValue makeSValue(double arg) {
        return new SNumber((float)arg);
    }

    public static SValue makeSValue(float arg) {
        return new SNumber(arg);
    }

    public static SValue makeSValue(int arg) {
        return new SNumber(arg);
    }

    public static SValue makeSValue(boolean arg) {
        return new SString("" + arg);
    }

    public static SValue makeSValue(String arg) {
        return new SString(arg);
    }

    public static SList makeSList(SValue arg1) {
        return new SList(new SValue[]{arg1});
    }

    public static SList makeSList(SValue arg1, SValue arg2) {
        return new SList(new SValue[]{arg1, arg2});
    }

    public static SList makeSList(SValue arg1, SValue arg2, SValue arg3) {
        return new SList(new SValue[]{arg1, arg2, arg3});
    }

    public static SList makeSList(SValue arg1, SValue arg2, SValue arg3, SValue arg4) {
        return new SList(new SValue[]{arg1, arg2, arg3, arg4});
    }

    public static SList makeSList(SValue arg1, SValue arg2, SValue arg3, SValue arg4, SValue arg5) {
        return new SList(new SValue[]{arg1, arg2, arg3, arg4, arg5});
    }

    public static String getString(Object arg) throws SValueException {
        if (!(arg instanceof SString)) {
            throw new SValueException("getString requires an SString");
        }
        return ((SString)arg).toString();
    }

    public static float getNumber(Object arg) throws SValueException {
        if (!(arg instanceof SNumber)) {
            throw new SValueException("getNumber requires an SNumber");
        }
        return ((SNumber)arg).floatValue();
    }

    public static SString getSString(Object arg) throws SValueException {
        if (!(arg instanceof SString)) {
            throw new SValueException("getSString requires an SString");
        }
        return (SString)arg;
    }

    public static SNumber getSNumber(Object arg) throws SValueException {
        if (!(arg instanceof SNumber)) {
            throw new SValueException("getSNumber requires an SNumber");
        }
        return (SNumber)arg;
    }

    public static SList getSList(Object arg) throws SValueException {
        if (!(arg instanceof SList)) {
            throw new SValueException("getSList requires an SList");
        }
        return (SList)arg;
    }

    public static Vector toVector(SList l) {
        VectorAccumulator va = VectorAccumulator.getInstance();
        return (Vector)SExp.accumulateLeftToRight(l, va);
    }

    public static Object accumulateLeftToRight(SList l, SExpAccumulator acc) {
        Iterator i = l.iterator();
        Object retval = acc.start();
        while (i.hasNext()) {
            retval = acc.accumulate((SValue)i.next(), retval);
        }
        return retval;
    }

    public static Object accumulateRightToLeft(SList l, SExpAccumulator acc) {
        ListIterator i = l.listIterator(l.size());
        Object retval = acc.start();
        while (i.hasPrevious()) {
            retval = acc.accumulate((SValue)i.previous(), retval);
        }
        return retval;
    }

    public static void main(String[] args) {
        String testexp = args[0];
        System.out.println(testexp);
        SParser parser2 = new SParser();
        try {
            SValue v = parser2.parse(testexp);
            System.out.println(v.unparse());
        }
        catch (Exception e) {
            throw new RuntimeException("Write failed");
        }
    }

    private static class VectorAccumulator
    implements SExpAccumulator {
        private static final VectorAccumulator theInstance = new VectorAccumulator();

        VectorAccumulator() {
        }

        public static VectorAccumulator getInstance() {
            return theInstance;
        }

        public Object start() {
            return new Vector();
        }

        public Object accumulate(SValue current, Object doneSoFar) {
            Vector done = (Vector)doneSoFar;
            if (current instanceof SList) {
                done.add(SExp.toVector((SList)current));
                return done;
            }
            if (current instanceof SString) {
                done.add(current.toString());
                return done;
            }
            if (current instanceof SNumber) {
                done.add(new Integer((int)((SNumber)current).floatValue()));
                return done;
            }
            throw new RuntimeException("To Vector was given a bad SValue " + current.toString());
        }
    }
}

