/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util;

import com.veromodo.tioa.util.Iprintable;
import com.veromodo.tioa.util.IprintableVector;
import com.veromodo.tioa.util.prettyprinter;
import java.io.PrintWriter;

public class iprinter {
    private prettyprinter pp;
    private int[] lengths = new int[100];
    private int height = 0;

    public iprinter(int lineWidth) {
        this.pp = new prettyprinter(lineWidth);
        this.pp.fill(0);
    }

    public iprinter(PrintWriter S) {
        this.pp = new prettyprinter(S);
        this.pp.fill(0);
    }

    public static iprinter stdout() {
        return new iprinter(new PrintWriter(System.out));
    }

    public static iprinter stderr() {
        return new iprinter(new PrintWriter(System.out));
    }

    public iprinter align() {
        int n = this.height;
        int n2 = this.lengths[n];
        this.lengths[n] = n2 + 1;
        if (n2 > 0) {
            this.pp.blank();
        }
        this.push();
        this.pp.align(1).put("(");
        return this;
    }

    public iprinter fill() {
        int n = this.height;
        int n2 = this.lengths[n];
        this.lengths[n] = n2 + 1;
        if (n2 > 0) {
            this.pp.blank();
        }
        this.push();
        this.pp.fill(1).put("(");
        return this;
    }

    public iprinter put(String s) {
        int n = this.height;
        int n2 = this.lengths[n];
        this.lengths[n] = n2 + 1;
        if (n2 > 0) {
            this.pp.blank();
        }
        this.pp.put(s);
        return this;
    }

    public iprinter quote(String s) {
        int n = this.height;
        int n2 = this.lengths[n];
        this.lengths[n] = n2 + 1;
        if (n2 > 0) {
            this.pp.blank();
        }
        this.pp.put("\"" + s + "\"");
        return this;
    }

    public iprinter put(int i) {
        return this.put("" + i);
    }

    public iprinter put(boolean b) {
        return this.put(b ? "true" : "false");
    }

    public iprinter print(Iprintable x) {
        if (x != null) {
            x.print(this);
        }
        return this;
    }

    public iprinter list(String keyword, Iprintable[] v) {
        if (v == null || v.length == 0) {
            return this.fill().end();
        }
        this.align();
        if (keyword.length() > 0) {
            this.put(keyword);
        }
        int i = 0;
        while (i < v.length) {
            this.print(v[i]);
            ++i;
        }
        return this.end();
    }

    public iprinter list(String keyword, IprintableVector v) {
        if (v == null || v.size() == 0) {
            return this;
        }
        this.align();
        if (keyword.length() > 0) {
            this.put(keyword);
        }
        return v.list(this).end();
    }

    public iprinter plist(String keyword, IprintableVector v) {
        if (v == null || v.size() == 0) {
            return this.fill().end();
        }
        this.align();
        if (keyword.length() > 0) {
            this.put(keyword);
        }
        return v.list(this).end();
    }

    public iprinter klist(String keyword, IprintableVector v) {
        if (v == null || v.size() == 0) {
            if (keyword.length() > 0) {
                return this.fill().put(keyword).end();
            }
            return this.fill().end();
        }
        this.align();
        if (keyword.length() > 0) {
            this.put(keyword);
        }
        return v.list(this).end();
    }

    public iprinter klist(String keyword, Iprintable[] v) {
        if (v == null || v.length == 0) {
            if (keyword.length() > 0) {
                return this.fill().put(keyword).end();
            }
            return this.fill().end();
        }
        this.align();
        if (keyword.length() > 0) {
            this.put(keyword);
        }
        int i = 0;
        while (i < v.length) {
            this.print(v[i]);
            ++i;
        }
        return this.end();
    }

    public iprinter list(Iprintable[] v) {
        if (v == null || v.length == 0) {
            return this.fill().end();
        }
        this.align();
        int i = 0;
        while (i < v.length) {
            this.print(v[i]);
            ++i;
        }
        return this.end();
    }

    public iprinter listWithoutWrapping(Iprintable[] v) {
        if (v == null) {
            return this;
        }
        int i = 0;
        while (i < v.length) {
            this.print(v[i]);
            ++i;
        }
        return this;
    }

    public iprinter maybe(String keyword, Iprintable x) {
        if (x == null) {
            return this;
        }
        this.fill();
        if (keyword != null && keyword.length() > 0) {
            this.put(keyword);
        }
        return this.print(x).end();
    }

    public iprinter end() {
        this.pp.put(")").end();
        this.pop();
        int n = this.height;
        this.lengths[n] = this.lengths[n] + 1;
        return this;
    }

    public iprinter flush() {
        if (this.height > 0) {
            throw new InternalError("iprinter.flush: missing )");
        }
        this.pp.eol().end().eof().fill(0);
        this.lengths[0] = 0;
        return this;
    }

    private void push() {
        int size = this.lengths.length;
        if (size <= this.height + 1) {
            int[] old = this.lengths;
            this.lengths = new int[size + 100];
            System.arraycopy(old, 0, this.lengths, 0, this.height);
        }
        this.lengths[++this.height] = 0;
    }

    private void pop() {
        if (this.height-- <= 0) {
            throw new InternalError("iprinter.pop: extra )");
        }
    }

    public static void main(String[] args) {
        iprinter ip = new iprinter(new PrintWriter(System.out));
        ip.align();
        int i = 0;
        while (i < 10) {
            ip.put("there today");
            ++i;
        }
        ip.end().flush();
        ip.fill();
        i = 0;
        while (i < 50) {
            ip.put("hi");
            ++i;
        }
        ip.end().flush();
    }
}

