/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsUtils<T> {
    public static <T> String makeString(Enumeration<T> e) {
        if (e == null) {
            return "null";
        }
        if (!e.hasMoreElements()) {
            return "no elements";
        }
        StringBuffer sb = new StringBuffer("[");
        while (e.hasMoreElements()) {
            sb.append(e.nextElement()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
        return sb.toString();
    }

    public static <T> Enumeration<T> iterToEnum(final Iterator<T> it) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public T nextElement() {
                return it.next();
            }
        };
    }

    public static <T> Iterator<T> enumToIter(final Enumeration<T> e) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public T next() {
                return e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static List<String> stringToList(String s, String delimiters) {
        Vector<String> retval = new Vector<String>();
        StringTokenizer tokenizer2 = new StringTokenizer(s, delimiters);
        while (tokenizer2.hasMoreTokens()) {
            retval.add(tokenizer2.nextToken());
        }
        return retval;
    }

    public static <T> List<T> enumerationToList(Enumeration<T> e) {
        LinkedList<T> list = new LinkedList<T>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    public static <T> Enumeration<T> sort(Enumeration<T> e, Comparator comparator) {
        List<T> list = CollectionsUtils.enumerationToList(e);
        Collections.sort(list, comparator);
        return Collections.enumeration(list);
    }

    public static <T extends Comparable> Enumeration<T> sort(Enumeration<T> e) {
        List<T> list = CollectionsUtils.enumerationToList(e);
        Collections.sort(list);
        return Collections.enumeration(list);
    }

    public static String listToString(List<String> l, String delimiter) {
        Iterator<String> i = l.iterator();
        String retval = "";
        while (i.hasNext()) {
            retval = String.valueOf(retval) + i.next().toString() + delimiter;
        }
        return retval.trim();
    }
}

