/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.util;

public class ArrayUtil {
    public static Object[] join(Object[] a, Object e) {
        Object[] result = new Object[a.length + 1];
        System.arraycopy(a, 0, result, 0, a.length);
        result[a.length] = e;
        return result;
    }

    public static Object[] join(Object e, Object[] a) {
        Object[] result = new Object[a.length + 1];
        result[0] = e;
        System.arraycopy(a, 0, result, 1, a.length);
        return result;
    }

    public static Object[] insert(Object[] a, int n, Object[] b) {
        if (n < 0 || n >= a.length) {
            throw new InternalError("ArrayUtil.insert");
        }
        Object[] result = new Object[a.length + b.length - 1];
        if (n > 0) {
            System.arraycopy(a, 0, result, 0, n - 1);
        }
        System.arraycopy(b, 0, result, n, b.length);
        if (n < a.length - 1) {
            System.arraycopy(a, n + 1, result, n + b.length, a.length - n);
        }
        return result;
    }

    public static boolean equals(Object[] a, Object[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean noDuplicates(Object[] a) {
        int n = 0;
        while (n < a.length) {
            int i = 0;
            while (i < n) {
                if (a[i].equals(a[n])) {
                    return false;
                }
                ++i;
            }
            ++n;
        }
        return true;
    }

    public static String makeString(Object[] arr) {
        if (arr == null) {
            return "null array";
        }
        if (arr.length == 0) {
            return "array of length zero";
        }
        if (arr.length == 1) {
            return "[" + arr[0] + "]";
        }
        StringBuffer sb = new StringBuffer("[");
        int i = 0;
        while (i < arr.length - 1) {
            sb.append(arr[i]).append(", ");
            ++i;
        }
        sb.append(arr[arr.length - 1]).append("]");
        return sb.toString();
    }

    public static String makeArgString(Object[] arr) {
        if (arr == null) {
            return "null";
        }
        if (arr.length == 0) {
            return "()";
        }
        if (arr.length == 1) {
            return "(" + arr[0] + ")";
        }
        StringBuffer sb = new StringBuffer("(");
        int i = 0;
        while (i < arr.length - 1) {
            sb.append(arr[i]).append(", ");
            ++i;
        }
        sb.append(arr[arr.length - 1]).append(")");
        return sb.toString();
    }
}

