/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.formal;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortConstructor;
import com.veromodo.tioa.notions.sortEnum;
import com.veromodo.tioa.notions.sortTuple;
import com.veromodo.tioa.notions.sortUnion;
import com.veromodo.tioa.notions.vocabRef;
import com.veromodo.tioa.notions.vocabulary;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.Abstractify;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.formalListNode;
import com.veromodo.tioa.parser.formalNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.operatorNode;
import com.veromodo.tioa.parser.shorthandNode;
import com.veromodo.tioa.parser.sortConstructorNode;
import com.veromodo.tioa.parser.sortDclNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.unitNode;
import com.veromodo.tioa.parser.vocabRefNode;
import com.veromodo.tioa.util.factoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class vocabNode
extends Node {
    private ltoken vocabId;
    private formalNode[] formals = new formalNode[0];
    private sortNode defines;
    private vocabRefNode[] imports = new vocabRefNode[0];
    private sortDclNode[] sorts = new sortDclNode[0];
    private operatorNode[] operators = new operatorNode[0];
    private vocabulary theVocab;

    public ltoken name() {
        return this.vocabId;
    }

    public int nFormals() {
        return this.formals.length;
    }

    public formalNode formal(int n) {
        return this.formals[n];
    }

    public sortNode defines() {
        return this.defines;
    }

    public int nImports() {
        return this.imports.length;
    }

    public vocabRefNode imports(int n) {
        return this.imports[n];
    }

    public int nSorts() {
        return this.sorts.length;
    }

    public sortDclNode sort(int n) {
        return this.sorts[n];
    }

    public int nOperators() {
        return this.operators.length;
    }

    public operatorNode operator(int n) {
        return this.operators[n];
    }

    public vocabulary makeAbstract() {
        if (this.theVocab == null) {
            String templateName = null;
            sort[] templateSorts = null;
            if (this.defines != null) {
                templateName = this.defines.constructor().id().toString();
                templateSorts = new sort[this.defines.nSubsorts()];
                int i = 0;
                while (i < this.defines.nSubsorts()) {
                    templateSorts[i] = this.defines.subsort(i).makeAbstract();
                    ++i;
                }
            }
            sort[] sortDcls = new sort[this.sorts.length];
            int i = 0;
            while (i < this.sorts.length) {
                if (this.sorts[i].theShorthand() == null) {
                    sortDcls[i] = this.sorts[i].theSortNode().makeAbstract();
                } else {
                    Unit u = this.sorts[i].theShorthand().makeAbstract();
                    switch (this.sorts[i].theShorthand().kind()) {
                        case 0: {
                            sortDcls[i] = (sortEnum)u;
                            break;
                        }
                        case 1: {
                            sortDcls[i] = (sortTuple)u;
                            break;
                        }
                        case 2: {
                            sortDcls[i] = (sortUnion)u;
                            break;
                        }
                        default: {
                            throw new InternalError("vocabNode.makeAbstract");
                        }
                    }
                }
                ++i;
            }
            this.theVocab = new vocabulary(this.vocabId.toString(), (formal[])Abstractify.map((Abstractifiable[])this.formals, (Object[])new formal[this.formals.length]), templateName, templateSorts, (vocabRef[])Abstractify.map((Abstractifiable[])this.imports, (Object[])new vocabRef[this.imports.length]), sortDcls, (operator[])Abstractify.map((Abstractifiable[])this.operators, (Object[])new operator[this.operators.length]), new factoring(this.operators));
            sortConstructor con = this.theVocab.theConstructor();
            if (con != null) {
                this.defines = this.defines.changeConstructor(new sortConstructorNode(con, this.defines.scope()));
            }
        }
        return this.theVocab;
    }

    public vocabNode() {
    }

    public vocabNode(ltoken name) {
        this.vocabId = name;
    }

    public vocabNode all(ltoken k, ltoken i, formalListNode f, vocabNode v) {
        this.locs(k, i);
        this.loc2(f);
        this.loc2(v);
        this.vocabId = i;
        this.formals = f == null ? new formalNode[]{} : (formalNode[])f.toArray(new formalNode[f.size()]);
        this.defines = v.defines;
        this.imports = v.imports;
        this.sorts = v.sorts;
        this.operators = v.operators;
        return this;
    }

    public vocabNode set(sortNode s, vocabNode v) {
        if (s != null) {
            this.locs(s, v);
            this.defines = s;
        } else {
            this.locs(v);
        }
        this.imports = v.imports;
        this.sorts = v.sorts;
        this.operators = v.operators;
        return this;
    }

    public vocabNode imp(vocabNode i, vocabNode v) {
        this.locs(i, v);
        if (i != null) {
            this.imports = i.imports;
        }
        this.sorts = v.sorts;
        this.operators = v.operators;
        return this;
    }

    public vocabNode imp(ltoken t, ListNode<vocabRefNode> v) {
        this.locs(t, v);
        this.imports = (vocabRefNode[])v.toArray(new vocabRefNode[v.size()]);
        return this;
    }

    public vocabNode srt(ListNode<sortDclNode> s, vocabNode v) {
        this.locs(s, v);
        if (s != null) {
            this.sorts = (sortDclNode[])s.toArray(new sortDclNode[s.size()]);
        }
        if (v != null) {
            this.operators = v.operators;
        }
        return this;
    }

    public vocabNode ops(ListNode<operatorNode> o) {
        this.locs(o);
        this.operators = (operatorNode[])o.toArray(new operatorNode[o.size()]);
        return this;
    }

    public void setScope() {
        Scope s = Scope.root().makeSubscope("vocab " + this.vocabId);
        super.setScope(s);
        this.vocabId.setScope(s);
        if (this.defines != null) {
            this.defines.setScope(s);
        }
        int n = 0;
        while (n < this.formals.length) {
            this.formals[n].setScope(s);
            ++n;
        }
        n = 0;
        while (n < this.imports.length) {
            this.imports[n].setScope(s);
            ++n;
        }
        n = 0;
        while (n < this.sorts.length) {
            this.sorts[n].setScope(s);
            ++n;
        }
        n = 0;
        while (n < this.operators.length) {
            this.operators[n].setScope(s);
            ++n;
        }
    }

    public static void defineSortTuple(sortTuple st) {
        vocabNode vNode = new vocabNode();
        ListNode<sortDclNode> dNode = new ListNode<sortDclNode>();
        dNode.add(new sortDclNode(new sortNode(st.sort(), null), new shorthandNode(st)));
        vNode.srt(dNode, null);
        unitNode uNode = new unitNode();
        uNode.tag(vNode);
    }
}

