/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.checker.Declarable;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.variable;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.FactorNode;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.util.Factorable;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.prettyprinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class variableNode
extends FactorNode
implements Prettyprintable,
Comparable<variableNode>,
Declarable<String>,
Abstractifiable<variable>,
Factorable {
    private ltoken id;
    private sortNode sort;
    private int kind = -1;
    private variableNode declaration;
    private variable theVariable;

    public ltoken id() {
        return this.id;
    }

    public sortNode sort() {
        return this.sort;
    }

    public int kind() {
        return this.kind;
    }

    public void setKind(int k) {
        if (this.kind >= 0) {
            throw new InternalError("variableNode.setKind");
        }
        this.kind = k;
    }

    public variableNode declaration() {
        return this.declaration;
    }

    public boolean isDeclaration() {
        return this == this.declaration;
    }

    @Override
    public variable makeAbstract() {
        return this.theVariable;
    }

    public variableNode() {
    }

    public variableNode(ltoken t) {
        this.id = t;
        this.locs(this.id);
    }

    public variableNode(ltoken t, sortNode sn) {
        this.set(t, sn);
        this.locs(t, sn);
        this.setScope(t.scope());
        if (sn.restricted()) {
            throw new InternalError("variableNode.variableNode");
        }
    }

    public variableNode(String s, sortNode sn, Scope sc) {
        this(new ltoken(s, sc), sn);
        this.setScope(sc);
        if (sn.restricted()) {
            throw new InternalError("variableNode.variableNode");
        }
    }

    public variableNode(variable v, Scope sc) {
        this(new ltoken(v.id(), sc), new sortNode(v.sort(), sc));
        this.theVariable = v;
    }

    public variableNode(variableNode v) {
        this(v.id, v.sort);
    }

    public void set(ltoken t) {
        this.id = t;
        this.locs(this.id);
    }

    public void set(ltoken t, sortNode sn) {
        this.id = t;
        this.sort = sn;
        this.locs(t, sn);
    }

    public void copy(variableNode vn) {
        this.locs(vn);
        this.id = vn.id;
        this.sort = vn.sort;
    }

    @Override
    public void setScope(Scope s) {
        super.setScope(s);
        this.id.setScope(s);
        if (this.sort != null) {
            this.sort.setScope(s);
        }
    }

    public static variableNode extract(ListNode<ltoken> list, int n) {
        if (n < 0 || list.size() <= n) {
            throw new InternalError("variableNode.extract");
        }
        return new variableNode(list.elementAt(n), (sortNode)list.info());
    }

    public int hashCode() {
        return 17 * this.id.hashCode() ^ (this.sort == null ? 0 : this.sort.hashCode());
    }

    public boolean isAmbiguous() {
        return this.sort == null;
    }

    @Override
    public boolean canDeclare(String s) {
        return s.equals(this.id.toString());
    }

    public boolean equals(Object obj) {
        return obj instanceof variableNode ? this.equals((variableNode)obj) : (obj instanceof variable ? this.equals((variable)obj) : false);
    }

    public boolean equals(variableNode vn) {
        return vn != null && this.id.equals(vn.id) && this.sort.equals(vn.sort);
    }

    public boolean equals(variable v) {
        return v != null && this.id.equals(v.id()) && this.sort.equals(v.sort());
    }

    public void setDeclaration(variableNode dec, variable v) {
        if (this.declaration != null || this.sort == null || this.sort.makeAbstract() == null) {
            System.out.println("Setting declaration for " + this);
            if (this.declaration != null) {
                System.out.println("Non-null declaration");
            }
            if (this.sort == null) {
                System.out.println("Null sort");
            } else if (this.sort.makeAbstract() == null) {
                System.out.println("Null abstract sort");
            }
            throw new InternalError("variableNode.setDeclaration");
        }
        variableNode variableNode2 = this.declaration = dec == null ? this : dec;
        if (this.theVariable != null) {
            return;
        }
        this.theVariable = dec == null ? v : dec.theVariable;
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        return this.sort == null ? pp.print(this.id) : pp.fill().print(this.id).put(":").blank().print(this.sort).end();
    }

    @Override
    public int compareTo(variableNode v) {
        if (!this.isDeclaration() || !v.isDeclaration()) {
            throw new InternalError("variableNode.compareTo");
        }
        int result = this.theVariable.compareTo(v.theVariable);
        return result == 0 ? this.scope().compareTo(v.scope()) : result;
    }
}

