/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.assertionNode;
import com.veromodo.tioa.parser.automatonDefNode;
import com.veromodo.tioa.parser.compositionNode;
import com.veromodo.tioa.parser.funcDeclNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.specs;
import com.veromodo.tioa.parser.vocabNode;
import com.veromodo.tioa.util.error;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class unitNode
extends Node {
    private Node unit;
    private kind unitKind;
    private String fileName;
    private funcDeclNode[] funcVector;

    public kind unitKind() {
        return this.unitKind;
    }

    public String fileName() {
        return this.fileName;
    }

    public unitNode() {
    }

    public unitNode(String specName, Node.status status2) {
        this.fileName = String.valueOf(specName) + ".tioa";
        ltoken tok = new ltoken(specName, Scope.root().makeSubscope("dummy automaton " + specName));
        this.unitKind = kind.automaton;
        this.unit = new automatonDefNode(tok);
        this.setStatus(status2);
        this.unit.setStatus(status2);
        this.setScope(tok.scope());
        specs.put(this);
    }

    public unitNode tag(vocabNode n) {
        this.unit = n;
        this.unitKind = kind.vocabulary;
        this.locs(n);
        int i = 0;
        while (i < n.nImports()) {
            specs.needSource(n.imports(i).id().toString());
            ++i;
        }
        n.setScope();
        if (!specs.put(this)) {
            error.msg(n.name(), "duplicate vocabulary definition for " + n.name());
        }
        return this;
    }

    public unitNode tag(ListNode<funcDeclNode> n) {
        this.unit = n;
        this.unitKind = kind.funcdecls;
        this.locs(n);
        Scope sc = Scope.root().makeSubscope(Scope.varsOnly, "funcDecl");
        int i = 0;
        while (i < n.size()) {
            n.elementAt(i).setScope(sc);
            ++i;
        }
        specs.put(this);
        return this;
    }

    public unitNode tag(automatonDefNode n) {
        this.unit = n;
        this.unitKind = kind.automaton;
        this.locs(n);
        int i = 0;
        while (i < n.nImports()) {
            specs.needSource(n.imports(i).id().toString());
            ++i;
        }
        if (n.isComposite()) {
            compositionNode c = n.compositionBody();
            int i2 = 0;
            while (i2 < c.nElems()) {
                specs.needSource(c.elem(i2).automatonName().toString());
                ++i2;
            }
        }
        n.setScope();
        if (!specs.put(this)) {
            error.msg(n.name(), "duplicate automaton definition for " + n.name());
        }
        return this;
    }

    public unitNode tag(assertionNode n) {
        this.unit = n;
        this.unitKind = kind.assertion;
        this.locs(n);
        switch (n.kind()) {
            case 1: {
                specs.needSource(n.invar().name().toString());
                break;
            }
            case 2: {
                specs.needSource(n.simul().from().toString());
                specs.needSource(n.simul().to().toString());
                break;
            }
            default: {
                throw new InternalError("unitNode: assertionNode");
            }
        }
        n.setScope(Scope.root().makeSubscope("assertion"));
        specs.put(this);
        return this;
    }

    public vocabNode vocabulary() {
        if (this.unitKind != kind.vocabulary) {
            throw new InternalError("unitNode.vocabulary");
        }
        return (vocabNode)this.unit;
    }

    public funcDeclNode[] funcDecls() {
        if (this.unitKind != kind.funcdecls) {
            throw new InternalError("unitNode.funcDecls");
        }
        if (this.funcVector == null) {
            ListNode f = (ListNode)this.unit;
            this.funcVector = (funcDeclNode[])f.toArray(new funcDeclNode[f.size()]);
        }
        return this.funcVector;
    }

    public automatonDefNode automaton() {
        if (this.unitKind != kind.automaton) {
            throw new InternalError("unitNode.automaton");
        }
        return (automatonDefNode)this.unit;
    }

    public assertionNode assertion() {
        if (this.unitKind != kind.assertion) {
            throw new InternalError("unitNode.assertion");
        }
        return (assertionNode)this.unit;
    }

    @Override
    public Node.status status() {
        return this.unit == null ? super.status() : this.unit.status();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum kind {
        assertion,
        automaton,
        funcdecls,
        vocabulary;

    }
}

