/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.automaton.funcDecl;
import com.veromodo.tioa.automaton.trajectory;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.Abstractify;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.funcDeclNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.termNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class trajectoryNode
extends Node
implements Abstractifiable<trajectory> {
    private ltoken name;
    private termNode[] invariants;
    private termNode stopWhen;
    private funcDeclNode[] funcDecls;
    private termNode[] evolvePredicates;
    private trajectory theTrajectory;

    public ltoken name() {
        return this.name;
    }

    public int nInvariants() {
        return this.invariants.length;
    }

    public termNode invariant(int n) {
        return this.invariants[n];
    }

    public termNode stopWhen() {
        return this.stopWhen;
    }

    public int nFuncDecls() {
        return this.funcDecls.length;
    }

    public funcDeclNode funcDecl(int n) {
        return this.funcDecls[n];
    }

    public int nEvolvePredicates() {
        return this.evolvePredicates.length;
    }

    public termNode evolvePredicate(int n) {
        return this.evolvePredicates[n];
    }

    @Override
    public trajectory makeAbstract() {
        if (this.theTrajectory == null) {
            this.theTrajectory = new trajectory(this.name.toString(), (funcDecl[])Abstractify.map((Abstractifiable[])this.funcDecls, (Object[])new funcDecl[this.funcDecls.length]), (term[])Abstractify.map((Abstractifiable[])this.invariants, (Object[])new term[this.invariants.length]), Abstractify.predicate(this.stopWhen), (term[])Abstractify.map((Abstractifiable[])this.evolvePredicates, (Object[])new term[this.evolvePredicates.length]));
        }
        return this.theTrajectory;
    }

    public trajectoryNode set(ltoken t, ltoken name) {
        this.loc1(t);
        this.name = name;
        return this;
    }

    public trajectoryNode set(trajectoryNode tr) {
        this.loc2(tr);
        this.funcDecls = tr.funcDecls == null ? new funcDeclNode[]{} : tr.funcDecls;
        this.invariants = tr.invariants == null ? new termNode[]{} : tr.invariants;
        this.stopWhen = tr.stopWhen;
        this.evolvePredicates = tr.evolvePredicates;
        return this;
    }

    public trajectoryNode fct(ListNode<funcDeclNode> f) {
        this.funcDecls = (funcDeclNode[])f.toArray(new funcDeclNode[f.size()]);
        return this;
    }

    public trajectoryNode inv(ListNode<termNode> invariants) {
        this.invariants = (termNode[])invariants.toArray(new termNode[invariants.size()]);
        return this;
    }

    public trajectoryNode st(termNode stopWhen) {
        this.stopWhen = stopWhen;
        return this;
    }

    public trajectoryNode ev(ListNode<termNode> p) {
        this.loc2(p);
        this.evolvePredicates = (termNode[])p.toArray(new termNode[p.size()]);
        return this;
    }

    @Override
    public void setScope(Scope statesScope) {
        this.name.setScope(statesScope);
        Scope trajScope = statesScope.makeSubscope("definition of trajectory " + this.name);
        super.setScope(trajScope);
        int i = 0;
        while (i < this.funcDecls.length) {
            this.funcDecls[i].setScope(trajScope);
            ++i;
        }
        i = 0;
        while (i < this.invariants.length) {
            this.invariants[i].setScope(trajScope);
            ++i;
        }
        if (this.stopWhen != null) {
            this.stopWhen.setScope(trajScope);
        }
        i = 0;
        while (i < this.evolvePredicates.length) {
            this.evolvePredicates[i].setScope(trajScope);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof trajectoryNode ? this.equals((trajectoryNode)obj) : false;
    }

    public boolean equals(trajectoryNode t) {
        if (t == this) {
            return true;
        }
        if (this.theTrajectory == null != (t.theTrajectory == null)) {
            return true;
        }
        if (this.theTrajectory != null && t.theTrajectory != null) {
            return this.theTrajectory.equals(t.theTrajectory);
        }
        return false;
    }
}

