/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.parser.lexer;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.util.location;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java_cup.runtime.Symbol;

public class tokenizer
extends lexer {
    Hashtable<String, ltoken> map;
    String[] identifiers = new String[]{"\\alpha", "\\beta", "\\gamma", "\\delta", "\\epsilon", "\\zeta", "\\eta", "\\theta", "\\iota", "\\kappa", "\\lambda", "\\mu", "\\nu", "\\xi", "\\pi", "\\rho", "\\sigma", "\\tau", "\\upsilon", "\\phi", "\\chi", "\\psi", "\\omega", "\\Gamma", "\\Delta", "\\Theta", "\\Lambda", "\\Xi", "\\Pi", "\\Sigma", "\\Upsilon", "\\Phi", "\\Psi", "\\Omega", "\\infty", "\\bot", "\\top"};
    String[] openSyms = new String[]{"\\(", "\\<", "\\langle", "\\lceil", "\\lfloor"};
    String[] closeSyms = new String[]{"\\)", "\\>", "\\rangle", "\\rceil", "\\rfloor"};

    public tokenizer(Reader I) {
        super(I);
        this.wordChars(95, 95);
        this.wordChars(39, 39);
        this.opChars("!#$&*+-.<=>?@^|~");
        this.commentChar(37);
        this.escapeChar('\\');
        this.define("\\/");
        this.define("/\\");
        this.define("__");
        this.define(":=");
        this.map = new Hashtable();
        int i = 0;
        while (i < this.identifiers.length) {
            this.enter(this.identifiers[i], 97);
            ++i;
        }
        i = 0;
        while (i < this.openSyms.length) {
            this.enter(this.openSyms[i], 93);
            ++i;
        }
        i = 0;
        while (i < this.closeSyms.length) {
            this.enter(this.closeSyms[i], 94);
            ++i;
        }
        this.enter("\\A", 99);
        this.enter("/\\", 76);
        this.enter("->", 7);
        this.enter("/", 86);
        this.enter(".", 95);
        this.enter("=", 81);
        this.enter("\\E", 100);
        this.enter(">", 79);
        this.enter(">=", 80);
        this.enter("<=>", 73);
        this.enter("=>", 74);
        this.enter("<", 77);
        this.enter("<=", 78);
        this.enter("__", 2);
        this.enter("-", 84);
        this.enter("~=", 82);
        this.enter("\\/", 75);
        this.enter("*", 83);
        this.enter("**", 87);
        this.enter("*", 85);
        this.enter("else", 72);
        this.enter("enumeration", 20);
        this.enter("for", 23);
        this.enter("if", 70);
        this.enter("of", 36);
        this.enter("then", 71);
        this.enter("tuple", 50);
        this.enter("union", 53);
    }

    public tokenizer(Reader I, String fileName) {
        this(I);
        this.file = fileName;
    }

    public Symbol nextToken() throws IOException {
        this.nextLexeme();
        switch (this.ltype) {
            case 58: {
                return this.make(96, ":");
            }
            case 44: {
                return this.make(3, ",");
            }
            case 123: {
                return this.make(89, "{");
            }
            case 91: {
                return this.make(91, "[");
            }
            case 40: {
                return this.make(5, "(");
            }
            case 125: {
                return this.make(90, "}");
            }
            case 93: {
                return this.make(92, "]");
            }
            case 41: {
                return this.make(6, ")");
            }
            case 59: {
                return this.make(4, ";");
            }
            case -4: {
                return this.make(0, "EOF");
            }
            case -3: {
                return this.make(98, this.lval);
            }
            case -6: 
            case -2: 
            case -1: {
                ltoken t = this.map.get(this.lval.toLowerCase());
                if (t != null) {
                    return this.make(t.sym, t.str_val);
                }
                if (this.ltype == -2) {
                    return this.make(97, this.lval);
                }
                return this.make(88, this.lval);
            }
            case -5: {
                ltoken t = this.map.get(this.lval);
                if (t != null) {
                    return this.make(t.sym, t.str_val);
                }
                return this.make(88, this.lval);
            }
            case 10: {
                throw new InternalError();
            }
            case -7: {
                throw new InternalError();
            }
        }
        return this.make(88, this.lval);
    }

    void enter(String s, int code) {
        this.map.put(s, this.make(code, s));
    }

    ltoken make(int code, String s) {
        location loc = new location(this.file, this.lexemeLineNo, this.lexemeColNo, this.lastLineNo, this.lastColNo);
        return new ltoken(code, s, loc);
    }

    private static void print(ltoken t) {
        System.out.println("line " + t.loc().startLine() + ", column " + t.loc().startCol() + ", sym " + t.sym + ": " + t.str_val);
    }

    public static void main(String[] args) {
        tokenizer scan = new tokenizer(new InputStreamReader(System.in));
        try {
            ltoken t = (ltoken)scan.nextToken();
            while (t.sym != 0) {
                tokenizer.print(t);
                t = (ltoken)scan.nextToken();
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

