/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.nameNode;
import com.veromodo.tioa.parser.quantifierNode;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.parser.variableNode;
import com.veromodo.tioa.util.error;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class termNode
extends Node
implements Abstractifiable<term> {
    private int kind;
    public static final int ZEROARY = 2;
    private nameNode id;
    private termNode[] args;
    private quantifierNode qfr;
    private termNode subterm;
    private sortNode qual;
    private boolean parens = false;
    private term theTerm;
    private sort theSort;
    private int hashVal = 0;

    public int kind() {
        return this.kind;
    }

    public nameNode id() {
        if (this.kind != 0 && this.kind != 2) {
            throw new InternalError("termNode.id: bad id " + this.id + ", kind " + this.kind);
        }
        return this.id;
    }

    public int nArgs() {
        return this.kind == 0 ? this.args.length : 0;
    }

    public termNode arg(int n) {
        return this.args[n];
    }

    public quantifierNode qfr() {
        if (this.kind != 1) {
            throw new InternalError("termNode.qfr");
        }
        return this.qfr;
    }

    public termNode subterm() {
        if (this.kind != 1) {
            throw new InternalError("termNode.subkterm");
        }
        return this.subterm;
    }

    public sortNode qual() {
        return this.qual;
    }

    public boolean parens() {
        return this.parens;
    }

    @Override
    public term makeAbstract() {
        if (this.theTerm == null) {
            throw new InternalError("termNode.makeAbstract() on term with ID " + this.id);
        }
        return this.theTerm;
    }

    public sort makeAbstractSort() {
        return this.theSort;
    }

    public termNode() {
    }

    public termNode(variableNode vn) {
        this.varop(vn.id());
        this.qual = vn.sort();
        this.setScope(vn.scope());
    }

    public termNode varop(ltoken t) {
        this.kind = 2;
        this.id = new nameNode(0, t);
        this.args = new termNode[0];
        this.locs(t);
        return this;
    }

    public termNode fct(ltoken f, ListNode<termNode> t, ltoken p) {
        this.kind = 0;
        this.args = (termNode[])t.toArray(new termNode[t.size()]);
        this.id = nameNode.makeFunction(f.toString(), this.args.length, f.scope());
        this.id.locs(f);
        this.locs(f, p);
        return this;
    }

    public termNode fct(ltoken f, termNode t, ltoken p) {
        this.kind = 0;
        this.args = new termNode[1];
        this.args[0] = t;
        this.id = nameNode.makeFunction(f.toString(), 1, f.scope());
        this.id.locs(f);
        this.locs(f, p);
        return this;
    }

    public termNode qfr(quantifierNode q, termNode t) {
        this.kind = 1;
        this.qfr = q;
        this.subterm = t;
        this.args = new termNode[0];
        this.locs(q, t);
        return this;
    }

    public termNode mix(ltoken open, ListNode<termNode> terms, ltoken close) {
        this.kind = 0;
        this.args = (termNode[])terms.toArray(new termNode[terms.size()]);
        this.id = new nameNode(open.scope());
        this.id.mix(null, open, this.args.length, close, null);
        this.locs(open, close);
        return this;
    }

    public termNode mix(termNode tn, ltoken open, ListNode<termNode> terms, ltoken close) {
        this.kind = 0;
        this.args = new termNode[terms.size() + 1];
        this.args[0] = tn;
        int i = 0;
        while (i < terms.size()) {
            this.args[i + 1] = terms.elementAt(i);
            ++i;
        }
        this.id = new nameNode(open.scope());
        this.id.mix(true, open, this.args.length - 1, close, false);
        this.locs(tn.loc(), close);
        return this;
    }

    public termNode mix1(termNode before, termNode tn) {
        this.copy(tn);
        this.id.addBefore();
        termNode[] oldArgs = this.args;
        this.args = new termNode[oldArgs.length + 1];
        this.args[0] = before;
        System.arraycopy(oldArgs, 0, this.args, 1, oldArgs.length);
        this.loc1(before);
        return this;
    }

    public termNode mix2(termNode tn, termNode after) {
        this.copy(tn);
        this.id.addAfter();
        termNode[] oldArgs = this.args;
        this.args = new termNode[oldArgs.length + 1];
        System.arraycopy(oldArgs, 0, this.args, 0, oldArgs.length);
        this.args[oldArgs.length] = after;
        this.loc2(after);
        return this;
    }

    public termNode op(ltoken op, termNode t) {
        this.kind = 0;
        this.id = new nameNode(7, op);
        termNode[] args1 = new termNode[]{t};
        this.args = args1;
        this.locs(op, t);
        return this;
    }

    public termNode op(termNode t, ltoken op) {
        this.kind = 0;
        this.id = new nameNode(6, op);
        termNode[] args1 = new termNode[]{t};
        this.args = args1;
        this.locs(t, op);
        return this;
    }

    public termNode op(termNode t1, ltoken op, termNode t2) {
        this.kind = 0;
        this.id = new nameNode(3, op);
        termNode[] args1 = new termNode[]{t1, t2};
        this.args = args1;
        this.locs(t1, t2);
        return this;
    }

    public termNode iop(termNode t1, ltoken op, termNode t2) {
        this.op(t1, op, t2);
        if (!(t1.id == null || t1.id.kind() != 3 || t1.parens || t1.id.isDot() || t1.id.equals(this.id))) {
            error.msg(op, "need parentheses to specify associativity");
        }
        return this;
    }

    public void op(ltoken op, termNode t1, termNode t2, termNode t3) {
        this.kind = 0;
        this.id = new nameNode(op.scope());
        this.id.ite(op, op);
        termNode[] args1 = new termNode[]{t1, t2, t3};
        this.args = args1;
        this.locs(this.id, t3);
    }

    public void qual(sortNode sn) {
        if (this.qual != null && !this.qual.equals(sn)) {
            error.msg(sn, "cannot specify two different types for the same term");
        }
        this.qual = sn;
        this.parens = false;
        this.loc2(sn);
    }

    public void sel(termNode t, ltoken dot, ltoken id) {
        this.kind = 0;
        this.id = new nameNode(id.scope());
        this.id.sel(null, dot, id);
        termNode[] args1 = new termNode[]{t};
        this.args = args1;
        this.locs(t, id);
    }

    public void lcopy(ltoken f, termNode t) {
        this.copy(t);
        this.locs(f, t);
    }

    public termNode copy(termNode t) {
        this.kind = t.kind;
        this.id = t.id;
        this.args = t.args;
        this.qfr = t.qfr;
        this.subterm = t.subterm;
        this.qual = t.qual;
        this.parens = t.parens;
        this.locs(t.loc());
        return this;
    }

    public void paren(termNode t) {
        this.copy(t);
        this.parens = true;
    }

    @Override
    public void setScope(Scope s) {
        if (this.qfr == null) {
            super.setScope(s);
            if (this.id != null) {
                this.id.setScope(s);
            }
            if (this.qual != null) {
                this.qual.setScope(s);
            }
            int n = 0;
            while (n < this.args.length) {
                this.args[n].setScope(s);
                ++n;
            }
        } else {
            s = s.makeSubscope(Scope.boundVarsOnly, "quantifier");
            super.setScope(s);
            this.qfr.setScope(s);
            this.subterm.setScope(s);
        }
    }

    public boolean disambiguated() {
        return this.theTerm != null;
    }

    public void disambiguate(term t, sort s) {
        if (this.theTerm != null || t == null) {
            throw new InternalError("termNode.disambiguate");
        }
        this.theTerm = t;
        this.theSort = s;
    }

    public sort sort() {
        return this.theSort != null ? this.theSort : (this.theTerm != null ? this.theTerm.sort() : null);
    }

    public boolean equals(Object obj) {
        return obj instanceof termNode ? this.equals((termNode)obj) : false;
    }

    public boolean equals(termNode t) {
        if (t == this) {
            return true;
        }
        if (t == null || this.hashCode() != t.hashCode()) {
            return false;
        }
        if (this.theTerm == null != (t.theTerm == null)) {
            return true;
        }
        if (this.theSort != null && t.theSort != null) {
            return this.theSort.equals(t.theSort);
        }
        if (this.theTerm != null && t.theTerm != null) {
            return this.theTerm.equals(t.theTerm);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashVal == 0) {
            switch (this.kind) {
                case 0: {
                    this.hashVal = this.id.hashCode();
                    int i = 0;
                    while (i < this.args.length) {
                        this.hashVal = 17 * this.hashVal ^ this.args[i].hashCode();
                        ++i;
                    }
                    break;
                }
                case 1: {
                    this.hashVal = 17 * this.qfr.hashCode() ^ this.subterm.hashCode();
                    break;
                }
                case 2: {
                    this.hashVal = this.id.hashCode();
                    break;
                }
                default: {
                    throw new InternalError("termNode.hashCode");
                }
            }
        }
        return this.hashVal;
    }

    @Override
    public String toString() {
        return "termNode: " + this.id;
    }
}

