/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.parser.automatonDefNode;
import com.veromodo.tioa.parser.builtIns;
import com.veromodo.tioa.parser.unitNode;
import com.veromodo.tioa.parser.vocabNode;
import java.util.Hashtable;
import java.util.Vector;

public class specs {
    private static Vector<String> toParse = new Vector();
    private static Vector<String> primaryFiles = new Vector();
    private static Vector<String> parsed = new Vector();
    private static int nextToParse = 0;
    private static Vector<unitNode> units = new Vector();
    private static Hashtable<String, vocabNode> vocabs = new Hashtable();
    private static Hashtable<String, automatonDefNode> automata = new Hashtable();

    public static int nToParse() {
        return toParse.size();
    }

    public static int nUnits() {
        return units.size();
    }

    public static unitNode unit(int n) {
        return units.elementAt(n);
    }

    public static boolean put(unitNode n) {
        units.addElement(n);
        String specName = "";
        switch (n.unitKind()) {
            case vocabulary: {
                String vocabName = n.vocabulary().name().toString();
                if (vocabs.put(vocabName, n.vocabulary()) != null) {
                    return false;
                }
                parsed.addElement(vocabName.intern());
                return true;
            }
            case automaton: {
                String automatonName = n.automaton().name().toString();
                if (automata.put(automatonName, n.automaton()) != null) {
                    return false;
                }
                parsed.addElement(automatonName.intern());
                return true;
            }
        }
        return true;
    }

    public static vocabNode getVocabulary(String vocabName) {
        vocabNode vn = vocabs.get(vocabName);
        if (vn == null && (vn = builtIns.getVocab(vocabName)) != null) {
            vocabs.put(vocabName, vn);
        }
        return vn;
    }

    public static boolean parsedVocabulary(String vocabName) {
        return parsed.contains(vocabName);
    }

    public static automatonDefNode getAutomaton(String name) {
        return automata.get(name);
    }

    public static void needPrimaryFile(String fName) {
        String specName = fName.substring(0, fName.length() - ".tioa".length());
        if (!toParse.contains(specName) && !parsed.contains(specName)) {
            toParse.addElement(specName);
            primaryFiles.addElement(fName);
        }
    }

    public static boolean primary(String name) {
        return primaryFiles.contains(name);
    }

    public static void needSource(String name) {
        if (!toParse.contains(name = name.intern()) && !parsed.contains(name)) {
            toParse.addElement(name);
        }
    }

    public static String nextToParse() {
        while (nextToParse < toParse.size()) {
            if (!parsed.contains(toParse.elementAt(nextToParse))) {
                return toParse.elementAt(nextToParse++);
            }
            ++nextToParse;
        }
        return "";
    }
}

