/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.checker.Declarable;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.sortConstructorNode;
import com.veromodo.tioa.parser.sortDclNode;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.prettyprinter;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class sortNode
extends sortDclNode
implements Prettyprintable,
Comparable<sortNode>,
Declarable<sortNode>,
Abstractifiable<sort> {
    private ltoken id;
    private sortConstructorNode constructor;
    private sortNode[] subsorts;
    private int hashVal;
    private boolean restricted = false;
    private sortNode declaration;
    private sort theSort;

    public ltoken id() {
        if (this.subsorts.length > 0) {
            throw new InternalError("sortNode.id");
        }
        return this.id;
    }

    public sortConstructorNode constructor() {
        assert (this.subsorts.length > 0);
        return this.constructor;
    }

    public int nSubsorts() {
        return this.subsorts.length;
    }

    public sortNode subsort(int n) {
        return this.subsorts[n];
    }

    public boolean restricted() {
        return this.restricted;
    }

    public sortNode restrict() {
        this.restricted = true;
        return this;
    }

    public sortNode declaration() {
        return this.declaration;
    }

    public boolean isDeclaration() {
        return this == this.declaration;
    }

    @Override
    public sort makeAbstract() {
        return this.theSort;
    }

    public sortNode() {
    }

    public sortNode(ltoken t) {
        this.set(t);
        this.setScope(t.scope());
    }

    public sortNode(ltoken t, Scope sc) {
        this.id = t;
        this.subsorts = new sortNode[0];
        this.setScope(sc);
        this.computeHash();
    }

    public sortNode(String s, Scope sc) {
        this.id = new ltoken(s, sc);
        this.subsorts = new sortNode[0];
        this.setScope(sc);
        this.computeHash();
    }

    public sortNode(String s, sortNode[] v, Scope sc) {
        if (v.length == 0) {
            this.id = new ltoken(s, sc);
        } else {
            this.constructor = new sortConstructorNode(s, v.length, sc);
        }
        this.subsorts = v;
        this.setScope(sc);
        this.computeHash();
    }

    public sortNode(ltoken t, sortNode[] v) {
        this(t.toString(), v, t.scope());
    }

    public sortNode(sortConstructorNode c, sortNode[] v) {
        this.constructor = c;
        this.subsorts = v;
        super.setScope(c.scope());
        this.computeHash();
    }

    public sortNode changeConstructor(sortConstructorNode con) {
        return new sortNode(con, this.subsorts);
    }

    public sortNode(sort s, Scope sc) {
        if (s.nSubsorts() == 0) {
            this.id = new ltoken(-1, s.id(), sc);
        } else {
            this.constructor = new sortConstructorNode(s.constructor().id(), s.nSubsorts(), sc);
        }
        this.subsorts = new sortNode[s.nSubsorts()];
        int i = 0;
        while (i < s.nSubsorts()) {
            this.subsorts[i] = new sortNode(s.subsort(i), sc);
            ++i;
        }
        this.theSort = s;
        this.computeHash();
        this.setScope(sc);
    }

    public sortNode changeId(String s) {
        return new sortNode(s, this.subsorts, this.scope());
    }

    public void set(ltoken t) {
        this.id = t;
        this.subsorts = new sortNode[0];
        this.locs(this.id);
        this.computeHash();
    }

    public sortNode set(ltoken c, ListNode<sortNode> list) {
        this.constructor = new sortConstructorNode(c, list.size());
        this.subsorts = (sortNode[])list.toArray(new sortNode[list.size()]);
        this.locs(c, list);
        this.computeHash();
        return this;
    }

    public void set(ltoken c, ListNode<sortNode> list, ltoken b) {
        this.constructor = new sortConstructorNode(c, list.size());
        this.subsorts = (sortNode[])list.toArray(new sortNode[list.size()]);
        this.locs(c, b);
        this.computeHash();
    }

    public void copy(sortNode sn) {
        this.id = sn.id;
        this.constructor = sn.constructor;
        this.subsorts = sn.subsorts;
        this.restricted = sn.restricted;
        this.locs(sn);
        this.computeHash();
    }

    @Override
    public void setScope(Scope s) {
        super.setScope(s);
        if (this.id != null) {
            this.id.setScope(s);
        } else {
            this.constructor.setScope(s);
        }
        int n = 0;
        while (n < this.subsorts.length) {
            this.subsorts[n].setScope(s);
            ++n;
        }
    }

    public boolean isType() {
        if (this.subsorts.length > 0) {
            return false;
        }
        return this.id.sym == 51 || this.id.sym == -1 && this.id.toString().equals(sort.typeSort);
    }

    public boolean equals(Object obj) {
        return obj instanceof sortNode ? this.equals((sortNode)obj) : (obj instanceof sort ? this.equals((sort)obj) : false);
    }

    public boolean equals(sortNode sn) {
        if (sn == null || this.hashVal != sn.hashVal || this.subsorts.length != sn.subsorts.length) {
            return false;
        }
        if (this.id != null && !this.id.equals(sn.id)) {
            return false;
        }
        if (this.constructor != null && !this.constructor.equals(sn.constructor)) {
            return false;
        }
        int i = 0;
        while (i < this.subsorts.length) {
            if (!this.subsorts[i].equals(sn.subsorts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(sort s) {
        if (s == null || this.subsorts.length != s.nSubsorts()) {
            return false;
        }
        if (s.isSimple()) {
            return this.id.toString().equals(s.id());
        }
        if (!this.id.toString().equals(s.constructor())) {
            return false;
        }
        int i = 0;
        while (i < this.subsorts.length) {
            if (!this.subsorts[i].equals(s.subsort(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean canDeclare(sortNode sn) {
        return this.equals(sn);
    }

    public int hashCode() {
        return this.hashVal;
    }

    public void setDeclaration(sortNode dec) {
        assert (this.declaration == null);
        if (dec == null) {
            this.declaration = this;
            if (this.theSort == null) {
                int n = this.subsorts.length;
                if (n == 0) {
                    this.theSort = new sort(this.id.toString());
                } else {
                    sort[] s = new sort[n];
                    int i = 0;
                    while (i < n) {
                        s[i] = this.subsorts[i].theSort;
                        assert (s[i] != null);
                        ++i;
                    }
                    this.theSort = new sort(this.constructor.makeAbstract(), s);
                }
            }
        } else {
            assert (dec.theSort != null);
            this.declaration = dec;
            if (this.theSort == null) {
                this.theSort = dec.theSort;
            } else assert (this.theSort.equals(dec.theSort));
        }
    }

    private void computeHash() {
        this.hashVal = this.id == null ? this.constructor.hashCode() : this.id.hashCode();
        int i = 0;
        while (i < this.subsorts.length) {
            this.hashVal = 17 * this.hashVal ^ this.subsorts[i].hashCode();
            ++i;
        }
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        pp.fill();
        if (this.id == null) {
            pp.print(this.constructor);
        } else {
            pp.put(this.id.toString());
        }
        if (this.subsorts.length > 0) {
            pp.fill(1).put("[").list(this.subsorts, ",").put("]").end();
        }
        return pp.end();
    }

    @Override
    public int compareTo(sortNode s) {
        if (!this.isDeclaration() || !s.isDeclaration()) {
            throw new InternalError("sortNode.compareTo");
        }
        int result = this.theSort.compareTo(s.theSort);
        return result == 0 ? this.scope().compareTo(s.scope()) : result;
    }

    @Override
    public String toString() {
        String asString;
        if (this.theSort == null) {
            asString = (this.id == null ? this.constructor.id() : this.id).toString();
            if (this.subsorts != null && this.subsorts.length != 0) {
                int i = 0;
                while (i < this.subsorts.length) {
                    asString = String.valueOf(asString) + (i == 0 ? "[" : ",") + this.subsorts[i].toString();
                    ++i;
                }
                asString = String.valueOf(asString) + "]";
            }
        } else {
            asString = this.theSort.toString();
        }
        return asString;
    }

    public static int compare(sortNode s1, sortNode s2) {
        if (s1.nSubsorts() > 0 || s2.nSubsorts() > 0) {
            return -2;
        }
        return sort.compareIds(s1.id().toString(), s2.id().toString());
    }

    public static boolean isSubsort(sortNode s1, sortNode s2) {
        int c = sortNode.compare(s1, s2);
        return c == -2 && s1.equals(s2) || c == -1 || c == 0;
    }

    public boolean subsortIn(Vector<sortNode> vec) {
        Iterator<sortNode> i = vec.iterator();
        while (i.hasNext()) {
            if (!sortNode.isSubsort(i.next(), this)) continue;
            return true;
        }
        return false;
    }
}

