/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.automaton.simproof;
import com.veromodo.tioa.automaton.simulation;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.booleans;
import com.veromodo.tioa.notions.term;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.simProofNode;
import com.veromodo.tioa.parser.termNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class simulationNode
extends Node {
    private boolean forward;
    private ltoken from;
    private ltoken to;
    private termNode[] preds;
    private simProofNode proof;

    public boolean forward() {
        return this.forward;
    }

    public ltoken from() {
        return this.from;
    }

    public ltoken to() {
        return this.to;
    }

    public int nPredicates() {
        return this.preds.length;
    }

    public termNode predicate(int n) {
        return this.preds[n];
    }

    public simProofNode proof() {
        return this.proof;
    }

    public void set(ltoken kind2, ltoken from, ltoken to, ListNode<termNode> preds) {
        this.locs(kind2, preds);
        this.forward = kind2.sym == 24;
        this.from = from;
        this.to = to;
        this.preds = (termNode[])preds.toArray(new termNode[preds.size()]);
    }

    public void set(ltoken kind2, ltoken from, ltoken to, ListNode<termNode> preds, simProofNode proof) {
        this.locs(kind2, preds);
        this.forward = kind2.sym == 24;
        this.from = from;
        this.to = to;
        this.preds = (termNode[])preds.toArray(new termNode[preds.size()]);
        this.proof = proof;
    }

    @Override
    public void setScope(Scope s) {
        super.setScope(s);
        this.from.setScope(s);
        this.to.setScope(s);
        int n = 0;
        while (n < this.preds.length) {
            this.preds[n].setScope(s);
            ++n;
        }
        if (this.proof != null) {
            this.proof.setScope(s);
        }
    }

    public simulation makeAbstract() {
        term[] abstractPreds = new term[this.nPredicates()];
        int i = 0;
        while (i < this.nPredicates()) {
            abstractPreds[i] = this.predicate(i).makeAbstract();
            ++i;
        }
        simproof abstractProof = this.proof == null ? null : this.proof.makeAbstract();
        return new simulation(this.forward(), this.from.toString(), this.to.toString(), booleans.conjoin(abstractPreds), abstractProof);
    }
}

