/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.signature;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.prettyprinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class signatureNode
extends Node
implements Prettyprintable {
    private sortNode[] domain;
    private sortNode range;
    private signature theSignature;
    private int hashVal;

    public int arity() {
        return this.domain.length;
    }

    public sortNode domain(int n) {
        return this.domain[n];
    }

    public sortNode range() {
        return this.range;
    }

    public signature makeAbstract() {
        if (this.theSignature != null) {
            return this.theSignature;
        }
        sort[] dom = new sort[this.domain.length];
        int i = 0;
        while (i < this.domain.length) {
            dom[i] = this.domain[i].makeAbstract();
            if (dom[i] == null) {
                throw new InternalError("signatureNode.makeAbstract");
            }
            ++i;
        }
        if (this.range.makeAbstract() == null) {
            throw new InternalError("signatureNode.makeAbstract");
        }
        this.theSignature = new signature(this.range.makeAbstract(), dom);
        return this.theSignature;
    }

    public signatureNode() {
    }

    public signatureNode(sortNode rng) {
        this.domain = new sortNode[0];
        this.range = rng;
        this.locs(rng);
        this.setScope(rng.scope());
        this.computeHash();
    }

    public signatureNode(sortNode dom1, sortNode rng) {
        sortNode[] d = new sortNode[]{dom1};
        this.domain = d;
        this.range = rng;
        this.locs(dom1, rng);
        this.setScope(rng.scope());
        this.computeHash();
    }

    public signatureNode(sortNode dom1, sortNode dom2, sortNode rng) {
        sortNode[] d = new sortNode[]{dom1, dom2};
        this.domain = d;
        this.range = rng;
        this.locs(dom1, rng);
        this.setScope(rng.scope());
        this.computeHash();
    }

    public signatureNode(sortNode dom1, sortNode dom2, sortNode dom3, sortNode rng) {
        sortNode[] d = new sortNode[]{dom1, dom2, dom3};
        this.domain = d;
        this.range = rng;
        this.locs(dom1, rng);
        this.setScope(rng.scope());
        this.computeHash();
    }

    public signatureNode(sortNode[] dom, sortNode rng) {
        this.domain = dom;
        this.range = rng;
        this.setScope(rng.scope());
        this.computeHash();
    }

    public signatureNode(sortNode s, int n) {
        if (n < 0) {
            throw new InternalError("signatureNode: negative arity");
        }
        this.domain = new sortNode[n];
        int i = 0;
        while (i < n) {
            this.domain[i] = s;
            ++i;
        }
        this.range = s;
        this.setScope(s.scope());
        this.computeHash();
    }

    public signatureNode(signature s, Scope sc) {
        this.domain = new sortNode[s.arity()];
        int i = 0;
        while (i < s.arity()) {
            this.domain[i] = new sortNode(s.domain(i), sc);
            ++i;
        }
        this.range = new sortNode(s.range(), sc);
        this.computeHash();
        this.setScope(sc);
    }

    public void set(ListNode<sortNode> dom, sortNode rng) {
        this.domain = (sortNode[])dom.toArray(new sortNode[dom.size()]);
        this.range = rng;
        this.locs(dom, rng);
        this.computeHash();
    }

    public void set(ltoken t, sortNode rng) {
        this.domain = new sortNode[0];
        this.range = rng;
        this.locs(t, rng);
        this.computeHash();
    }

    @Override
    public void setScope(Scope s) {
        super.setScope(s);
        int n = 0;
        while (n < this.domain.length) {
            this.domain[n].setScope(s);
            ++n;
        }
        this.range.setScope(s);
    }

    public boolean equals(Object obj) {
        return obj instanceof signatureNode ? this.equals((signatureNode)obj) : (obj instanceof signature ? this.equals((signature)obj) : false);
    }

    public boolean equals(signatureNode sig) {
        if (this.hashVal != sig.hashVal || !this.range.equals(sig.range) || this.domain.length != sig.domain.length) {
            return false;
        }
        int i = 0;
        while (i < this.domain.length) {
            if (!this.domain[i].equals(sig.domain[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(signature sig) {
        if (!this.range.equals(sig.range()) || this.domain.length != sig.arity()) {
            return false;
        }
        int i = 0;
        while (i < this.domain.length) {
            if (!this.domain[i].equals(sig.domain(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashVal;
    }

    private void computeHash() {
        this.hashVal = this.range.hashCode();
        int i = 0;
        while (i < this.domain.length) {
            this.hashVal = 17 * this.hashVal ^ this.domain[i].hashCode();
            ++i;
        }
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        pp.fill();
        if (this.domain.length > 0) {
            pp.list(this.domain, ",").blank();
        }
        return pp.put("->").blank().print(this.range).end();
    }

    public boolean greaterThanOrEqual(signatureNode sig2) {
        int n = this.domain.length;
        if (n != sig2.arity()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (!sortNode.isSubsort(sig2.domain(i), this.domain(i))) {
                return false;
            }
            ++i;
        }
        return sortNode.isSubsort(this.range(), sig2.range());
    }
}

