/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.Unit;
import com.veromodo.tioa.notions.sort;
import com.veromodo.tioa.notions.sortEnum;
import com.veromodo.tioa.notions.sortTuple;
import com.veromodo.tioa.notions.sortUnion;
import com.veromodo.tioa.parser.FactoredListNode;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.Node;
import com.veromodo.tioa.parser.fieldNode;
import com.veromodo.tioa.parser.ltoken;
import com.veromodo.tioa.parser.sortNode;
import com.veromodo.tioa.util.location;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class shorthandNode
extends Node {
    private int kind;
    public static final int ENUM = 0;
    public static final int TUPLE = 1;
    public static final int UNION = 2;
    private ltoken[] elements;
    private fieldNode[] fields;
    private Unit theShorthand;

    public int kind() {
        return this.kind;
    }

    public int nElems() {
        return this.kind == 0 ? this.elements.length : this.fields.length;
    }

    public ltoken elem(int n) {
        if (this.kind != 0) {
            throw new InternalError("shorthandNode.elem");
        }
        return this.elements[n];
    }

    public fieldNode field(int n) {
        return this.fields[n];
    }

    public void abstractify(Unit u) {
        if (this.theShorthand != null) {
            throw new InternalError("shorthandNode.abstractify");
        }
        this.theShorthand = u;
        switch (this.kind) {
            case 0: {
                if (u instanceof sortEnum) {
                    return;
                }
            }
            case 1: {
                if (u instanceof sortTuple) {
                    return;
                }
            }
            case 2: {
                if (!(u instanceof sortUnion)) break;
                return;
            }
        }
        throw new InternalError("shorthandNode.abstractify");
    }

    public Unit makeAbstract() {
        if (this.theShorthand != null) {
            return this.theShorthand;
        }
        throw new InternalError("shorthandNode.makeAbstract");
    }

    public shorthandNode() {
    }

    public shorthandNode(ltoken[] elems) {
        this.kind = 0;
        this.elements = elems;
        this.setScope(elems[0].scope());
    }

    public shorthandNode(Vector<fieldNode> fns) {
        this.kind = 1;
        this.fields = new fieldNode[fns.size()];
        fns.copyInto(this.fields);
        super.setScope(this.fields[0].scope());
    }

    public shorthandNode(sortTuple st) {
        this.kind = 1;
        Scope sc = Scope.root().makeSubscope(Scope.varsOnly, "typeDef");
        location l = new location("CONSTRUCTED", 0, 0, 0, 0);
        this.fields = new fieldNode[st.nFields()];
        int i = 0;
        while (i < this.fields.length) {
            sort s = st.get(i).sig().range();
            sortNode sn = new sortNode(s, sc);
            this.fields[i] = new fieldNode(new ltoken(st.field(i), l), sn);
            this.fields[i].setScope(sc);
            ++i;
        }
        this.locs(l);
        this.setScope(sc);
        this.abstractify(st);
    }

    public shorthandNode tag(ltoken t, ListNode<ltoken> elems, ltoken b) {
        this.kind = 0;
        this.elements = (ltoken[])elems.toArray(new ltoken[elems.size()]);
        this.locs(t, b);
        return this;
    }

    public shorthandNode tag(ltoken t, FactoredListNode<fieldNode, ltoken> f, ltoken b) {
        this.kind = t.sym == 50 ? 1 : 2;
        this.fields = (fieldNode[])f.toArray(new fieldNode[f.size()]);
        this.locs(t, b);
        return this;
    }

    @Override
    public void setScope(Scope s) {
        super.setScope(s);
        int n = 0;
        while (n < this.nElems()) {
            if (this.kind == 0) {
                this.elements[n].setScope(s);
            } else {
                this.fields[n].setScope(s);
            }
            ++n;
        }
    }
}

