/*
 * Decompiled with CFR 0.152.
 */
package com.veromodo.tioa.parser;

import com.veromodo.tioa.checker.Declarable;
import com.veromodo.tioa.notions.Scope;
import com.veromodo.tioa.notions.opSym;
import com.veromodo.tioa.notions.operator;
import com.veromodo.tioa.parser.Abstractifiable;
import com.veromodo.tioa.parser.FactorNode;
import com.veromodo.tioa.parser.ListNode;
import com.veromodo.tioa.parser.nameNode;
import com.veromodo.tioa.parser.signatureNode;
import com.veromodo.tioa.util.Factorable;
import com.veromodo.tioa.util.Prettyprintable;
import com.veromodo.tioa.util.error;
import com.veromodo.tioa.util.prettyprinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class operatorNode
extends FactorNode
implements Prettyprintable,
Abstractifiable<operator>,
Comparable<operatorNode>,
Declarable<nameNode>,
Factorable {
    private nameNode id;
    private signatureNode sig;
    private operatorNode declaration;
    private operator theOperator;
    private int hashVal;

    public nameNode id() {
        return this.id;
    }

    public opSym sym() {
        return this.id.sym();
    }

    public signatureNode sig() {
        return this.sig;
    }

    public operatorNode declaration() {
        return this.declaration;
    }

    public boolean isDeclaration() {
        return this == this.declaration;
    }

    @Override
    public operator makeAbstract() {
        return this.theOperator;
    }

    public operatorNode() {
    }

    public operatorNode(nameNode nn, signatureNode sn) {
        this.set(nn, sn);
        this.setScope(nn.scope());
    }

    public operatorNode(operator op, Scope sc) {
        this.id = new nameNode(op.id(), sc);
        this.sig = new signatureNode(op.sig(), sc);
        this.setScope(sc);
        this.hashVal = 17 * this.id.hashCode() ^ (this.sig == null ? 0 : this.sig.hashCode());
        this.theOperator = op;
    }

    public void set(nameNode nn) {
        this.id = nn;
        this.locs(nn);
        this.hashVal = this.id.hashCode();
        this.setScope(nn.scope());
    }

    public void set(nameNode nn, signatureNode sn) {
        this.id = nn;
        this.sig = sn;
        this.locs(nn, sn);
        this.hashVal = 17 * this.id.hashCode() ^ (this.sig == null ? 0 : this.sig.hashCode());
        this.setScope(nn.scope());
    }

    @Override
    public void setScope(Scope s) {
        super.setScope(s);
        this.id.setScope(s);
        if (this.sig != null) {
            this.sig.setScope(s);
        }
    }

    public boolean isAmbiguous() {
        return this.sig == null;
    }

    public boolean isNumeral() {
        return this.sig != null && this.arity() == 0 && this.id.isNumeral();
    }

    public int arity() {
        if (this.sig == null) {
            throw new InternalError("operatorNode");
        }
        return this.sig.arity();
    }

    public boolean okArity() {
        if (this.sig == null || this.id.arity() == this.arity()) {
            return true;
        }
        if (this.id.arity() < 0 && (this.id.kind() == 1 || this.id.kind() == 10 && this.sig.arity() > 0 && this.sig.arity() < 3)) {
            this.id.setArity(this.arity());
            return true;
        }
        error.msg(this.id, "illegal identifier for " + this.arity() + "-ary operator " + this.id);
        return false;
    }

    @Override
    public boolean canDeclare(nameNode nn) {
        return nn == null ? false : (nn.arity() < 0 ? nn.equals(this.id) : nn.sym().equals(this.id.sym()));
    }

    public boolean equals(Object obj) {
        return obj instanceof operatorNode ? this.equals((operatorNode)obj) : (obj instanceof operator ? this.equals((operator)obj) : false);
    }

    public boolean equals(operatorNode op) {
        return this.hashVal == op.hashVal && this.id.sym().equals(op.id.sym()) && this.sig.equals(op.sig);
    }

    public boolean equals(operator op) {
        return this.id.sym().equals(op.id()) && this.sig.equals(op.sig());
    }

    public int hashCode() {
        return this.hashVal;
    }

    public void setDeclaration(operatorNode dec) {
        if (this.declaration != null) {
            throw new IllegalArgumentException();
        }
        operatorNode operatorNode2 = this.declaration = dec == null ? this : dec;
        if (this.id.kind() == 10) {
            this.id.sym().setKind(this.declaration.id().kind());
        }
        if (this.id.arity() < 0) {
            this.id.setArity(this.declaration.sig().arity());
        }
        operator operator2 = dec != null ? dec.theOperator : (this.theOperator = this.theOperator == null ? new operator(this.id.sym(), this.declaration.sig().makeAbstract()) : this.theOperator);
        if (dec == null) {
            this.theOperator.addDeclarationScope(this.scope());
        }
        if (this.sig == null) {
            this.sig = dec.sig;
        }
    }

    public static operatorNode extract(ListNode<nameNode> list, int n) {
        if (n < 0 || list.size() <= n) {
            throw new InternalError("operatorNode.extract");
        }
        return new operatorNode(list.elementAt(n), (signatureNode)list.info());
    }

    @Override
    public prettyprinter print(prettyprinter pp) {
        return this.sig == null ? pp.print(this.id) : pp.fill().print(this.id).put(":").blank().print(this.sig).end();
    }

    @Override
    public int compareTo(operatorNode op) {
        if (!this.isDeclaration() || !op.isDeclaration()) {
            throw new InternalError("operatorNode.compareTo");
        }
        int result = this.theOperator.compareTo(op.theOperator);
        return result == 0 ? this.scope().compareTo(op.scope()) : result;
    }

    public boolean canReplace(operatorNode op) {
        return this.id.sym().equals(op.id().sym()) && this.sig.greaterThanOrEqual(op.sig);
    }
}

